/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.datacollector;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorException;
import com.ebmwebsourcing.easierbsm.datacollector.api.DispatcherProviderEndpoint;
import com.ebmwebsourcing.easierbsm.datacollector.api.DispatcherService;
import com.ebmwebsourcing.easierbsm.datacollector.impl.DataCollectorEngineBehaviourImpl;
import com.ebmwebsourcing.easierbsm.datacollector.impl.DataCollectorEngineImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.BaseAdminEndpointBehaviourImpl;

import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;

public class ESBDataCollectorFactoryImpl implements ESBFactory {


	public static final String DISPATCHER_PROVIDER_ENDPOINT_NAME = "DispatcherProviderEndpoint";
	public static final String DISPATCHER_SERVICE_NAME = "DispacherService";
	public static final String DATA_COLLECTOR_COMPONENT_NAME = "DataCollector";
	public static final String DATA_COLLECTOR_NAMESPACE = "http://petals.ow2.org";
	
	
	private ESBFactoryImpl parentFactory = new ESBFactoryImpl();
	
	
	@Override
	public Node createNode(QName name,
			Configuration conf) throws ESBException {
		final Node node = parentFactory.createDefaultNode(name, conf);
		createDataCollector(node, this, conf);
		return node;
	}

	@SuppressWarnings({ "unused", "unchecked", "rawtypes" })
	public static void createDataCollector(final Node node, final ESBFactory factory, final Configuration conf) throws ESBException {
		try {
			final DataCollectorEngine dataCollectorEngine = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(
					new QName(DATA_COLLECTOR_NAMESPACE, DATA_COLLECTOR_COMPONENT_NAME),
					DataCollectorEngineImpl.class);
			dataCollectorEngine.addBehaviourClass(DataCollectorEngineBehaviourImpl.class);
			
			final String res = factory.getAdminEndpoint().findBehaviour(BaseAdminEndpointBehaviourImpl.class)
					.exposeServiceEndpointInSoap(
							new QName(DATA_COLLECTOR_NAMESPACE,
									DISPATCHER_SERVICE_NAME), DISPATCHER_PROVIDER_ENDPOINT_NAME);
			((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).initialize(res);
			
			DispatcherService service = dataCollectorEngine.createDispatcherService(new QName(DATA_COLLECTOR_NAMESPACE, DISPATCHER_SERVICE_NAME));

			DispatcherProviderEndpoint dispatcherProviderEndpoint = service.createDispatcherProviderEndpoint(DISPATCHER_PROVIDER_ENDPOINT_NAME);

			
			
			
		} catch (DataCollectorException e) {
			throw new ESBException(e);
		} catch (AdminExceptionMsg e) {
			throw new ESBException(e);
		}
	}

	@Override
	public Configuration getDefaultConfiguration() throws ESBException {
		return parentFactory.getDefaultConfiguration();
	}

	@Override
	public void addSpecificElements(QName arg0, Node arg1, Configuration arg2)
			throws ESBException {
		// do nothing
	}

	@Override
	public AdminEndpoint<?> getAdminEndpoint() {
		return parentFactory.getAdminEndpoint();
	}

}
