package com.ebmwebsourcing.easierbsm.datacollector.impl;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationConsumerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationConsumerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;

public class DataCollectorClientEndpointBehaviourImpl extends
NotificationConsumerEndpointBehaviourImpl implements NotificationConsumerEndpointBehaviour {

    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());


    private NotificationProducerEndpointBehaviour producerBehaviour;

    private SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour;

    /**
     * TODO For now we consider the only topic the datacollector knows is the RawReport topic ...
     * 
     */
    private QName topicUsed = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic","tns");
    private String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";
    
    
    public DataCollectorClientEndpointBehaviourImpl(
            ProviderEndpoint<? extends ProviderEndpointType> ep) {
        super(ep);

        producerBehaviour = (NotificationProducerEndpointBehaviour) this.getEndpoint().findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
        if(producerBehaviour == null) {
            log.severe("Internal Error: This endpoint " + this.getEndpointQName() + " has no producer behaviour to send notification");

        }

        subscriptionManagerBehaviour = (SubscriptionManagerEndpointBehaviour) this.getEndpoint().findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
        if(subscriptionManagerBehaviour == null) {
            log.severe("Internal Error: This endpoint " + this.getEndpointQName() + " has no producer behaviour to send notification");

        }


    }

    @Override
    public void notify(Notify request) throws WsnbException {

        try{
            Document notifyAsDom = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(request);
          
            final NotificationProducerThreadImpl notifier = new NotificationProducerThreadImpl(
                    producerBehaviour, subscriptionManagerBehaviour, notifyAsDom, topicUsed, dialect);

            notifier.start();


        }catch (Exception e) {
            if(e instanceof WsnbException){
                throw (WsnbException)e;
            }
            else{
                e.printStackTrace();
                log.severe(e.getLocalizedMessage());
            }
        }

    }

}
