/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.util.NotificationConsumerMock;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.ws.bus.NotificationProducer_BusProviderEventPort_Server;
import com.ebmwebsourcing.escapnote10.api.element.AlertNoteDefinition;
import com.ebmwebsourcing.esstar.management.UserManagementClient;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ObjectFactory;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementFromUrlRequest;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementResponse;
import easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault;
import easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easyesb.petalslink.com.data.admin._1.WrapSoapEndpoint;
import easyesb.petalslink.com.data.admin._1.WrapSoapEndpointResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.example.fireman.Fireman_FiremanSOAP_Server;
import org.example.fireman.HowManyPeopleToRescueRequest;
import org.example.fireman.HowManyPeopleToRescueResponse;
import org.jdom.JDOMException;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AgreementViolationTest {
    private Node createMonitoringNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"creation-resources-service-factory", "rawreport-service-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[]{"data-collector-factory", "wsdm-monitoring-factory", "sla-manager-factory"});
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testSLAManager() throws Exception {
        boolean explorer = false;
        Node monitoringBus = null;
        try {
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9100, 8085);
            Assert.assertNotNull((Object)monitoringBus);
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testSLAManagerService_LoadAgreement() throws Exception {
        Node monitoringBus = null;
        try {
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9100, 8085);
            URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "SLAManager"), null, new QueryParam[0]));
            AgreementManagerComponent slaManager = (AgreementManagerComponent)((RegistryEndpointBehaviour)monitoringBus.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(slaEpr);
            AgreementManagerComponentBehaviour slaBehaviour = (AgreementManagerComponentBehaviour)slaManager.findBehaviour(AgreementManagerComponentBehaviour.class);
            LoadAgreementFromUrlRequest request = new LoadAgreementFromUrlRequest();
            request.setUrl(Thread.currentThread().getContextClassLoader().getResource("test/loadAgreement/loadAgreementRequest.xml").toString());
            LoadAgreementResponse response = slaBehaviour.loadAgreementFromUrl(request);
            Assert.assertNotNull((Object)response);
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
            }
        }
    }

    private void createEnvironement(Node monitoringBus) throws ConnectToEsbFault, MalformedURLException, InterruptedException, AdminExceptionMsg, ESBException {
        URI dataEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
        DataCollectorEngine dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
        ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).connectToEsb("http://localhost:8084/services/adminExternalEndpoint");
        URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "SLAManager"), null, new QueryParam[0]));
        AgreementManagerComponent slaManagerComponent = (AgreementManagerComponent)((NodeBehaviour)monitoringBus.findBehaviour(NodeBehaviour.class)).getComponent(slaEpr);
        ((AgreementManagerComponentBehaviour)slaManagerComponent.findBehaviour(AgreementManagerComponentBehaviour.class)).connectToDataCollector();
        Thread.sleep(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1500000L)
    public void testSLAEnforcement_ThrowAlert() throws Exception {
        boolean explorer = false;
        Node monitoringBus = null;
        Node functionalBus = null;
        Fireman_FiremanSOAP_Server fireman = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        try {
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, "http://localhost:9600/AlertService");
            functionalBus = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9000, 8084);
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9100, 8085);
            this.createEnvironement(monitoringBus);
            fireman = new Fireman_FiremanSOAP_Server("http://localhost:9001/firemanEndpoint", 4500);
            AgreementViolationTest.wrapFiremanInFunctionalBus();
            URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "SLAManager"), null, new QueryParam[0]));
            AgreementManagerComponent slaManager = (AgreementManagerComponent)((RegistryEndpointBehaviour)monitoringBus.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(slaEpr);
            AgreementManagerComponentBehaviour slaBehaviour = (AgreementManagerComponentBehaviour)slaManager.findBehaviour(AgreementManagerComponentBehaviour.class);
            LoadAgreementFromUrlRequest request = new LoadAgreementFromUrlRequest();
            request.setUrl(Thread.currentThread().getContextClassLoader().getResource("test/loadAgreement/loadAgreementRequest.xml").toString());
            LoadAgreementResponse resp = slaBehaviour.loadAgreementFromUrl(request);
            Assert.assertNotNull((Object)resp);
            AgreementViolationTest.send_howManyPeopleToRescue();
            while (notifier.getNotifications().size() < 2) {
                Thread.sleep(200L);
            }
            Assert.assertEquals((long)2L, (long)notifier.getNotifications().size());
            XmlObjectReader xmlObjectReader = SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).createReader();
            AgreementViolationTest.checkNotifCertainty(xmlObjectReader, "Possible", notifier.getNotifications().get(0));
            AgreementViolationTest.checkNotifCertainty(xmlObjectReader, "Observed", notifier.getNotifications().get(1));
            AgreementViolationTest.checkNotifNote(xmlObjectReader, "firemanSOAPClientProxyEndpoint", "firemanSOAP", notifier.getNotifications().get(0));
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
            }
            if (functionalBus != null) {
                functionalBus.stop();
            }
            if (fireman != null) {
                fireman.stop();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=150000L)
    public void testELAEnforcement_GreatherThan_ThrowAlert() throws Exception {
        boolean explorer = false;
        Node monitoringBus = null;
        Node functionalBus = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        NotificationConsumer_NotifierEndpoint_Server notifServerAlert = null;
        NotificationProducer_BusProviderEventPort_Server server = null;
        try {
            String busNotifConsumerAddress = "http://localhost:9601/BusConsumerService";
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, busNotifConsumerAddress);
            String alertServiceConsumerAddress = "http://localhost:9600/AlertService";
            NotificationConsumerMock notifierAlert = new NotificationConsumerMock();
            notifServerAlert = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifierAlert, alertServiceConsumerAddress);
            functionalBus = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9000, 8084);
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9100, 8085);
            this.createEnvironement(monitoringBus);
            String busAddress = "http://localhost:9876/busProducer";
            server = new NotificationProducer_BusProviderEventPort_Server(busAddress, 5);
            UserManagementClient client = new UserManagementClient("http://localhost:8084/services/adminExternalEndpoint");
            String busAddress_proxify = client.proxify(busAddress, busAddress + "?wsdl");
            String consumerAddress_proxify = client.proxify(busNotifConsumerAddress, busNotifConsumerAddress + "?wsdl");
            System.out.println("###################################\n" + busAddress_proxify + "\n" + consumerAddress_proxify);
            URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "SLAManager"), null, new QueryParam[0]));
            AgreementManagerComponent slaManager = (AgreementManagerComponent)((RegistryEndpointBehaviour)monitoringBus.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(slaEpr);
            AgreementManagerComponentBehaviour slaBehaviour = (AgreementManagerComponentBehaviour)slaManager.findBehaviour(AgreementManagerComponentBehaviour.class);
            LoadAgreementFromUrlRequest request = new LoadAgreementFromUrlRequest();
            request.setUrl(Thread.currentThread().getContextClassLoader().getResource("test/loadAgreement/agreementBus-ela-greatherthan.xml").toString());
            LoadAgreementResponse resp = slaBehaviour.loadAgreementFromUrl(request);
            Assert.assertNotNull((Object)resp);
            File subscribeFile = new File(Thread.currentThread().getContextClassLoader().getResource("subscribe.xml").toURI());
            Document subscribeAsDom = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(subscribeFile);
            SOAPSender sender = new SOAPSender();
            sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)subscribeAsDom), "http://localhost:8084/services/busProviderEventPortClientProxyEndpoint", null);
            while (notifierAlert.getNotifications().size() == 0) {
                Thread.sleep(200L);
                System.out.println("Wait ...");
            }
            EJaxbNotify notif = notifierAlert.getNotifications().get(0);
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notif);
            System.out.println("Notif = \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
            }
            if (functionalBus != null) {
                functionalBus.stop();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
            if (notifServerAlert != null) {
                notifServerAlert.shutdown();
            }
            if (server != null) {
                server.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testELAEnforcement_LesserThan_ThrowAlert() throws Exception {
        boolean explorer = false;
        Node monitoringBus = null;
        Node functionalBus = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        NotificationConsumer_NotifierEndpoint_Server notifServerAlert = null;
        NotificationProducer_BusProviderEventPort_Server server = null;
        try {
            String busNotifConsumerAddress = "http://localhost:9601/BusConsumerService";
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, busNotifConsumerAddress);
            String alertServiceConsumerAddress = "http://localhost:9600/AlertService";
            NotificationConsumerMock notifierAlert = new NotificationConsumerMock();
            notifServerAlert = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifierAlert, alertServiceConsumerAddress);
            functionalBus = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9000, 8084);
            monitoringBus = this.createMonitoringNode(new QName("http://petals.ow2.org", "MonitoringBus"), "localhost", 9100, 8085);
            this.createEnvironement(monitoringBus);
            String busAddress = "http://localhost:9876/busProducer";
            server = new NotificationProducer_BusProviderEventPort_Server(busAddress, 3);
            UserManagementClient client = new UserManagementClient("http://localhost:8084/services/adminExternalEndpoint");
            String busAddress_proxify = client.proxify(busAddress, busAddress + "?wsdl");
            String consumerAddress_proxify = client.proxify(busNotifConsumerAddress, busNotifConsumerAddress + "?wsdl");
            System.out.println("###################################\n" + busAddress_proxify + "\n" + consumerAddress_proxify);
            URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(monitoringBus.getQName().getNamespaceURI(), "SLAManager"), null, new QueryParam[0]));
            AgreementManagerComponent slaManager = (AgreementManagerComponent)((RegistryEndpointBehaviour)monitoringBus.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(slaEpr);
            AgreementManagerComponentBehaviour slaBehaviour = (AgreementManagerComponentBehaviour)slaManager.findBehaviour(AgreementManagerComponentBehaviour.class);
            LoadAgreementFromUrlRequest request = new LoadAgreementFromUrlRequest();
            request.setUrl(Thread.currentThread().getContextClassLoader().getResource("test/loadAgreement/agreementBus-ela.xml").toString());
            LoadAgreementResponse resp = slaBehaviour.loadAgreementFromUrl(request);
            Assert.assertNotNull((Object)resp);
            File subscribeFile = new File(Thread.currentThread().getContextClassLoader().getResource("subscribe.xml").toURI());
            Document subscribeAsDom = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(subscribeFile);
            SOAPSender sender = new SOAPSender();
            sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)subscribeAsDom), "http://localhost:8084/services/busProviderEventPortClientProxyEndpoint", null);
            while (notifierAlert.getNotifications().size() == 0) {
                Thread.sleep(200L);
                System.out.println("Wait ...");
            }
            EJaxbNotify notif = notifierAlert.getNotifications().get(0);
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notif);
            System.out.println("Notif = \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        }
        finally {
            if (monitoringBus != null) {
                monitoringBus.stop();
            }
            if (functionalBus != null) {
                functionalBus.stop();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
            if (notifServerAlert != null) {
                notifServerAlert.shutdown();
            }
            if (server != null) {
                server.stop();
            }
        }
    }

    private static final void checkNotifCertainty(XmlObjectReader xmlObjectReader, String expectedCertainty, EJaxbNotify jaxbElmt) throws SOAException, WsnbException, XmlObjectReadException {
        Document document = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)jaxbElmt);
        System.out.println(XMLPrettyPrinter.prettyPrint((Document)document));
        EJaxbNotify notify = WSNHelper.marshallNotify((Document)document);
        List notificationMessages = notify.getNotificationMessage();
        Assert.assertEquals((long)1L, (long)notificationMessages.size());
        Document notificationDocument = DocumentBuilders.newDocument();
        org.w3c.dom.Node notificationNode = notificationDocument.importNode((Element)((EJaxbNotificationMessageHolderType)notificationMessages.get(0)).getMessage().getAny(), true);
        notificationDocument.appendChild(notificationNode);
        Alert alert = (Alert)xmlObjectReader.readDocument(notificationDocument, Alert.class);
        Info[] infos = alert.getInfos();
        Assert.assertEquals((long)1L, (long)infos.length);
        Assert.assertEquals((Object)expectedCertainty, (Object)infos[0].getCertainty());
    }

    private static final void checkNotifNote(XmlObjectReader xmlObjectReader, String initiatorEndpointName, String responderEndpointName, EJaxbNotify jaxbElmt) throws SOAException, WsnbException, XmlObjectReadException {
        try {
            Document document = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)jaxbElmt);
            System.out.println(XMLPrettyPrinter.prettyPrint((Document)document));
            EJaxbNotify notify = WSNHelper.marshallNotify((Document)document);
            List notificationMessages = notify.getNotificationMessage();
            Assert.assertEquals((long)1L, (long)notificationMessages.size());
            Document notificationDocument = DocumentBuilders.newDocument();
            org.w3c.dom.Node notificationNode = notificationDocument.importNode((Element)((EJaxbNotificationMessageHolderType)notificationMessages.get(0)).getMessage().getAny(), true);
            notificationDocument.appendChild(notificationNode);
            Alert alert = (Alert)xmlObjectReader.readDocument(notificationDocument, Alert.class);
            String note = alert.getNote();
            System.out.println("Note : " + note);
            ByteArrayInputStream bi = new ByteArrayInputStream(note.getBytes());
            Document noteasDom = DocumentBuilders.takeDocumentBuilder().parse(bi);
            AlertNoteDefinition alertNote = (AlertNoteDefinition)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(noteasDom, AlertNoteDefinition.class);
            System.out.println("initiator URL : " + alertNote.getInitiatorIdentifier().getOriginalURL());
            System.out.println("responder URL : " + alertNote.getResponderIdentifier().getOriginalURL());
            Assert.assertEquals((Object)initiatorEndpointName, (Object)alertNote.getInitiatorIdentifier().getEndpoint().getEndpointName());
            Assert.assertEquals((Object)responderEndpointName, (Object)alertNote.getResponderIdentifier().getEndpoint().getEndpointName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    public static void wrapFiremanInFunctionalBus() throws SOAPException, SAXException, IOException, ParserConfigurationException, Exception {
        SOAPSender sender = new SOAPSender();
        WrapSoapEndpoint wrapRequest = new WrapSoapEndpoint();
        wrapRequest.setSoapAddress("http://localhost:9001/firemanEndpoint");
        wrapRequest.setWsdl(Thread.currentThread().getContextClassLoader().getResource("test/wsdl/fireman.wsdl").toExternalForm());
        Document soapRequest = SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)wrapRequest));
        Document soapResponse = sender.sendSoapRequest(soapRequest, "http://localhost:8084/services/adminExternalEndpoint", "http://com.petalslink.easyesb/service/admin/1.0/wrapSoapEndpoint");
        String responseMsg = XMLPrettyPrinter.prettyPrint((Document)soapResponse);
        System.out.println("response = " + responseMsg);
        Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody((Document)soapResponse)), true).cloneNode(true));
        System.out.println("payload = " + XMLPrettyPrinter.prettyPrint((Document)doc));
        WrapSoapEndpointResponse businessReponse = (WrapSoapEndpointResponse)SOAJAXBContext.getInstance().marshallAnyType(doc, WrapSoapEndpointResponse.class);
        Assert.assertEquals((Object)"http://localhost:8084/services/firemanSOAPClientProxyEndpoint", (Object)businessReponse.getConsumerSoapAddress());
    }

    public static HowManyPeopleToRescueResponse send_howManyPeopleToRescue() throws JDOMException, ESBException, SOAPException, ParserConfigurationException, SOAException {
        HowManyPeopleToRescueResponse res = null;
        SOAPSender sender = new SOAPSender();
        HowManyPeopleToRescueRequest request = new HowManyPeopleToRescueRequest();
        Document soapRequest = SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)request));
        Document soapResponse = sender.sendSoapRequest(soapRequest, "http://localhost:8084/services/firemanSOAPClientProxyEndpoint", "http://www.example.org/fireman/howManyPeopleToRescue");
        String responseMsg = XMLPrettyPrinter.prettyPrint((Document)soapResponse);
        System.out.println("response = " + responseMsg);
        Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody((Document)soapResponse)), true).cloneNode(true));
        System.out.println("payload = " + XMLPrettyPrinter.prettyPrint((Document)doc));
        res = (HowManyPeopleToRescueResponse)SOAJAXBContext.getInstance().marshallAnyType(doc, HowManyPeopleToRescueResponse.class);
        Assert.assertEquals((long)5L, (long)res.getPeopleToCare());
        return res;
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class, org.example.fireman.ObjectFactory.class});
        }
        catch (Exception ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }
}

