/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.FrequencyViolationThread;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.LatencyViolationThread;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.wsagreement10.api.element.GuaranteeTerm;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class AgreementChecker {
    private static Logger log = Logger.getLogger(AgreementChecker.class.getName());
    private Map<String, Runnable> threads = new HashMap<String, Runnable>();
    private ProviderEndpoint ep;

    public AgreementChecker(ProviderEndpoint ep) {
        this.ep = ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNewReportList(EJaxbReportListType addNewReportListRequest) {
        block26: {
            try {
                log.finest("New report received ...");
                ReportList reports = (ReportList)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().wrap((Object)addNewReportListRequest, ReportList.class);
                if (reports.getReports().length >= 1) {
                    String exchangeId = reports.getReports()[0].getExchangeId();
                    Report report0 = reports.getReports()[0];
                    URI clientAddress = null;
                    URI providerAddress = null;
                    if (report0.getTimeStamp().equals((Object)TimeStampType.t1)) {
                        clientAddress = ESBUtil.getURIWithoutQuery((URI)URI.create(report0.getConsumerEndpointAddress()));
                        providerAddress = ESBUtil.getURIWithoutQuery((URI)URI.create(report0.getProviderEndpointAddress()));
                    } else if (report0.getTimeStamp().equals((Object)TimeStampType.t3)) {
                        providerAddress = ESBUtil.getURIWithoutQuery((URI)URI.create(report0.getProviderEndpointAddress()));
                        clientAddress = ESBUtil.getURIWithoutQuery((URI)URI.create(report0.getConsumerEndpointAddress()));
                    }
                    URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.getEndpoint().getNode().getQName().getNamespaceURI(), "SLAManager"), null, new QueryParam[0]));
                    AgreementManagerComponent slaManager = (AgreementManagerComponent)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(slaEpr);
                    AgreementManagerComponentBehaviour slaBehaviour = (AgreementManagerComponentBehaviour)slaManager.findBehaviour(AgreementManagerComponentBehaviour.class);
                    if (slaBehaviour == null) {
                        throw new ESBException("this RawReport behaviour must be coupled with slaManager Behaviour");
                    }
                    Map<URI, Map<URI, AgreementType>> agreementRegistry = slaBehaviour.getAgreementRegistry();
                    Map<URI, AgreementType> clientAgreements = agreementRegistry.get(providerAddress);
                    log.finest("current consumer in rawreport: " + clientAddress);
                    log.finest("current provider in rawreport: " + providerAddress);
                    log.finest("map of agreements : " + (agreementRegistry == null ? Integer.valueOf(0) : agreementRegistry.keySet()));
                    log.finest("map of agreements : " + (agreementRegistry == null ? 0 : agreementRegistry.size()));
                    log.finest("map of agreements (client part) : " + (clientAgreements == null ? Integer.valueOf(0) : clientAgreements.keySet()));
                    log.finest("map of agreements (client part) : " + (clientAgreements == null ? 0 : clientAgreements.size()));
                    if (clientAgreements == null) break block26;
                    AgreementType ag = clientAgreements.get(clientAddress);
                    if (ag != null) {
                        GuaranteeTerm[] guaranteeTerms;
                        log.finest("Agreement found: " + ag.getName());
                        GuaranteeTerm[] guaranteeTermArray = guaranteeTerms = ag.getTerms().getAll().getGuaranteeTerms();
                        int n = guaranteeTerms.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object freqViolationThread;
                            GuaranteeTerm g = guaranteeTermArray[n2];
                            ServiceLevelObjective slo = g.getServiceLevelObjective();
                            log.finest("SLO in guarantee: " + slo.getKPITarget().getKPIName());
                            if ("frequency".equals(slo.getKPITarget().getKPIName())) {
                                String freqElaId = String.valueOf(providerAddress.toString()) + clientAddress.toString() + report0.getOperationName();
                                if (this.threads.get(freqElaId) == null) {
                                    log.finest("Start frequency controller with id: " + freqElaId);
                                    freqViolationThread = new FrequencyViolationThread(slaBehaviour, reports, slo, ag);
                                    this.threads.put(freqElaId, (Runnable)freqViolationThread);
                                    ((Thread)freqViolationThread).start();
                                } else {
                                    log.finest("Reactivate frequency controller with id: " + freqElaId);
                                    ((FrequencyViolationThread)this.threads.get(freqElaId)).addNotif(reports);
                                }
                            } else if ("latency".equals(slo.getKPITarget().getKPIName())) {
                                if (this.threads.get(exchangeId) == null) {
                                    LatencyViolationThread slaViolationT = new LatencyViolationThread(slaBehaviour, reports, slo, ag);
                                    this.threads.put(exchangeId, slaViolationT);
                                    slaViolationT.start();
                                } else if (reports.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t3)) {
                                    LatencyViolationThread thread = (LatencyViolationThread)this.threads.get(exchangeId);
                                    if (thread.isInterrupted()) {
                                        freqViolationThread = this.threads;
                                        synchronized (freqViolationThread) {
                                            ((LatencyViolationThread)this.threads.get(exchangeId)).addReport(reports.getReports()[0]);
                                            ((LatencyViolationThread)this.threads.get(exchangeId)).addReport(reports.getReports()[1]);
                                            try {
                                                LatencyViolationThread latencyViolationThread = (LatencyViolationThread)this.threads.get(exchangeId);
                                                synchronized (latencyViolationThread) {
                                                    ((LatencyViolationThread)this.threads.get(exchangeId)).notify();
                                                }
                                            }
                                            catch (IllegalMonitorStateException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    ReportList reportst1t2 = thread.getReports();
                                    reportst1t2.addReport(reports.getReports()[0]);
                                    reportst1t2.addReport(reports.getReports()[1]);
                                    LatencyViolationThread slaViolationT = new LatencyViolationThread(slaBehaviour, reportst1t2, slo, ag);
                                    this.threads.put(exchangeId, slaViolationT);
                                    slaViolationT.start();
                                }
                            }
                            ++n2;
                        }
                        break block26;
                    }
                    log.finest("Agreement Not found!!!!");
                    break block26;
                }
                throw new ESBException("Incorrect number of report");
            }
            catch (ESBException e) {
                log.severe(e.getMessage());
            }
        }
    }

    private ProviderEndpoint getEndpoint() {
        return this.ep;
    }
}

