/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLACheckingProviderEndpointBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.SLAChecker;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easierbsm.petalslink.com.data.slamanager._1.ObjectFactory;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class SLACheckingProviderEndpointBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements SLACheckingProviderEndpointBehaviour {
    private static Logger log = Logger.getLogger(SLACheckingProviderEndpointBehaviourImpl.class.getName());
    private SLAChecker slaChecker;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public SLACheckingProviderEndpointBehaviourImpl(ProviderEndpoint<?> ep) {
        super(ep);
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/slachecking10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(url, Definitions.class));
            this.setBinding((Binding)desc.getBindings().iterator().next());
            this.slaChecker = new SLAChecker(ep);
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            log.info("slo checking BEHAVIOUR FOUND: " + exchange.getOperation());
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("Notify")) {
                log.info("NOTIFY");
                System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageIn().getBody().getPayload()));
                Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
                this.notify(notify);
            } else {
                super.execute(exchange);
            }
        }
        catch (WsnbException e) {
            throw new TransportException((Throwable)e);
        }
    }

    public void notify(Notify notify) throws WsnbException {
        try {
            Document notifPayload = DOMUtil.getInstance().createDocumentFromElement(((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage().getAny());
            ReportList reportList = (ReportList)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(notifPayload, ReportList.class);
            this.slaChecker.addNewReportList((EJaxbReportListType)reportList.getModelObject());
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (XmlObjectReadException e) {
            throw new WsnbException((Throwable)e);
        }
    }
}

