/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAManagerComponentBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.escad10.api.element.Protocol;
import com.ebmwebsourcing.escad10.api.element.To;
import com.ebmwebsourcing.escad10.protocol.soapnotif.api.element.Binding;
import com.ebmwebsourcing.escapnote10.api.element.AlertNoteDefinition;
import com.ebmwebsourcing.escapnote10.api.element.InitiatorIdentifier;
import com.ebmwebsourcing.escapnote10.api.element.ResponderIdentifier;
import com.ebmwebsourcing.esqml10.api.type.ConstraintType;
import com.ebmwebsourcing.wsagreement10.api.element.GuaranteeTerm;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SLAViolationThread
extends Thread
implements Runnable {
    private final Logger log = Logger.getLogger(SLAViolationThread.class.getName());
    private DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();
    private ReportList reports;
    private AgreementType agreement;
    private final SOAPSender soapSender;
    private final SLAManagerComponentBehaviour behaviour;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public SLAViolationThread(SLAManagerComponentBehaviour behaviour, ReportList reports, AgreementType agreement) {
        this.reports = reports;
        this.agreement = agreement;
        this.soapSender = new SOAPSender();
        this.behaviour = behaviour;
    }

    public void addReport(Report report) {
        this.reports.addReport(report);
    }

    public ReportList getReports() {
        return this.reports;
    }

    @Override
    public void run() {
        try {
            List<Alert> alerts = this.detectViolations(this.reports, this.agreement);
            if (alerts != null && alerts.size() > 0) {
                Object obj;
                this.log.info("ALERTS FOUND");
                AlertDefinition alertDef = (AlertDefinition)this.agreement.getAgreementContext().findExtendedElement(AlertDefinition.class);
                if (alertDef == null && (obj = ((EJaxbAgreementContextType)this.agreement.getAgreementContext().getModelObject()).getAny().iterator().next()) != null && obj instanceof Element) {
                    Element elmt = (Element)obj;
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.importNode(elmt, true));
                    alertDef = (AlertDefinition)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, AlertDefinition.class);
                }
                if (alertDef != null) {
                    try {
                        this.sendAlerts(alerts, alertDef);
                    }
                    catch (ESBException e) {
                        this.log.severe(e.getMessage());
                    }
                } else {
                    this.log.severe("No alertDefinition defined in agreement: " + this.agreement.getName());
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
        }
        catch (ESBException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
        }
    }

    private void sendAlerts(List<Alert> alerts, AlertDefinition alertDef) throws ESBException {
        To[] toArray = alertDef.getTos();
        int n = toArray.length;
        int n2 = 0;
        while (n2 < n) {
            To to = toArray[n2];
            Protocol[] protocolArray = to.getProtocols();
            int n3 = protocolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Protocol protocol = protocolArray[n4];
                Binding soapNotifBinding = (Binding)protocol.findBinding(Binding.class);
                if (soapNotifBinding != null) {
                    this.sendAlerts(alerts, to, soapNotifBinding);
                } else {
                    this.log.severe("Only soap-notification binding is supported to send alert for the moment!!!");
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void sendAlerts(List<Alert> alerts, To to, Binding soapNotifBinding) throws ESBException {
        for (Alert alert : alerts) {
            this.sendAlert(alert, to, soapNotifBinding);
        }
    }

    private void sendAlert(Alert alert, To to, Binding soapNotifBinding) throws ESBException {
        try {
            EndpointType ep = ((RegistryEndpointBehaviour)this.behaviour.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(QName.valueOf(soapNotifBinding.getSoapAddress()));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)alert, (OutputStream)baos);
            ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
            Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
            String producerAddress = String.valueOf(((ProviderEndpoint)this.behaviour.getEndpoint()).getQName().getNamespaceURI()) + "::" + ((ProviderEndpoint)this.behaviour.getEndpoint()).getQName().getLocalPart();
            Notify notify = NotificationProducerThreadImpl.createNotification((String)producerAddress.trim(), (String)soapNotifBinding.getSoapAddress().trim(), (String)UUID.randomUUID().toString(), null, (String)"http://www.w3.org/TR/1999/REC-xpath-19991116", (Document)notifPayload);
            if (ep != null) {
                Exchange ex = NotificationProducerThreadImpl.createMessageExchange((EndpointBehaviour)this.behaviour, (String)soapNotifBinding.getSoapAddress(), (Notify)notify);
                this.log.info("send internal notification to: " + ex.getDestination());
                this.behaviour.getEndpoint().getNode().getTransportersManager().push(ex, ep.getNode());
            } else {
                Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notify);
                this.soapSender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)request), soapNotifBinding.getSoapAddress(), null);
                this.log.info("Alert sended to " + soapNotifBinding.getSoapAddress());
            }
        }
        catch (TransportException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SOAPException e) {
            throw new ESBException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new ESBException((Throwable)e);
        }
        catch (XmlObjectWriteException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ESBException((Throwable)e);
        }
        catch (IOException e) {
            throw new ESBException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ESBException((Throwable)e);
        }
        catch (WsnbException e) {
            throw new ESBException((Throwable)e);
        }
    }

    private List<Alert> detectViolations(ReportList reports, AgreementType ag) throws ESBException {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        Object initiator = ag.getAgreementContext().getAgreementInitiator();
        Object responder = ag.getAgreementContext().getAgreementResponder();
        GuaranteeTerm[] guaranteeTermArray = ag.getTerms().getAll().getGuaranteeTerms();
        int n = guaranteeTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuaranteeTerm g = guaranteeTermArray[n2];
            Alert alertOnGuarantee = this.detectViolationsOnGuarantee(reports, g, initiator, responder);
            if (alertOnGuarantee != null) {
                alerts.add(alertOnGuarantee);
            }
            ++n2;
        }
        return alerts;
    }

    private Alert detectViolationsOnGuarantee(ReportList reports, GuaranteeTerm g, Object initiator, Object responder) throws ESBException {
        Alert alert = null;
        ServiceLevelObjective slo = g.getServiceLevelObjective();
        alert = slo.getKPITarget().getKPIName().equals("latency") ? this.detectLatencyViolation(g, slo, reports, initiator, responder) : this.createAlert("Unknow KPI Target: " + slo.getKPITarget().getKPIName(), g, reports, Level.WARNING, initiator, responder);
        return alert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alert detectLatencyViolation(GuaranteeTerm g, ServiceLevelObjective slo, ReportList reports, Object initiator, Object responder) throws ESBException {
        Alert alert;
        block22: {
            alert = null;
            long currentLatency = Long.MAX_VALUE;
            try {
                Object obj = slo.getKPITarget().getCustomServiceLevel();
                if (obj != null && obj instanceof Element) {
                    Element elmt = (Element)obj;
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.importNode(elmt, true));
                    ConstraintType target = (ConstraintType)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readFragment(doc, ConstraintType.class);
                    long expectedLatency = (long)(target.getValue().getValue().floatValue() * 1000.0f);
                    String alertType = "";
                    String certainty = "";
                    if (reports.getReports().length == 2) {
                        long current = new Date().getTime();
                        long t2 = reports.getReports()[1].getDateInGMT().getTime();
                        if (reports.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t1)) {
                            try {
                                SLAViolationThread sLAViolationThread = this;
                                synchronized (sLAViolationThread) {
                                    this.wait(expectedLatency);
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            alertType = "(Potential)";
                            certainty = "Possible";
                        }
                        currentLatency = expectedLatency + 1L;
                    }
                    if (reports.getReports().length == 4 && reports.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t1) && reports.getReports()[1].getTimeStamp().equals((Object)TimeStampType.t2) && reports.getReports()[2].getTimeStamp().equals((Object)TimeStampType.t3) && reports.getReports()[3].getTimeStamp().equals((Object)TimeStampType.t4)) {
                        Report providerOut = reports.getReports()[2];
                        Report providerIn = reports.getReports()[1];
                        currentLatency = providerOut.getDateInGMT().getTime() - providerIn.getDateInGMT().getTime();
                        alertType = "(Confirmed)";
                        certainty = "Observed";
                    }
                    if (InegalityOperator.GREATER_THAN.equals(target.getOperator()) && currentLatency <= expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not > to " + expectedLatency + " " + alertType, g, reports, Level.SEVERE, initiator, responder);
                    } else if (InegalityOperator.GREATER_THAN_OR_EQUALS.equals(target.getOperator()) && currentLatency < expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not >= to " + expectedLatency + " " + alertType, g, reports, Level.SEVERE, initiator, responder);
                    } else if (InegalityOperator.LESS_THAN.equals(target.getOperator()) && currentLatency >= expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not < to " + expectedLatency + " " + alertType, g, reports, Level.SEVERE, initiator, responder);
                    } else if (InegalityOperator.LESS_THAN_OR_EQUALS.equals(target.getOperator()) && currentLatency > expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not <= to " + expectedLatency + " " + alertType, g, reports, Level.SEVERE, initiator, responder);
                    } else if (!(InegalityOperator.GREATER_THAN.equals(target.getOperator()) || InegalityOperator.LESS_THAN.equals(target.getOperator()) || InegalityOperator.GREATER_THAN_OR_EQUALS.equals(target.getOperator()) || InegalityOperator.LESS_THAN_OR_EQUALS.equals(target.getOperator()))) {
                        throw new ESBException("Unknown agreement operator: " + target.getOperator());
                    }
                    Info info = (Info)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Info.class);
                    info.addCategory("Infra");
                    info.setEvent("SLA Violation");
                    info.setUrgency("Unknown");
                    info.setSeverity("Unknown");
                    info.setCertainty(certainty);
                    alert.addInfo(info);
                    break block22;
                }
                this.log.warning("Wrong number of reports to check SLAs!");
            }
            catch (ParserConfigurationException e) {
                throw new ESBException((Throwable)e);
            }
            catch (XmlObjectReadException e) {
                throw new ESBException((Throwable)e);
            }
        }
        return alert;
    }

    private Alert createAlert(String msg, GuaranteeTerm g, ReportList reports, Level level, Object initiator, Object responder) {
        EndpointAddress ea;
        Alert alert = (Alert)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Alert.class);
        alert.setIdentifier(reports.getReports()[0].getExchangeId());
        alert.setMsgType("Alert");
        alert.setSent(Calendar.getInstance().getTime());
        XmlObjectFactory factory = SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory();
        AlertNoteDefinition note = (AlertNoteDefinition)factory.create(AlertNoteDefinition.class);
        note.setMessage(msg);
        if (initiator instanceof EJaxbEndpointReferenceType) {
            try {
                EJaxbEndpointReferenceType initiatorEPR = (EJaxbEndpointReferenceType)initiator;
                ea = ESBUtil.analyzeURI((URI)new URI(initiatorEPR.getAddress().getValue()));
                InitiatorIdentifier initiatorEndpoint = (InitiatorIdentifier)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(InitiatorIdentifier.class);
                initiatorEndpoint.setEndpointName(ea.getEndpointname());
                initiatorEndpoint.setNamespaceURI(ea.getNamespace());
                if (ea.getServicename() != null) {
                    initiatorEndpoint.setServiceName(ea.getServicename());
                }
                note.setInitiatorIdentifier(initiatorEndpoint);
            }
            catch (Exception e) {
                this.log.severe("Failed to parse initiator URI ...");
            }
        }
        if (responder instanceof EJaxbEndpointReferenceType) {
            try {
                EJaxbEndpointReferenceType responderEPR = (EJaxbEndpointReferenceType)responder;
                ea = ESBUtil.analyzeURI((URI)new URI(responderEPR.getAddress().getValue()));
                ResponderIdentifier responderEndpoint = (ResponderIdentifier)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ResponderIdentifier.class);
                responderEndpoint.setEndpointName(ea.getEndpointname());
                responderEndpoint.setNamespaceURI(ea.getNamespace());
                responderEndpoint.setServiceName(ea.getServicename());
                note.setResponderIdentifier(responderEndpoint);
            }
            catch (Exception e) {
                this.log.severe("Failed to parse responder URI ...");
            }
        }
        String noteAsString = "";
        Document noteAsDOM = this.db.newDocument();
        try {
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)note, (Node)noteAsDOM);
        }
        catch (XmlObjectWriteException e) {
            this.log.severe("Failed to write note as dom in alert.");
        }
        noteAsString = String.valueOf(noteAsString) + XMLPrettyPrinter.prettyPrint((Document)noteAsDOM);
        alert.setNote(noteAsString);
        return alert;
    }

    public void launchNotify() {
        this.notify();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    private static enum InegalityOperator {
        GREATER_THAN("&gt;"),
        LESS_THAN("&lt;"),
        GREATER_THAN_OR_EQUALS("&gt;="),
        LESS_THAN_OR_EQUALS("&lt;=");

        private String value = null;

        private InegalityOperator(String val) {
            this.value = val;
        }

        boolean equals(String val) {
            return this.value.equals(val);
        }
    }

    private static enum Level {
        WARNING("Warning"),
        SEVERE("Severe");

        private String value = null;

        private Level(String val) {
            this.value = val;
        }

        public boolean equals(String val) {
            return this.value.equals(val);
        }

        public String toString() {
            return this.value;
        }
    }
}

