/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.sla.manager.impl;

import java.net.URL;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementCheckingProviderEndpointBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;

public class AgreementCheckingProviderEndpointBehaviourImpl extends
AbstractEndpointBehaviourImpl implements
AgreementCheckingProviderEndpointBehaviour {

	private static Logger log = Logger
			.getLogger(AgreementCheckingProviderEndpointBehaviourImpl.class.getName());

	private AgreementChecker slaChecker;

	static {
		try {
			// ADD ADMIN JAXB FACTORY
			SOAJAXBContext.getInstance().addOtherObjectFactory(easierbsm.petalslink.com.data.slamanager._1.ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}
	}

	public AgreementCheckingProviderEndpointBehaviourImpl(final ProviderEndpoint<?> ep) {
		super(ep);
		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(url, Definitions.class));
			this.setBinding(desc.getBindings().iterator().next());

			slaChecker = new AgreementChecker(ep);
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		} 
	}


	@Override
	public void execute(final Exchange exchange) throws TransportException {
		try {
			log.info("slo checking BEHAVIOUR FOUND: " + exchange.getOperation());

			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("Notify")) {

				log.info("NOTIFY");

				System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().getBody().getPayload()));
				Notify notify =  Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
				this.notify(notify);

			} 


			else {
				super.execute(exchange);
			}
		} catch (WsnbException e) {
			throw new TransportException(e);
		} 
	}



	@Override
	public void notify(Notify notify) throws WsnbException {
		try {
			Document notifPayload = DOMUtil.getInstance().createDocumentFromElement(notify.getNotificationMessage().get(0).getMessage().getAny());
			ReportList reportList = SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(notifPayload, ReportList.class);

			this.slaChecker.addNewReportList((EJaxbReportListType) reportList.getModelObject());
		} catch (ParserConfigurationException e) {
			throw new WsnbException(e);
		} catch (XmlObjectReadException e) {
			throw new WsnbException(e);
		}
	}


}
