/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.escad10.api.element.Protocol;
import com.ebmwebsourcing.escad10.api.element.To;
import com.ebmwebsourcing.escad10.protocol.soapnotif.api.element.Binding;
import com.ebmwebsourcing.esqml10.api.type.ConstraintType;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;

import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;

public class LatencyViolationThread extends AbstractAlertManagerThread implements Runnable {


	private final Logger log = Logger.getLogger(LatencyViolationThread.class
			.getName());

	

	public LatencyViolationThread(AgreementManagerComponentBehaviour behaviour, ReportList reports, ServiceLevelObjective slo, AgreementType globalAgreement) {
		super(new SOAPSender(), behaviour, globalAgreement);
		this.reports = reports;
		this.slo = slo;
		this.globalAggreement = globalAgreement;
	}

	public void addReport(Report report){
		this.reports.addReport(report);
	}

	public ReportList getReports(){
		return this.reports;
	}

	@Override
	public void run() {
		try {

			List<Alert> alerts = detectViolations(this.reports, this.slo, this.globalAggreement);
			if(alerts != null && alerts.size() > 0) {
				log.info("ALERTS FOUND");
				// get alert definition
				AlertDefinition alertDef = this.globalAggreement.getAgreementContext().findExtendedElement(AlertDefinition.class);
				if(alertDef == null) {
					// FIXME: EASYBOX BUG
					Object obj = ((EJaxbAgreementContextType)this.globalAggreement.getAgreementContext().getModelObject()).getAny().iterator().next();
					if(obj != null && obj instanceof Element) {
						Element elmt = (Element)obj;
						Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
						doc.appendChild(doc.importNode(elmt, true));
						alertDef = SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(doc, AlertDefinition.class);
					}
				}

				if(alertDef != null) {
					// send alerts
					try {
						sendAlerts(alerts, alertDef);
					} catch (ESBException e) {
						log.severe(e.getMessage());
					}
				} else {
					log.severe("No alertDefinition defined in agreement: " + this.globalAggreement.getName());
				}
			}
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			log.severe(e.getMessage());
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			log.severe(e.getMessage());
		} catch (ESBException e) {
			e.printStackTrace();
			log.severe(e.getMessage());
		}
	}

	
	private List<Alert> detectViolations(ReportList reports, ServiceLevelObjective slo, AgreementType ag) throws ESBException {
		List<Alert> alerts  = new ArrayList<Alert>();

		Object initiator = ag.getAgreementContext().getAgreementInitiator();
		Object responder = ag.getAgreementContext().getAgreementResponder();


		Alert alertOnGuarantee = detectViolationsOnGuarantee(reports, slo, initiator, responder);

		if(alertOnGuarantee != null ) {
			alerts.add(alertOnGuarantee);
		}


		return alerts;
	}

	private Alert detectViolationsOnGuarantee(ReportList reports,
			ServiceLevelObjective slo, Object initiator, Object responder) throws ESBException {
		Alert alert  = null;

		alert = detectLatencyViolation(slo, reports, initiator, responder);

		return alert;
	}

	private Alert detectLatencyViolation(			ServiceLevelObjective slo, ReportList reports, Object initiator, Object responder) throws ESBException {
		Alert alert  = null;
		long currentLatency = Long.MAX_VALUE;
		try {

			Object obj = slo.getKPITarget().getCustomServiceLevel();
			if(obj != null && obj instanceof Element) {
				Element elmt = (Element)obj;
				Document doc;

				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.importNode(elmt, true));

				ConstraintType target = SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readFragment(doc, ConstraintType.class);
				long expectedLatency = (long) (target.getValue().getValue() * 1000);

				String alertType = "";
				String certainty = "";

				/**
				 * Manage non-responding service by checking sla only with t1 and t2 reports... able to send Potential alerts.
				 */
				if(reports.getReports().length == 2){

					long current = new Date().getTime();
					long t2 = reports.getReports()[1].getDateInGMT().getTime();
					//if received reports are T1/T2 reports
					if(reports.getReports()[0].getTimeStamp().equals(TimeStampType.t1)){
						try {
							synchronized (this) {
								wait(expectedLatency);
							}

						} catch (InterruptedException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}

						alertType = "(Potential)";
						certainty = "Possible";
					}

					//In  order to be sure the potential SLA violation will be sent
					currentLatency = expectedLatency + 1;

				}

				/**
				 * Manage all services... able to send Confirmed alerts.
				 */
				if(reports.getReports().length == 4){
					if(reports.getReports()[0].getTimeStamp().equals(TimeStampType.t1) && 
							reports.getReports()[1].getTimeStamp().equals(TimeStampType.t2) &&
							reports.getReports()[2].getTimeStamp().equals(TimeStampType.t3) &&
							reports.getReports()[3].getTimeStamp().equals(TimeStampType.t4)){

						Report providerOut = reports.getReports()[2];
						Report providerIn = reports.getReports()[1];

						currentLatency = providerOut.getDateInGMT().getTime() - providerIn.getDateInGMT().getTime();

						alertType = "(Confirmed)";
						certainty = "Observed";
					}
				}


				if(InegalityOperator.GREATER_THAN.equals(target.getOperator()) && currentLatency <= expectedLatency) {
					alert = createAlert(slo.getKPITarget().getKPIName() + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not > to " + expectedLatency + " " + alertType, reports, Level.SEVERE, initiator, responder);
				} else if(InegalityOperator.GREATER_THAN_OR_EQUALS.equals(target.getOperator()) && currentLatency < expectedLatency) {
					alert = createAlert(slo.getKPITarget().getKPIName() + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not >= to " + expectedLatency + " " + alertType, reports, Level.SEVERE, initiator, responder);
				} else if(InegalityOperator.LESS_THAN.equals(target.getOperator()) && currentLatency >= expectedLatency) {
					alert = createAlert(slo.getKPITarget().getKPIName() + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not < to " + expectedLatency + " " + alertType, reports, Level.SEVERE, initiator, responder);
				} else if(InegalityOperator.LESS_THAN_OR_EQUALS.equals(target.getOperator()) && currentLatency > expectedLatency) {
					alert = createAlert(slo.getKPITarget().getKPIName() + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not <= to " + expectedLatency + " " + alertType, reports, Level.SEVERE, initiator, responder);
				} else if(!InegalityOperator.GREATER_THAN.equals(target.getOperator())
						&& !InegalityOperator.LESS_THAN.equals(target.getOperator())
						&& !InegalityOperator.GREATER_THAN_OR_EQUALS.equals(target.getOperator())
						&& !InegalityOperator.LESS_THAN_OR_EQUALS.equals(target.getOperator())){
					throw new ESBException("Unknown agreement operator: " + target.getOperator()); 
				}

				Info info = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Info.class);
				info.addCategory("Infra");
				info.setEvent("SLA Violation");
				info.setUrgency("Unknown");
				info.setSeverity("Unknown");
				info.setCertainty(certainty);
				alert.addInfo(info);

			}else{
				this.log.warning("Wrong number of reports to check SLAs!");
			}
		} catch (ParserConfigurationException e) {
			throw new ESBException(e);
		} catch (XmlObjectReadException e) {
			throw new ESBException(e);
		} 
		return alert;
	}


	


	

}
