/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.AbstractAlertManagerThread;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.esqml10.api.type.ConstraintType;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LatencyViolationThread
extends AbstractAlertManagerThread
implements Runnable {
    private final Logger log = Logger.getLogger(LatencyViolationThread.class.getName());

    public LatencyViolationThread(AgreementManagerComponentBehaviour behaviour, ReportList reports, ServiceLevelObjective slo, AgreementType globalAgreement) {
        super(new SOAPSender(), behaviour, globalAgreement);
        this.reports = reports;
        this.slo = slo;
        this.globalAggreement = globalAgreement;
    }

    public void addReport(Report report) {
        this.reports.addReport(report);
    }

    public ReportList getReports() {
        return this.reports;
    }

    @Override
    public void run() {
        try {
            List<Alert> alerts = this.detectViolations(this.reports, this.slo, this.globalAggreement);
            if (alerts != null && alerts.size() > 0) {
                Object obj;
                this.log.info("ALERTS FOUND");
                AlertDefinition alertDef = (AlertDefinition)this.globalAggreement.getAgreementContext().findExtendedElement(AlertDefinition.class);
                if (alertDef == null && (obj = ((EJaxbAgreementContextType)this.globalAggreement.getAgreementContext().getModelObject()).getAny().iterator().next()) != null && obj instanceof Element) {
                    Element elmt = (Element)obj;
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.importNode(elmt, true));
                    alertDef = (AlertDefinition)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, AlertDefinition.class);
                }
                if (alertDef != null) {
                    try {
                        this.sendAlerts(alerts, alertDef);
                    }
                    catch (ESBException e) {
                        this.log.severe(e.getMessage());
                    }
                } else {
                    this.log.severe("No alertDefinition defined in agreement: " + this.globalAggreement.getName());
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
        }
        catch (ESBException e) {
            e.printStackTrace();
            this.log.severe(e.getMessage());
        }
    }

    private List<Alert> detectViolations(ReportList reports, ServiceLevelObjective slo, AgreementType ag) throws ESBException {
        Object responder;
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        Object initiator = ag.getAgreementContext().getAgreementInitiator();
        Alert alertOnGuarantee = this.detectViolationsOnGuarantee(reports, slo, initiator, responder = ag.getAgreementContext().getAgreementResponder());
        if (alertOnGuarantee != null) {
            alerts.add(alertOnGuarantee);
        }
        return alerts;
    }

    private Alert detectViolationsOnGuarantee(ReportList reports, ServiceLevelObjective slo, Object initiator, Object responder) throws ESBException {
        Alert alert = null;
        alert = this.detectLatencyViolation(slo, reports, initiator, responder);
        return alert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alert detectLatencyViolation(ServiceLevelObjective slo, ReportList reports, Object initiator, Object responder) throws ESBException {
        Alert alert;
        block22: {
            alert = null;
            long currentLatency = Long.MAX_VALUE;
            try {
                Object obj = slo.getKPITarget().getCustomServiceLevel();
                if (obj != null && obj instanceof Element) {
                    Element elmt = (Element)obj;
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.importNode(elmt, true));
                    ConstraintType target = (ConstraintType)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readFragment(doc, ConstraintType.class);
                    long expectedLatency = (long)(target.getValue().getValue().floatValue() * 1000.0f);
                    String alertType = "";
                    String certainty = "";
                    if (reports.getReports().length == 2) {
                        long current = new Date().getTime();
                        long t2 = reports.getReports()[1].getDateInGMT().getTime();
                        if (reports.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t1)) {
                            try {
                                LatencyViolationThread latencyViolationThread = this;
                                synchronized (latencyViolationThread) {
                                    this.wait(expectedLatency);
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            alertType = "(Potential)";
                            certainty = "Possible";
                        }
                        currentLatency = expectedLatency + 1L;
                    }
                    if (reports.getReports().length == 4 && reports.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t1) && reports.getReports()[1].getTimeStamp().equals((Object)TimeStampType.t2) && reports.getReports()[2].getTimeStamp().equals((Object)TimeStampType.t3) && reports.getReports()[3].getTimeStamp().equals((Object)TimeStampType.t4)) {
                        Report providerOut = reports.getReports()[2];
                        Report providerIn = reports.getReports()[1];
                        currentLatency = providerOut.getDateInGMT().getTime() - providerIn.getDateInGMT().getTime();
                        alertType = "(Confirmed)";
                        certainty = "Observed";
                    }
                    if (AbstractAlertManagerThread.InegalityOperator.GREATER_THAN.equals(target.getOperator()) && currentLatency <= expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not > to " + expectedLatency + " " + alertType, reports, AbstractAlertManagerThread.Level.SEVERE, initiator, responder);
                    } else if (AbstractAlertManagerThread.InegalityOperator.GREATER_THAN_OR_EQUALS.equals(target.getOperator()) && currentLatency < expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not >= to " + expectedLatency + " " + alertType, reports, AbstractAlertManagerThread.Level.SEVERE, initiator, responder);
                    } else if (AbstractAlertManagerThread.InegalityOperator.LESS_THAN.equals(target.getOperator()) && currentLatency >= expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not < to " + expectedLatency + " " + alertType, reports, AbstractAlertManagerThread.Level.SEVERE, initiator, responder);
                    } else if (AbstractAlertManagerThread.InegalityOperator.LESS_THAN_OR_EQUALS.equals(target.getOperator()) && currentLatency > expectedLatency) {
                        alert = this.createAlert(String.valueOf(slo.getKPITarget().getKPIName()) + " violation: " + "current " + slo.getKPITarget().getKPIName() + "(" + currentLatency + ")" + " is not <= to " + expectedLatency + " " + alertType, reports, AbstractAlertManagerThread.Level.SEVERE, initiator, responder);
                    } else if (!(AbstractAlertManagerThread.InegalityOperator.GREATER_THAN.equals(target.getOperator()) || AbstractAlertManagerThread.InegalityOperator.LESS_THAN.equals(target.getOperator()) || AbstractAlertManagerThread.InegalityOperator.GREATER_THAN_OR_EQUALS.equals(target.getOperator()) || AbstractAlertManagerThread.InegalityOperator.LESS_THAN_OR_EQUALS.equals(target.getOperator()))) {
                        throw new ESBException("Unknown agreement operator: " + target.getOperator());
                    }
                    Info info = (Info)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Info.class);
                    info.addCategory("Infra");
                    info.setEvent("SLA Violation");
                    info.setUrgency("Unknown");
                    info.setSeverity("Unknown");
                    info.setCertainty(certainty);
                    alert.addInfo(info);
                    break block22;
                }
                this.log.warning("Wrong number of reports to check SLAs!");
            }
            catch (ParserConfigurationException e) {
                throw new ESBException((Throwable)e);
            }
            catch (XmlObjectReadException e) {
                throw new ESBException((Throwable)e);
            }
        }
        return alert;
    }
}

