/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.AbstractAlertManagerThread;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.escapnote10.api.element.AlertNoteDefinition;
import com.ebmwebsourcing.escapnote10.api.element.InitiatorIdentifier;
import com.ebmwebsourcing.escapnote10.api.element.ResponderIdentifier;
import com.ebmwebsourcing.esqml10.api.type.ConstraintType;
import com.ebmwebsourcing.wsagreement10.api.element.GuaranteeTerm;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FrequencyViolationThread
extends AbstractAlertManagerThread
implements Runnable {
    private final Logger log = Logger.getLogger(FrequencyViolationThread.class.getName());
    private DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();
    private boolean stop;
    private List<Long> notifTimeStamps;
    private AlertDefinition alertDef;
    private ReportList reports;
    private AgreementType agreement;
    private ServiceLevelObjective slo;
    private final SOAPSender soapSender;
    private final AgreementManagerComponentBehaviour behaviour;
    private double freq = 0.0;
    private Object initiator;
    private Object responder;
    private static final long MINUTE_IN_SECONDS = 60000L;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public FrequencyViolationThread(AgreementManagerComponentBehaviour behaviour, ReportList reports, ServiceLevelObjective slo, AgreementType agreement) {
        super(new SOAPSender(), behaviour, agreement);
        this.reports = reports;
        this.agreement = agreement;
        this.slo = slo;
        this.soapSender = new SOAPSender();
        this.behaviour = behaviour;
        this.stop = false;
        this.notifTimeStamps = new CopyOnWriteArrayList<Long>();
        this.initiator = this.agreement.getAgreementContext().getAgreementInitiator();
        this.responder = this.agreement.getAgreementContext().getAgreementResponder();
        try {
            this.freq = this.extractFrequencyConstraint(slo);
            this.initAlertDefinition();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
        }
    }

    private void initAlertDefinition() throws ParserConfigurationException, XmlObjectReadException {
        Object obj;
        this.alertDef = (AlertDefinition)this.globalAggreement.getAgreementContext().findExtendedElement(AlertDefinition.class);
        if (this.alertDef == null && (obj = ((EJaxbAgreementContextType)this.globalAggreement.getAgreementContext().getModelObject()).getAny().iterator().next()) != null && obj instanceof Element) {
            Element elmt = (Element)obj;
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild(doc.importNode(elmt, true));
            this.alertDef = (AlertDefinition)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, AlertDefinition.class);
        }
    }

    private double extractFrequencyConstraint(ServiceLevelObjective slo) throws ParserConfigurationException, XmlObjectReadException {
        double res = -1.0;
        Object obj = slo.getKPITarget().getCustomServiceLevel();
        if (obj != null && obj instanceof Element) {
            Element elmt = (Element)obj;
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild(doc.importNode(elmt, true));
            ConstraintType target = (ConstraintType)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readFragment(doc, ConstraintType.class);
            res = target.getValue().getValue().floatValue();
            if (target.getValue().getUnit().getName().endsWith("second")) {
                res *= 60.0;
            }
        }
        return res;
    }

    public void addReport(Report report) {
        this.reports.addReport(report);
    }

    public ReportList getReports() {
        return this.reports;
    }

    @Override
    public void run() {
        block6: {
            try {
                if (this.notifTimeStamps.size() <= 1) break block6;
                long last = this.notifTimeStamps.get(this.notifTimeStamps.size() - 1);
                int cpt = 0;
                System.out.println("LIST SIZE : " + this.notifTimeStamps.size());
                int i = this.notifTimeStamps.size() - 2;
                while (i >= 0) {
                    ++cpt;
                    long window = last - this.notifTimeStamps.get(i);
                    if (window >= 60000L) {
                        if ((double)cpt > this.freq) {
                            String msg = "!!! Too many notifications events, actual frequeny: " + cpt + " notifications/minute !!!";
                            Alert a = this.createAlert(msg, this.reports, AbstractAlertManagerThread.Level.SEVERE, this.initiator, this.responder, "Observed");
                            System.out.println("SEND ALERT !!!!!!!!!!!");
                            this.sendAlert(a, this.alertDef);
                        }
                        break;
                    }
                    if ((double)cpt > this.freq * (double)window / 60000.0) {
                        long actualFreq = (long)cpt * 60000L / window;
                        String msg = "!!! Too many notifications events, actual frequeny: " + actualFreq + " notifications/minute !!!";
                        Alert a = this.createAlert(msg, this.reports, AbstractAlertManagerThread.Level.WARNING, this.initiator, this.responder, "Potential");
                        System.out.println("SEND ALERT (BEFORE ONE MINUTE) !!!!!!!!!!!");
                        this.sendAlert(a, this.alertDef);
                    }
                    --i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Alert createAlert(String msg, GuaranteeTerm g, ReportList reports, AbstractAlertManagerThread.Level level, Object initiator, Object responder) {
        EndpointAddress ea;
        Alert alert = (Alert)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Alert.class);
        alert.setIdentifier(reports.getReports()[0].getExchangeId());
        alert.setMsgType("Alert");
        alert.setSent(Calendar.getInstance().getTime());
        XmlObjectFactory factory = SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory();
        AlertNoteDefinition note = (AlertNoteDefinition)factory.create(AlertNoteDefinition.class);
        note.setMessage(msg);
        if (initiator instanceof EJaxbEndpointReferenceType) {
            try {
                EJaxbEndpointReferenceType initiatorEPR = (EJaxbEndpointReferenceType)initiator;
                ea = ESBUtil.analyzeURI((URI)new URI(initiatorEPR.getAddress().getValue()));
                InitiatorIdentifier initiatorEndpoint = (InitiatorIdentifier)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(InitiatorIdentifier.class);
                initiatorEndpoint.setEndpointName(ea.getEndpointname());
                initiatorEndpoint.setNamespaceURI(ea.getNamespace());
                if (ea.getServicename() != null) {
                    initiatorEndpoint.setServiceName(ea.getServicename());
                }
                note.setInitiatorIdentifier(initiatorEndpoint);
            }
            catch (Exception e) {
                this.log.severe("Failed to parse initiator URI ...");
            }
        }
        if (responder instanceof EJaxbEndpointReferenceType) {
            try {
                EJaxbEndpointReferenceType responderEPR = (EJaxbEndpointReferenceType)responder;
                ea = ESBUtil.analyzeURI((URI)new URI(responderEPR.getAddress().getValue()));
                ResponderIdentifier responderEndpoint = (ResponderIdentifier)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ResponderIdentifier.class);
                responderEndpoint.setEndpointName(ea.getEndpointname());
                responderEndpoint.setNamespaceURI(ea.getNamespace());
                responderEndpoint.setServiceName(ea.getServicename());
                note.setResponderIdentifier(responderEndpoint);
            }
            catch (Exception e) {
                this.log.severe("Failed to parse responder URI ...");
            }
        }
        String noteAsString = "";
        Document noteAsDOM = this.db.newDocument();
        try {
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)note, (Node)noteAsDOM);
        }
        catch (XmlObjectWriteException e) {
            this.log.severe("Failed to write note as dom in alert.");
        }
        noteAsString = String.valueOf(noteAsString) + XMLPrettyPrinter.prettyPrint((Document)noteAsDOM);
        alert.setNote(noteAsString);
        return alert;
    }

    @Override
    public void launchNotify() {
        this.notify();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    public void addNotif(ReportList reports2) {
        Long timeStamp = new Long(System.currentTimeMillis());
        System.out.println("TIMESTAMP : " + timeStamp);
        this.notifTimeStamps.add(timeStamp);
        System.out.println("LIST : \n" + this.notifTimeStamps);
        this.run();
    }

    public boolean isStop() {
        return this.stop;
    }

    public void stopThread() {
        this.stop = true;
    }
}

