/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.escad10.api.element.Protocol;
import com.ebmwebsourcing.escad10.api.element.To;
import com.ebmwebsourcing.escad10.protocol.soapnotif.api.element.Binding;
import com.ebmwebsourcing.escapnote10.api.element.AlertNoteDefinition;
import com.ebmwebsourcing.escapnote10.api.element.InitiatorIdentifier;
import com.ebmwebsourcing.escapnote10.api.element.ResponderIdentifier;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import easybox.fr.upmc.ns.ws_qml.ObjectFactory;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractAlertManagerThread
extends Thread {
    protected ReportList reports;
    protected ServiceLevelObjective slo;
    protected AgreementType globalAggreement;
    protected final SOAPSender soapSender;
    protected final AgreementManagerComponentBehaviour behaviour;
    protected DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class, ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public AbstractAlertManagerThread(SOAPSender soapSender, AgreementManagerComponentBehaviour behaviour, AgreementType ag) {
        this.soapSender = soapSender;
        this.behaviour = behaviour;
        this.globalAggreement = ag;
    }

    protected Alert createAlert(String msg, ReportList reports, Level level, Object initiator, Object responder, String certainty) {
        EndpointAddress ea;
        Alert alert = (Alert)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Alert.class);
        alert.setIdentifier(reports.getReports()[0].getExchangeId());
        alert.setMsgType("Alert");
        alert.setSent(Calendar.getInstance().getTime());
        XmlObjectFactory factory = SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory();
        AlertNoteDefinition note = (AlertNoteDefinition)factory.create(AlertNoteDefinition.class);
        note.setMessage(msg);
        if (initiator instanceof EJaxbEndpointReferenceType) {
            try {
                EJaxbEndpointReferenceType initiatorEPR = (EJaxbEndpointReferenceType)initiator;
                ea = ESBUtil.analyzeURI((URI)new URI(initiatorEPR.getAddress().getValue()));
                InitiatorIdentifier initiatorEndpoint = (InitiatorIdentifier)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(InitiatorIdentifier.class);
                initiatorEndpoint.setEndpointName(ea.getEndpointname());
                initiatorEndpoint.setNamespaceURI(ea.getNamespace());
                if (ea.getServicename() != null) {
                    initiatorEndpoint.setServiceName(ea.getServicename());
                }
                note.setInitiatorIdentifier(initiatorEndpoint);
            }
            catch (Exception e) {
                this.log.severe("Failed to parse initiator URI ...");
            }
        }
        if (responder instanceof EJaxbEndpointReferenceType) {
            try {
                EJaxbEndpointReferenceType responderEPR = (EJaxbEndpointReferenceType)responder;
                ea = ESBUtil.analyzeURI((URI)new URI(responderEPR.getAddress().getValue()));
                ResponderIdentifier responderEndpoint = (ResponderIdentifier)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ResponderIdentifier.class);
                responderEndpoint.setEndpointName(ea.getEndpointname());
                responderEndpoint.setNamespaceURI(ea.getNamespace());
                responderEndpoint.setServiceName(ea.getServicename());
                note.setResponderIdentifier(responderEndpoint);
            }
            catch (Exception e) {
                this.log.severe("Failed to parse responder URI ...");
            }
        }
        String noteAsString = "";
        Document noteAsDOM = this.db.newDocument();
        try {
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)note, (Node)noteAsDOM);
        }
        catch (XmlObjectWriteException e) {
            this.log.severe("Failed to write note as dom in alert.");
        }
        noteAsString = String.valueOf(noteAsString) + XMLPrettyPrinter.prettyPrint((Document)noteAsDOM);
        alert.setNote(noteAsString);
        Info info = (Info)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Info.class);
        info.addCategory("Infra");
        info.setEvent(msg);
        info.setUrgency("Unknown");
        info.setSeverity(level.toString());
        info.setCertainty(certainty);
        alert.addInfo(info);
        return alert;
    }

    public void launchNotify() {
        this.notify();
    }

    protected void sendAlerts(List<Alert> alerts, AlertDefinition alertDef) throws ESBException {
        To[] toArray = alertDef.getTos();
        int n = toArray.length;
        int n2 = 0;
        while (n2 < n) {
            To to = toArray[n2];
            Protocol[] protocolArray = to.getProtocols();
            int n3 = protocolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Protocol protocol = protocolArray[n4];
                Binding soapNotifBinding = (Binding)protocol.findBinding(Binding.class);
                if (soapNotifBinding != null) {
                    this.sendAlerts(alerts, to, soapNotifBinding);
                } else {
                    this.log.severe("Only soap-notification binding is supported to send alert for the moment!!!");
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void sendAlert(Alert alert, AlertDefinition alertDef) throws ESBException {
        To[] toArray = alertDef.getTos();
        int n = toArray.length;
        int n2 = 0;
        while (n2 < n) {
            To to = toArray[n2];
            Protocol[] protocolArray = to.getProtocols();
            int n3 = protocolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Protocol protocol = protocolArray[n4];
                Binding soapNotifBinding = (Binding)protocol.findBinding(Binding.class);
                if (soapNotifBinding != null) {
                    this.sendAlert(alert, to, soapNotifBinding);
                } else {
                    this.log.severe("Only soap-notification binding is supported to send alert for the moment!!!");
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void sendAlerts(List<Alert> alerts, To to, Binding soapNotifBinding) throws ESBException {
        for (Alert alert : alerts) {
            this.sendAlert(alert, to, soapNotifBinding);
        }
    }

    protected void sendAlert(Alert alert, To to, Binding soapNotifBinding) throws ESBException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)alert, (OutputStream)baos);
            ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
            Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
            String producerAddress = ((ProviderEndpoint)this.behaviour.getEndpoint()).getReference().toString();
            Notify notify = NotificationProducerThreadImpl.createNotification((String)producerAddress.trim(), (String)soapNotifBinding.getSoapAddress().trim(), (String)UUID.randomUUID().toString(), null, (String)"http://www.w3.org/TR/1999/REC-xpath-19991116", (Document)notifPayload);
            if (!soapNotifBinding.getSoapAddress().startsWith("http://")) {
                EndpointType ep = ((RegistryEndpointBehaviour)this.behaviour.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(URI.create(soapNotifBinding.getSoapAddress()));
                Exchange ex = NotificationProducerThreadImpl.createMessageExchange((EndpointBehaviour)this.behaviour, (String)soapNotifBinding.getSoapAddress(), (Notify)notify);
                this.log.info("send internal notification to: " + ex.getDestinationReference());
                this.behaviour.getEndpoint().getNode().getTransportersManager().push(ex, ep.getNode());
            } else {
                Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notify);
                this.soapSender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)request), soapNotifBinding.getSoapAddress(), null);
                this.log.info("Alert sended to " + soapNotifBinding.getSoapAddress());
            }
        }
        catch (TransportException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SOAPException e) {
            throw new ESBException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new ESBException((Throwable)e);
        }
        catch (XmlObjectWriteException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ESBException((Throwable)e);
        }
        catch (IOException e) {
            throw new ESBException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ESBException((Throwable)e);
        }
        catch (WsnbException e) {
            throw new ESBException((Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    protected static enum InegalityOperator {
        GREATER_THAN("&gt;"),
        LESS_THAN("&lt;"),
        GREATER_THAN_OR_EQUALS("&gt;="),
        LESS_THAN_OR_EQUALS("&lt;=");

        private String value = null;

        private InegalityOperator(String val) {
            this.value = val;
        }

        boolean equals(String val) {
            return this.value.equals(val);
        }
    }

    protected static enum Level {
        WARNING("Warning"),
        SEVERE("Severe");

        private String value = null;

        private Level(String val) {
            this.value = val;
        }

        public boolean equals(String val) {
            return this.value.equals(val);
        }

        public String toString() {
            return this.value;
        }
    }
}

