/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * MonitoringEngine-Core - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementCheckingProviderEndpoint;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementCheckingService;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.TechnicalServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=AgreementCheckingService.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class AgreementCheckingServiceImpl  extends TechnicalServiceImpl<TechnicalServiceType> implements
		AgreementCheckingService {

	/**
     *
     */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(AgreementCheckingServiceImpl.class
			.getName());

	public AgreementCheckingServiceImpl() throws ESBException {
		super();
	}
	
	public AgreementCheckingProviderEndpoint createSLACheckingEndpoint(
			final String endpointName)
			throws AgreementException {
		AgreementCheckingProviderEndpoint slaManagerProviderEndpoint = null;
		try {
			
			
			slaManagerProviderEndpoint = ((ServiceBehaviour)this.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(
					endpointName, 
					AgreementCheckingProviderEndpointImpl.class,
					AgreementCheckingProviderEndpointBehaviourImpl.class,
					null);
			slaManagerProviderEndpoint
			.addBehaviourClass(SubscriptionManagerEndpointBehaviourImpl.class);
			slaManagerProviderEndpoint
			.addBehaviourClass(NotificationProducerEndpointBehaviourImpl.class);

			String topicDef = "" +
					"<wstop:TopicSet xmlns:wstop=\"http://docs.oasis-open.org/wsn/t-1\" xmlns:tns1=\"http://www.semeuse.org/agreement-events.xml\" >\n" + 
					"    <tns1:AgreementTopic wstop:topic=\"true\" />\n" + 
					"</wstop:TopicSet>\n";
			InputStream is = new ByteArrayInputStream(topicDef.getBytes());
			TopicSetType topicSet = RefinedWstopFactory.getInstance(new WstopModelFactoryImpl()).getWstopReader().readTopicSetType(new InputSource(is));
			is.close();
			
			
			SubscriptionManagerEndpointBehaviour subscriptionManagerEndpointBehaviour = slaManagerProviderEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
			subscriptionManagerEndpointBehaviour.setEvenTopicNamespaceDefinitionUrl(Thread.currentThread().getContextClassLoader().getResource("topicNamespace/wsdm10/wsdm-mows-events.xml"));
			subscriptionManagerEndpointBehaviour.setTopicSet(topicSet);

			final TopicsManagerEngine wstopTopicsMgr = new TopicsManagerEngine();
			final SubscriptionManagerEngine subscriptionManager = new SubscriptionManagerEngine(
					log);

			subscriptionManager.setSubscriptionsManagerService(this.getQName());    
			final NotificationProducerEngine producer = new NotificationProducerEngine(
					log, wstopTopicsMgr, subscriptionManager, true,
					subscriptionManagerEndpointBehaviour.getTopicSet(), subscriptionManagerEndpointBehaviour.getTopicNs(), "wsn", null /*this.notifSender*/);
		
			subscriptionManagerEndpointBehaviour
			.setSubscriptionManager(subscriptionManager);
			
			NotificationProducerEndpointBehaviour notificationProducerEndpointBehaviour = slaManagerProviderEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
			notificationProducerEndpointBehaviour.setNotificationProducer(producer);


		} catch (final ESBException e) {
			throw new AgreementException(e);
		} catch (final WsnbException e) {
			throw new AgreementException(e);
		} catch (final IllegalArgumentException e) {
			throw new AgreementException(e);
		} catch (WstopException e) {
			throw new AgreementException(e);
		} catch (IOException e) {
			throw new AgreementException(e);
		} 
		return slaManagerProviderEndpoint;
	}


}
