package com.ebmwebsourcing.easyesb.technical.service.admin.impl;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.admin10.api.element.AdminService;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointInitialContextType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.service.AdminServiceBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.AdminEndpointImpl;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.BSMAdminEndpointBehaviourImpl;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;

public class BSMAdminExtensionFactory {

	private static Logger log = Logger.getLogger(BSMAdminExtensionFactory.class.getName());

	private AdminEndpoint<?> bsmadminEndpoint = null;
	private Service bsmadminService = null;

	public void addSpecificElements(QName name, Node node, Configuration conf) throws ESBException {

		// create admin service
		bsmadminService = this.createAdminService(node, name.getLocalPart() + "_bsmadmin", conf);

	//	((AdminServiceBehaviour)adminService.findBehaviour(AdminServiceBehaviour.class)).getAdminEndpoint().addBehaviourClass(BSMAdminEndpointBehaviourImpl.class);


	}

	public void exposeBSMAdminService(Node node) throws ESBException {
		
		SoapServer soapServer = (SoapServer) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
		if(soapServer == null) {
			throw new ESBException("Soap server cannot be null");
		}
		
		ClientProxyEndpoint clientEndpoint = (ClientProxyEndpoint) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName(node.getQName().getNamespaceURI(), "bsmadminExternalEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, null);
		clientEndpoint.addBehaviourClass(ClientProxyBehaviourImpl.class);
		clientEndpoint.setProviderServiceName(bsmadminService.getQName());
		clientEndpoint.setProviderEndpointName(bsmadminEndpoint.getQName());
		clientEndpoint.setExternalAddress("http://" + soapServer.getConfig().getHost() + ":" + soapServer.getConfig().getPort() + "/services/" + clientEndpoint.getQName().getLocalPart() + "/");
		assert clientEndpoint.getDescription() != null;
		SOAPListenerImpl soapListener = new SOAPListenerImpl(clientEndpoint, soapServer); 
		clientEndpoint.getExternalListeners().put("SOAP", soapListener);
	}

	public Service createAdminService(Node node, String name, Configuration conf) throws ESBException {
		Service adminService = null;
		
		EndpointInitialContextType context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
		context.setNumberOfThreads(5);
		try {
			// create model
			AdminService model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(AdminService.class);

			((TechnicalServiceType)model).setComponentParent(node.getQName());

			model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
			model.getBehavioursList().addBehaviour(conf.getAdminServiceBehaviourClass().getName());
			model.setType(conf.getAdminServiceClass().getName());
			model.setEndpointInitialContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class));

			model.setName(new QName(node.getQName().getNamespaceURI(),name));

			model.setNode(node.getQName());
			model.setBasicNodeInformations(node.getModel().getBasicNodeInformations());

			model.setProviderEndpointsGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ProviderEndpointsGroupList.class));


			// add service in registry
			boolean res = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());

			if(res) {
				// get component
				adminService = (Service) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
			}
		} catch (RegistryFault_Exception e) {
			throw new ESBException(e);
		}
		log.fine("registryService " + name + " created and started");

		// create admin endpoint
		this.bsmadminEndpoint = ((AdminServiceBehaviour)	adminService.findBehaviour(AdminServiceBehaviour.class)).createProviderEndpoint("bsmadminEndpoint_" + node.getQName().getLocalPart(), AdminEndpointImpl.class, (EndpointInitialContext) context);
		this.bsmadminEndpoint.addBehaviourClass(BSMAdminEndpointBehaviourImpl.class);

		
		
		return adminService;
	}


	public AdminEndpoint<?> getAdminEndpoint() {
		return this.bsmadminEndpoint;
	}
}
