/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.AgreementManagerComponentBehaviourImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.WSDMComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineBehaviourImpl;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BSMAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.bsmadmin._1.AgreementResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.ConnectToEsb;
import easierbsm.petalslink.com.data.bsmadmin._1.ConnectToEsbResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetAllMonitoringEndpoints;
import easierbsm.petalslink.com.data.bsmadmin._1.GetAllMonitoringEndpointsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetConnectedEsbs;
import easierbsm.petalslink.com.data.bsmadmin._1.GetConnectedEsbsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformations;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformationsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementRequest;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.MonitoringEndpointType;
import easierbsm.petalslink.com.data.bsmadmin._1.ObjectFactory;
import easierbsm.petalslink.com.data.bsmadmin._1.OperationListType;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementFromUrlRequest;
import easierbsm.petalslink.com.service.datacollector._1_0.AdminExceptionMsg;
import easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class BSMAdminEndpointBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements BSMAdminEndpointBehaviour {
    private final Logger log = Logger.getLogger(BSMAdminEndpointBehaviourImpl.class.getName());
    private ObjectFactory factory = new ObjectFactory();
    private AgreementManagerComponent slaManager;
    private WSDMMonitoringEngine monitoringEngine;
    private DataCollectorEngine dataCollectorEngine;
    private AdminEndpoint baseAdminEndpoint;

    public BSMAdminEndpointBehaviourImpl(AdminEndpoint<? extends ProviderEndpointType> ep) throws ESBException {
        super(ep);
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/bsmadmin10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(url, Definitions.class));
            this.setBinding((Binding)desc.getBindings().iterator().next());
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
    }

    public AgreementManagerComponent getSlaManager() throws ESBException {
        if (this.slaManager == null) {
            URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), "SLAManager"), null, new QueryParam[0]));
            this.slaManager = (AgreementManagerComponent)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(slaEpr);
        }
        if (this.slaManager == null) {
            throw new ESBException("slaManager cannot be null!!!");
        }
        return this.slaManager;
    }

    public DataCollectorEngine getDataCollectorEngine() throws ESBException {
        if (this.dataCollectorEngine == null) {
            URI dataEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
            this.dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
        }
        if (this.dataCollectorEngine == null) {
            throw new ESBException("dataCollectorEngine cannot be nul!!!");
        }
        return this.dataCollectorEngine;
    }

    public AdminEndpoint getBaseAdminEndpoint() throws ESBException {
        if (this.baseAdminEndpoint == null) {
            URI epr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.getEndpoint().getNode().getQName().getNamespaceURI(), this.getEndpoint().getNode().getQName().getLocalPart() + "_admin"), "adminEndpoint", new QueryParam[0]));
            this.baseAdminEndpoint = (AdminEndpoint)((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(epr);
        }
        if (this.baseAdminEndpoint == null) {
            throw new ESBException("baseAdminEndpoint cannot be nul!!!");
        }
        return this.baseAdminEndpoint;
    }

    public WSDMMonitoringEngine getMonitoringEngine() throws ESBException {
        if (this.monitoringEngine == null) {
            URI wsdmEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), WSDMComponentCreationFactory.WSDM_MONITORING_COMPONENT_NAME), null, new QueryParam[0]));
            this.monitoringEngine = (WSDMMonitoringEngine)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(wsdmEpr);
        }
        if (this.monitoringEngine == null) {
            throw new ESBException("monitoringEngine cannot be null!!!");
        }
        return this.monitoringEngine;
    }

    public void execute(Exchange exchange) throws TransportException {
        this.log.finest("BSM ADMIN BEHAVIOUR FOUND: " + exchange.getOperation());
        try {
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("connectToEsb")) {
                this.log.finest("Connect to ESB");
                ConnectToEsb connect = (ConnectToEsb)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ConnectToEsb.class);
                this.connectToEsb(connect.getAddress(), connect.isSynchronize());
                ConnectToEsbResponse connectResponse = new ConnectToEsbResponse();
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)connectResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getConnectedEsbs")) {
                this.log.finest("getConnectedEsbs");
                GetConnectedEsbs connect = (GetConnectedEsbs)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetConnectedEsbs.class);
                List<String> addresses = this.getConnectedEsbs();
                GetConnectedEsbsResponse connectResponse = new GetConnectedEsbsResponse();
                connectResponse.getEsbAddress().addAll(addresses);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)connectResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getNodeInformations")) {
                this.log.info("Get Node Informations");
                GetNodeInformations getNodeInformations = (GetNodeInformations)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetNodeInformations.class);
                GetNodeInformationsResponse getNodeInformationsResponse = this.getNodeInformations(getNodeInformations);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)getNodeInformationsResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getAllMonitoringEndpoints")) {
                this.log.finest("GET ALL MONITORING ENDPOINTS");
                GetAllMonitoringEndpoints getAllMonitoringEndpoints = (GetAllMonitoringEndpoints)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetAllMonitoringEndpoints.class);
                List<MonitoringEndpointType> res = this.getAllMonitoringEndpoints();
                GetAllMonitoringEndpointsResponse getAllMonitoringEndpointsResponse = this.factory.createGetAllMonitoringEndpointsResponse();
                for (MonitoringEndpointType mep : res) {
                    getAllMonitoringEndpointsResponse.getEndpoint().add(mep);
                }
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)getAllMonitoringEndpointsResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("activateBusinessMonitoring")) {
                this.log.finest("Activate Business Monitoring");
                Document activateDom = exchange.getMessageIn().getBody().getPayload();
                ActivateBusinessMonitoring activateIn = (ActivateBusinessMonitoring)SOAJAXBContext.getInstance().marshallAnyType(activateDom, ActivateBusinessMonitoring.class);
                ActivateBusinessMonitoringType activateInType = new ActivateBusinessMonitoringType();
                activateInType.setServiceName(activateIn.getActivateBusinessMonitoring().getServiceName());
                activateInType.setEndpointName(activateIn.getActivateBusinessMonitoring().getEndpointName());
                activateInType.setAllOperations(activateIn.getActivateBusinessMonitoring().getAllOperations());
                activateInType.setFrequency(activateIn.getActivateBusinessMonitoring().getFrequency());
                boolean res = this.activateBusinessMonitoring(activateInType);
                ActivateBusinessMonitoringResponse response = new ActivateBusinessMonitoringResponse();
                response.setActivateBunsinessMonitoringResponseModel(res);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("unActivateBusinessMonitoring")) {
                this.log.finest("Activate Business Monitoring");
                Document unactivateDom = exchange.getMessageIn().getBody().getPayload();
                UnActivateBusinessMonitoring unactivateIn = (UnActivateBusinessMonitoring)SOAJAXBContext.getInstance().marshallAnyType(unactivateDom, UnActivateBusinessMonitoring.class);
                UnActivateBusinessMonitoringType unactivateInType = new UnActivateBusinessMonitoringType();
                unactivateInType.setServiceName(unactivateIn.getUnActivateBusinessMonitoring().getServiceName());
                unactivateInType.setEndpointName(unactivateIn.getUnActivateBusinessMonitoring().getEndpointName());
                unactivateInType.setAllOperations(unactivateIn.getUnActivateBusinessMonitoring().getAllOperations());
                boolean res = this.unActivateBusinessMonitoring(unactivateInType);
                UnActivateBusinessMonitoringResponse response = new UnActivateBusinessMonitoringResponse();
                response.setUnActivateBusinessMonitoringResponse(res);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("loadAgreementFromUrl")) {
                this.log.finest("LOAD AGREEMENT FROM URL");
                easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementFromUrlRequest lurl = (easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementFromUrlRequest)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementFromUrlRequest.class);
                LoadAgreementResponse res = this.loadAgreementFromUrl(lurl);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)res));
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("loadAgreementFromDocument")) {
                this.log.finest("LOAD AGREEMENT FROM DOCUMENT");
                LoadAgreementRequest lag = (LoadAgreementRequest)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), LoadAgreementRequest.class);
                LoadAgreementResponse res = this.loadAgreementFromDocument(lag);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)res));
            } else {
                super.execute(exchange);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Document docEx = ErrorUtil.createBusinessOrTechnicalError((Exception)e, (String)"getFaultInfo");
                Document fault = SOAPHandler.createSoapFault((Document)docEx);
                MessageUtil.getInstance().createErrorMessageStructure(exchange);
                exchange.getMessageError().getBody().setPayload(fault);
                this.log.severe("ERROR IN BSM ADMIN: \n" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageError().getBody().getPayload()));
            }
            catch (Exception ex) {
                throw new TransportException((Throwable)ex);
            }
        }
    }

    public void connectToEsb(String address, Boolean synchronize) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        try {
            if (synchronize == null || synchronize.booleanValue()) {
                ((WSDMMonitoringEngineBehaviour)this.getMonitoringEngine().findBehaviour(WSDMMonitoringEngineBehaviour.class)).synchronize(address);
            }
            ((DataCollectorEngineBehaviour)this.getDataCollectorEngine().findBehaviour(DataCollectorEngineBehaviour.class)).connectToEsb(address);
            ((DataCollectorEngineBehaviour)this.getDataCollectorEngine().findBehaviour(DataCollectorEngineBehaviour.class)).addEsbNode(address);
        }
        catch (ConnectToEsbFault e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
    }

    public void unconnectToEsb(String address) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg("Not Implemented!!!");
    }

    public boolean activateBusinessMonitoring(ActivateBusinessMonitoringType activateBusinessMonitoring) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        try {
            return this.getMonitoringEngine().activateBusinessMonitoring(activateBusinessMonitoring.getServiceName(), activateBusinessMonitoring.getEndpointName(), activateBusinessMonitoring.getOperation());
        }
        catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
        }
    }

    public boolean unActivateBusinessMonitoring(UnActivateBusinessMonitoringType unActivateBusinessMonitoring) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        try {
            return this.getMonitoringEngine().unActivateBusinessMonitoring(unActivateBusinessMonitoring.getServiceName(), unActivateBusinessMonitoring.getEndpointName(), unActivateBusinessMonitoring.getOperation());
        }
        catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
        }
    }

    public List<MonitoringEndpointType> getAllMonitoringEndpoints() throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        ArrayList<MonitoringEndpointType> res = new ArrayList<MonitoringEndpointType>();
        try {
            List mes = ((WSDMMonitoringEngineBehaviourImpl)this.getMonitoringEngine().findBehaviour(WSDMMonitoringEngineBehaviourImpl.class)).getAllMonitoringEndpoints();
            for (easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType me : mes) {
                MonitoringEndpointType m = new MonitoringEndpointType();
                m.setAddress(me.getAddress());
                m.setName(me.getName());
                OperationListType o = new OperationListType();
                o.getOperationName().addAll(me.getOperations().getOperationName());
                m.setOperations(o);
                res.add(m);
            }
        }
        catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public LoadAgreementResponse loadAgreementFromDocument(LoadAgreementRequest parameters) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        LoadAgreementResponse res = new LoadAgreementResponse();
        try {
            easierbsm.petalslink.com.data.slamanager._1.LoadAgreementRequest request = new easierbsm.petalslink.com.data.slamanager._1.LoadAgreementRequest();
            request.setAgreement(parameters.getAgreement());
            easierbsm.petalslink.com.data.slamanager._1.LoadAgreementResponse response = ((AgreementManagerComponentBehaviour)this.getSlaManager().findBehaviour(AgreementManagerComponentBehaviourImpl.class)).loadAgreementFromDocument(request);
            AgreementResponse agRes = new AgreementResponse();
            agRes.setAgreementName(response.getOut().getAgreementName());
            agRes.setId(response.getOut().getId());
            res.setOut(agRes);
        }
        catch (easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public LoadAgreementResponse loadAgreementFromUrl(easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementFromUrlRequest parameters) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        LoadAgreementResponse res = new LoadAgreementResponse();
        try {
            LoadAgreementFromUrlRequest request = new LoadAgreementFromUrlRequest();
            request.setUrl(parameters.getUrl());
            easierbsm.petalslink.com.data.slamanager._1.LoadAgreementResponse response = ((AgreementManagerComponentBehaviour)this.getSlaManager().findBehaviour(AgreementManagerComponentBehaviourImpl.class)).loadAgreementFromUrl(request);
            AgreementResponse agRes = new AgreementResponse();
            agRes.setAgreementName(response.getOut().getAgreementName());
            agRes.setId(response.getOut().getId());
            res.setOut(agRes);
        }
        catch (easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public GetNodeInformationsResponse getNodeInformations(GetNodeInformations parameters) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        GetNodeInformationsResponse response = new GetNodeInformationsResponse();
        try {
            easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse res = ((BaseAdminEndpointBehaviour)this.getBaseAdminEndpoint().findBehaviour(BaseAdminEndpointBehaviour.class)).getNodeInformations(new easyesb.petalslink.com.data.admin._1.GetNodeInformations());
            response.setNode(res.getNode());
        }
        catch (ManagementException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public List<String> getConnectedEsbs() throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        try {
            return ((DataCollectorEngineBehaviour)this.getDataCollectorEngine().findBehaviour(DataCollectorEngineBehaviour.class)).getEsbNodeAddresses();
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
    }

    public void monitorEndpoints(String notificationAddress, List<MonitoringEndpointType> endpoint) throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
        try {
            ArrayList<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType> endpoints = new ArrayList<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType>();
            for (MonitoringEndpointType ep : endpoint) {
                easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType e = new easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType();
                e.setAddress(ep.getAddress());
                e.setName(e.getName());
                endpoints.add(e);
            }
            ((WSDMMonitoringEngineBehaviour)this.getMonitoringEngine().findBehaviour(WSDMMonitoringEngineBehaviour.class)).monitorEndpoints(notificationAddress, endpoints);
        }
        catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ESBException e) {
            throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

