/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.admin.client.impl;

import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easierbsm.admin.client.api.BSMAdminClient;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;

import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.bsmadmin._1.AdminFault;
import easierbsm.petalslink.com.data.bsmadmin._1.ConnectToEsb;
import easierbsm.petalslink.com.data.bsmadmin._1.ConnectToEsbResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetAllMonitoringEndpoints;
import easierbsm.petalslink.com.data.bsmadmin._1.GetAllMonitoringEndpointsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetConnectedEsbs;
import easierbsm.petalslink.com.data.bsmadmin._1.GetConnectedEsbsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformations;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformationsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementFromUrlRequest;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementRequest;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.MonitorEndpoints;
import easierbsm.petalslink.com.data.bsmadmin._1.MonitorEndpointsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.MonitoringEndpointType;
import easierbsm.petalslink.com.data.bsmadmin._1.ObjectFactory;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.bsmadmin._1.UnconnectToEsb;
import easierbsm.petalslink.com.data.bsmadmin._1.UnconnectToEsbResponse;
import easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg;

public class BSMAdminClientImplSOAP extends AdminClientImplSOAP implements BSMAdminClient {

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}
	}

    public BSMAdminClientImplSOAP(String address) throws ESBException {
        super(address);
    }


	@Override
	public List<MonitoringEndpointType> getAllMonitoringEndpoints()
			throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
		GetAllMonitoringEndpointsResponse response = null;
		try {
			GetAllMonitoringEndpoints payload = new GetAllMonitoringEndpoints();
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/getAllMonitoringEndpoints");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, GetAllMonitoringEndpointsResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response.getEndpoint();
	}


    @Override
    public boolean activateBusinessMonitoring(
            ActivateBusinessMonitoringType activateBusinessMonitoring) throws AdminExceptionMsg {
        ActivateBusinessMonitoringResponse response = new ActivateBusinessMonitoringResponse();


        try {

            ActivateBusinessMonitoring in = new ActivateBusinessMonitoring();
            in.setActivateBusinessMonitoring(activateBusinessMonitoring);
            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(in));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/activateBusinessMonitoring");
            if(soapHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
                AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new AdminExceptionMsg("Business Fault", fault);
            }

            // get bpel store response
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
            response = SOAJAXBContext.getInstance().marshallAnyType(doc, ActivateBusinessMonitoringResponse.class);
        } catch (JDOMException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAPException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (ParserConfigurationException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        }


        return response.isActivateBunsinessMonitoringResponseModel();
    }


    @Override
    public boolean unActivateBusinessMonitoring(
            UnActivateBusinessMonitoringType unActivateBusinessMonitoring) throws AdminExceptionMsg {
      
        
        UnActivateBusinessMonitoringResponse response = new UnActivateBusinessMonitoringResponse();
        UnActivateBusinessMonitoring in = new UnActivateBusinessMonitoring();
        in.setUnActivateBusinessMonitoring(unActivateBusinessMonitoring);
        try {

            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(in));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/unActivateBusinessMonitoring");
            if(soapHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
                AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new AdminExceptionMsg("Business Fault", fault);
            }

            // get bpel store response
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
            response = SOAJAXBContext.getInstance().marshallAnyType(doc, UnActivateBusinessMonitoringResponse.class);
        } catch (JDOMException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAPException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (ParserConfigurationException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        }


        return response.isUnActivateBusinessMonitoringResponse();
    }


	@Override
	public void connectToEsb(String address) throws AdminExceptionMsg {
		ConnectToEsb in = new ConnectToEsb();
        in.setAddress(address);
        try {

            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(in));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, this.address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/connectToEsb");
            if(SOAPHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
                AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new AdminExceptionMsg("Business Fault", fault);
            }
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
            ConnectToEsbResponse response = SOAJAXBContext.getInstance().marshallAnyType(doc, ConnectToEsbResponse.class);
        } catch (JDOMException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAPException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (ParserConfigurationException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        }
	}


	@Override
	public void unconnectToEsb(String address) throws AdminExceptionMsg {
		UnconnectToEsb in = new UnconnectToEsb();
        in.setAddress(address);
        try {

            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(in));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/unconnectToEsb");
            if(SOAPHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
                AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new AdminExceptionMsg("Business Fault", fault);
            }
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
            UnconnectToEsbResponse response = SOAJAXBContext.getInstance().marshallAnyType(doc, UnconnectToEsbResponse.class);
        } catch (JDOMException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAPException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (ParserConfigurationException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        }
	}


	@Override
	public LoadAgreementResponse loadAgreementFromDocument(
			LoadAgreementRequest parameters) throws AdminExceptionMsg {
		LoadAgreementResponse response = new LoadAgreementResponse();
        try {

            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/loadAgreementFromDocument");
            if(SOAPHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
                AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new AdminExceptionMsg("Business Fault", fault);
            }

            // get bpel store response
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
            response = SOAJAXBContext.getInstance().marshallAnyType(doc, LoadAgreementResponse.class);
        } catch (JDOMException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAPException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (ParserConfigurationException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        }


        return response;
	}


	@Override
	public LoadAgreementResponse loadAgreementFromUrl(
			LoadAgreementFromUrlRequest parameters) throws AdminExceptionMsg {
		LoadAgreementResponse response = new LoadAgreementResponse();
        try {

            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/loadAgreementFromUrl");
            if(SOAPHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
                AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new AdminExceptionMsg("Business Fault", fault);
            }

            // get bpel store response
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
            response = SOAJAXBContext.getInstance().marshallAnyType(doc, LoadAgreementResponse.class);
        } catch (JDOMException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAPException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (ParserConfigurationException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        }


        return response;
	}


	@Override
	public GetNodeInformationsResponse getNodeInformations(
			GetNodeInformations parameters) throws AdminExceptionMsg {
		GetNodeInformationsResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/getNodeInformations");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, GetNodeInformationsResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}


	@Override
	public List<String> getConnectedEsbs() throws AdminExceptionMsg {
		GetConnectedEsbsResponse response = null;
		try {
			GetConnectedEsbs parameters = new GetConnectedEsbs();
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/getNodeInformations");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, GetConnectedEsbsResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response.getEsbAddress();
	}


	@Override
	public void monitorEndpoints(String notificationAddress,
			List<MonitoringEndpointType> endpoint) throws AdminExceptionMsg {
		MonitorEndpoints in = new MonitorEndpoints();
        in.setNotificationAddress(notificationAddress);
        in.getEndpoint().addAll(endpoint);
        try {

            Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(in));
            Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/bsmadmin/1.0/monitorEndpoints");
            if(SOAPHandler.isSoapFault(soapResponse)) {
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
                AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
                System.err.println("\n\nError message: \n" + fault.getMessage());
                System.err.println("Stack trace: \n" + fault.getStacktrace());
                throw new AdminExceptionMsg("Business Fault", fault);
            }
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
            MonitorEndpointsResponse response = SOAJAXBContext.getInstance().marshallAnyType(doc, MonitorEndpointsResponse.class);
        } catch (JDOMException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (SOAPException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        } catch (ParserConfigurationException e) {
            throw new AdminExceptionMsg("Technical Fault", e);
        }
	}
    
  




    



  

}
