package com.ebmwebsourcing.easierbsm.sla.manager.client;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;

import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementFromUrlRequest;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementRequest;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementResponse;
import easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg;
import easierbsm.petalslink.com.service.slamanager._1_0.SlaManager;

public class SLAManagerClient implements SlaManager {

	private String address;
	private SlaManager clientProxy;
	
    public SLAManagerClient(String address) {
        this.address = address;
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized SlaManager getSLAClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, SlaManager.class);
        return clientProxy;
    }
	
	
	
	@Override
	public LoadAgreementResponse loadAgreementFromUrl(
			LoadAgreementFromUrlRequest parameters) throws AdminExceptionMsg {
		return this.getSLAClientProxy().loadAgreementFromUrl(parameters);
	}

	@Override
	public void connectToDataCollector() throws AdminExceptionMsg {
		this.getSLAClientProxy().connectToDataCollector();
	}

	@Override
	public LoadAgreementResponse loadAgreementFromDocument(
			LoadAgreementRequest parameters) throws AdminExceptionMsg {
		return this.getSLAClientProxy().loadAgreementFromDocument(parameters);
	}

}
