/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api;

import java.util.Map;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */

public interface WSDMProviderEndpoint extends ProviderEndpoint<com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType> {

	static final String WSDM_MONITORING_SUFFIXE = "_WSDMMonitoring";

	WSDMMonitoringEngine getMonitoringEngine();
	
	void setMonitoringEngine(WSDMMonitoringEngine me);
	
	Map<QName, OperationMetrics> getOperationMetricsMap();
	
	void setFunctionalDescription(Description desc);
	
	Description getFunctionalDescription();

	void setFunctionalNodeInfo(EJaxbBasicNodeInformationsType env);
	
	EJaxbBasicNodeInformationsType getFunctionalNodeInfo();
	
	
}
