/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;


public class Endpoint {

    private String name;
    private QName service;

    private QName _interface;

    private Description description;


    private Logger log  = Logger.getLogger(this.getClass().getCanonicalName());


    /**
     * Gets the value of the description property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public Description getDescription() {
        return this.description;
    }

    /**
     * Gets the value of the interface property.
     * 
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the interface property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getInterface().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list {@link QName }
     * 
     * 
     */
    public QName getInterface() {
        return this._interface;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getName() {
        return this.name;
    }

    /**
     * Gets the value of the service property.
     * 
     * @return possible object is {@link QName }
     * 
     */
    public QName getService() {
        return this.service;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *            allowed object is {@link String }
     * 
     */
    public void setDescription(final Description value) {
        this.description = value;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *            allowed object is {@link String }
     * 
     */
    public void setName(final String value) {
        this.name = value;
    }

    /**
     * Sets the value of the service property.
     * 
     * @param value
     *            allowed object is {@link QName }
     * 
     */
    public void setService(final QName value) {
        this.service = value;
    }

 
    

    @Override
    public String toString() {
        return "Endpoint [_interface=" + this._interface + ",  description=" + this.description + ", name=" + this.name
        + ", service=" + this.service + "]";
    }

}
