/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * MonitoringEngine-Core - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMService;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.thread.BusinessMonitoringThread;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=WSDMMonitoringEngine.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class WSDMMonitoringEngineImpl extends ComponentImpl<com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType> implements
WSDMMonitoringEngine {


	/* Map that manages threads activation according to business monitoring requested */
	private Map<QName, BusinessMonitoringThread> businessMonitoringThreads = new HashMap<QName, BusinessMonitoringThread>();

	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(WSDMMonitoringEngineImpl.class
			.getName());


	private AdminEndpoint<?> adminEndpoint = null;


	public WSDMService createMonitoringService(final QName service)
			throws ESBException {
		return ((ComponentBehaviour)this.findBehaviour(ComponentBehaviour.class)).createService(service, WSDMServiceImpl.class);
	}





	@Override
	public boolean activateBusinessMonitoring(QName endpoint, List<QName> operations) {

		boolean ok = true;

		/* QName of the WSDM endpoint corresponding to the input endpoint */
		QName mepQName = new QName(endpoint.getNamespaceURI(), endpoint.getLocalPart() + WSDMProviderEndpoint.WSDM_MONITORING_SUFFIXE);

		EJaxbEndpointType functionalEDP = null;
		Endpoint<? extends EndpointType> functionalLocalEDP = null;

		//TODO Improve by not taking the first service but the correct one ... (its name ?)
		WSDMProviderEndpoint pedp = ((WSDMProviderEndpoint)((ServiceBehaviourImpl)((WSDMService)((ComponentBehaviour)this.findBehaviour(ComponentBehaviour.class)).getServices().get(0)).findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoint(mepQName));

		if(pedp != null){
			try {
				String addressofdispatcher = "http://localhost:"+((NodeBehaviour)this.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration().getExternalServers().get(0).getPort()+
						"/services/"+ESBDataCollectorFactoryImpl.DISPATCHER_PROVIDER_ENDPOINT_NAME+"ClientProxyEndpoint";

				((RegistryEndpointBehaviour)this.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode(pedp.getFunctionalNodeInfo());
			} catch (RegistryFault_Exception e) {
				e.printStackTrace();
			} catch (ESBException e) {
				e.printStackTrace();
			}

			/* Actual business monitoring managemenent ... Threads are launched form here */
			BusinessMonitoringThread thread = this.businessMonitoringThreads.get(endpoint);
			if(thread == null){



				thread = new BusinessMonitoringThread(endpoint, pedp, this.getNode().getQName(), operations, this);

				this.businessMonitoringThreads.put(endpoint, thread);

				thread.start();
			}else{
				//TODO Manage activation at operation level (update list of operations here)
			}
		}

		return true;
	}


	@Override
	public boolean unActivateBusinessMonitoring(QName endpoint, List<QName> operations) {
		if(this.businessMonitoringThreads.containsKey(endpoint)){
			this.businessMonitoringThreads.get(endpoint).stopExecution();

			try {
				Thread.sleep(BusinessMonitoringThread.getSleep());
				this.businessMonitoringThreads.get(endpoint).join(BusinessMonitoringThread.getSleep());
				this.businessMonitoringThreads.put(endpoint, null);

			} catch (InterruptedException e1) {
				// do nothing
				e1.printStackTrace();
			}

			this.businessMonitoringThreads.remove(endpoint);
			return true;
		}
		return false;
	}


	public Map<QName, BusinessMonitoringThread> getBusinessMonitoringThreads() {
		return businessMonitoringThreads;
	}

	@Override
	public AdminEndpoint<?> getAdminEndpoint() {
		return adminEndpoint;
	}


	@Override
	public void setAdminEndpoint(AdminEndpoint<?> adminEndpoint) {
		this.adminEndpoint = adminEndpoint;
	}

}
