/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core;

import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineBehaviourImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ESBWSDMFactoryImpl
implements ESBFactory {
    private static Logger log = Logger.getLogger(ESBWSDMFactoryImpl.class.getName());
    public static QName WSDM_MONITORING_COMPONENT_NAME = new QName("http://petals.ow2.org", "WSDMMonitoring");
    private ESBFactoryImpl parentFactory = new ESBFactoryImpl();

    public Node createNode(QName name, Configuration conf) throws ESBException {
        Node node = this.parentFactory.createDefaultNode(name, conf);
        Endpoint dispatcher = ((RegistryEndpointBehaviour)node.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName("http://petals.ow2.org", "DispatcherProviderEndpoint"));
        if (dispatcher == null) {
            ESBDataCollectorFactoryImpl.createDataCollector((Node)node, (ESBFactory)this, (Configuration)conf);
        }
        ESBWSDMFactoryImpl.createWSDMMonitoring(node, this, conf);
        return node;
    }

    public static void createWSDMMonitoring(Node node, ESBFactory factory, Configuration conf) throws ESBException {
        WSDMMonitoringEngine wsdmMonitoringEngine = (WSDMMonitoringEngine)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(WSDM_MONITORING_COMPONENT_NAME, WSDMMonitoringEngineImpl.class);
        wsdmMonitoringEngine.addBehaviourClass(WSDMMonitoringEngineBehaviourImpl.class);
        AdminEndpoint adminEndpoint = factory.getAdminEndpoint();
        wsdmMonitoringEngine.setAdminEndpoint(adminEndpoint);
        SoapServer soapServer = (SoapServer)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
        if (soapServer == null) {
            throw new ESBException("Soap server cannot be null");
        }
    }

    public static WSDMMonitoringEngine getWSDMMonitoring(Node node) throws ESBException {
        return (WSDMMonitoringEngine)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(WSDM_MONITORING_COMPONENT_NAME);
    }

    public Configuration getDefaultConfiguration() throws ESBException {
        return this.parentFactory.getDefaultConfiguration();
    }

    public void addSpecificElements(QName arg0, Node arg1, Configuration arg2) throws ESBException {
    }

    public AdminEndpoint<?> getAdminEndpoint() {
        return this.parentFactory.getAdminEndpoint();
    }
}

