/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineBehaviourImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.factory.ESBCoreFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractComponentCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;

public class WSDMComponentCreationFactory extends AbstractComponentCreationFactory {

	private static Logger log = Logger.getLogger(WSDMComponentCreationFactory.class.getName());

	public static QName WSDM_MONITORING_COMPONENT_NAME = new QName("http://petals.ow2.org", "WSDMMonitoring");

	
	@Override
	public String getId() {
		return "wsdm-monitoring-factory";
	}
	
	
	public Component<?> createComponent(ESBCoreFactory factory, Node node, Configuration conf) throws ESBException {
		// add wsdm support
		final WSDMMonitoringEngine wsdmMonitoringEngine = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(
				WSDM_MONITORING_COMPONENT_NAME,
				WSDMMonitoringEngineImpl.class);
		wsdmMonitoringEngine.addBehaviourClass(WSDMMonitoringEngineBehaviourImpl.class);

		if(!(factory instanceof ESBFactory)) {
			throw new ESBException("the factory must inherit of an ESBFactory!!!");
		}
		
		final AdminEndpoint<?> adminEndpoint =  ((ESBFactory)factory).getAdminEndpoint();		
		wsdmMonitoringEngine.setAdminEndpoint(adminEndpoint);

		SoapServer soapServer = (SoapServer) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
		if(soapServer == null) {
			throw new ESBException("Soap server cannot be null");
		}

		return wsdmMonitoringEngine;
	}


	public static WSDMMonitoringEngine getWSDMMonitoring(final Node node) throws ESBException {
		return  (WSDMMonitoringEngine) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(
				WSDM_MONITORING_COMPONENT_NAME);
	}


}
