/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * MonitoringEngine-Core - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMService;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.thread.BusinessMonitoringThread;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=WSDMMonitoringEngine.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class WSDMMonitoringEngineImpl extends ComponentImpl<com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType> implements
WSDMMonitoringEngine {


	/* Map that manages threads activation according to business monitoring requested */
	private Map<QName, BusinessMonitoringThread> businessMonitoringThreads = new HashMap<QName, BusinessMonitoringThread>();

	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(WSDMMonitoringEngineImpl.class
			.getName());


	private AdminEndpoint<?> adminEndpoint = null;

	private static EJaxbBasicNodeInformationsType oneFunctionalNodeInfo = null;


	public WSDMService createMonitoringService(final QName service)
			throws ESBException {
		return ((ComponentBehaviour)this.findBehaviour(ComponentBehaviour.class)).createService(service, WSDMServiceImpl.class);
	}

	@Override
	public boolean activateBusinessMonitoring(QName endpoint, List<QName> operations) throws AdminExceptionMsg {

		boolean ok = true;

		/* QName of the WSDM endpoint corresponding to the input endpoint */
		QName mepQName = new QName(endpoint.getNamespaceURI(), endpoint.getLocalPart() + WSDMProviderEndpoint.WSDM_MONITORING_SUFFIXE);

		//TODO Improve by not taking the first service but the correct one ... (its name ?)
		WSDMProviderEndpoint wsdmpedp = ((WSDMProviderEndpoint)((ServiceBehaviourImpl)((WSDMService)((ComponentBehaviour)this.findBehaviour(ComponentBehaviour.class)).getServices().get(0)).findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoint(mepQName));

		if(wsdmpedp != null){
			try {
				/* Find a functional node to link the monitoring node with (and create corresponding admin client) */
				NodeBehaviour nodeBehaviour = ((NodeBehaviour)wsdmpedp.getNode().findBehaviour(NodeBehaviour.class));
				AdminClientImplSOAP adminClient = null;
				if(oneFunctionalNodeInfo == null){
					//TODO is there a location where static name of DataCollector is defined?
					QName dataCollectorComponent = new QName("http://petals.ow2.org", "DataCollector");
					List<String> nodeAddresses = ((DataCollectorEngineBehaviour)nodeBehaviour.getComponent(dataCollectorComponent).findBehaviour(DataCollectorEngineBehaviour.class)).getEsbNodeAddresses();
					if(nodeAddresses != null && nodeAddresses.size()>0){
						String esbAddress = nodeAddresses.get(0);
						adminClient = new AdminClientImplSOAP(esbAddress);
						try {
							oneFunctionalNodeInfo = retrieveNodeInfo(adminClient);
						} catch (ManagementException e) {
							throw new AdminExceptionMsg(e.getMessage(), e);
						}
					}
				}

				if(oneFunctionalNodeInfo == null) throw new AdminExceptionMsg("No functional node found to be connected with ... severe issue while activating business monitoring.");

				((RegistryEndpointBehaviour)this.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode(oneFunctionalNodeInfo);


				/* Actual business monitoring managemenent ... Threads are launched form here */
				BusinessMonitoringThread thread = this.businessMonitoringThreads.get(endpoint);
				if(thread == null){

					if(wsdmpedp.getFunctionalDescription() == null && adminClient != null){

						Description d = null; 
						try {
							d = retrieveFunctionalDescription(wsdmpedp, adminClient);
						} catch (ManagementException e) {
							throw new AdminExceptionMsg(e.getMessage(), e);
						}
						wsdmpedp.setFunctionalDescription(d);
					}

					thread = new BusinessMonitoringThread(endpoint, wsdmpedp, this.getNode().getQName(), operations, this);

					this.businessMonitoringThreads.put(endpoint, thread);

					thread.start();
				}else{
					//TODO Manage activation at operation level (update list of operations here)
				}

			} catch (RegistryFault_Exception e) {
				throw new AdminExceptionMsg(e.getMessage());
			} catch (ESBException e) {
				throw new AdminExceptionMsg(e.getMessage());
			}  catch (ParserConfigurationException e) {
				throw new AdminExceptionMsg(e.getMessage());
			} catch (XmlObjectReadException e) {
				throw new AdminExceptionMsg(e.getMessage());
			}
		}
		return true;
	}

	private EJaxbBasicNodeInformationsType retrieveNodeInfo(AdminClientImplSOAP adminClient) throws ManagementException {
		GetNodeInformations payload = new GetNodeInformations();
		GetNodeInformationsResponse nodeInfo = adminClient.getNodeInformations(payload);
		return nodeInfo.getNode().getBasicNodeInformations();      
	}

	private Description retrieveFunctionalDescription(WSDMProviderEndpoint edp,  AdminClientImplSOAP adminClient) throws ParserConfigurationException, XmlObjectReadException, ManagementException {
		Description res = null; 

		/* Endpoint address built from edp info */
		String endpointName = edp.getName().substring(edp.getName().indexOf("}")+1, edp.getName().indexOf("_WSDMMonitoring"));
		QName serviceQName = edp.getServiceProvider().getQName();

		EndpointAddress ea = new EndpointAddress(serviceQName.getNamespaceURI(), serviceQName.getLocalPart(), endpointName);
		URI uriOfEndpoint = ESBUtil.generateURI(ea);
		log.finest("uri of edp : "+uriOfEndpoint);
		EJaxbResourceIdentifier resourceIdentifier = new EJaxbResourceIdentifier();
		resourceIdentifier.setResourceType("endpoint");
		resourceIdentifier.setId(uriOfEndpoint.toString());

		easyesb.petalslink.com.data.admin._1.GetContent getContent = new easyesb.petalslink.com.data.admin._1.GetContent();
		getContent.setResourceIdentifier(resourceIdentifier);
		easyesb.petalslink.com.data.admin._1.GetContentResponse response = adminClient.getContent(getContent);


		Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
		doc.appendChild(doc.importNode((Element)response.getAny(), true));

		Definitions def = SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(doc, Definitions.class);
		res = (Description)Factory.getInstance().wrap(def);
		return res;
	}

	@Override
	public boolean unActivateBusinessMonitoring(QName endpoint, List<QName> operations) throws AdminExceptionMsg {
		if(this.businessMonitoringThreads.containsKey(endpoint)){
			this.businessMonitoringThreads.get(endpoint).stopExecution();

			try {
				Thread.sleep(BusinessMonitoringThread.getSleep());
				this.businessMonitoringThreads.get(endpoint).join(BusinessMonitoringThread.getSleep());
				this.businessMonitoringThreads.put(endpoint, null);

			} catch (InterruptedException e1) {
				// do nothing
				e1.printStackTrace();
			}

			this.businessMonitoringThreads.remove(endpoint);
			return true;
		}
		return false;
	}

	public Map<QName, BusinessMonitoringThread> getBusinessMonitoringThreads() {
		return businessMonitoringThreads;
	}

	@Override
	public AdminEndpoint<?> getAdminEndpoint() {
		return adminEndpoint;
	}

	@Override
	public void setAdminEndpoint(AdminEndpoint<?> adminEndpoint) {
		this.adminEndpoint = adminEndpoint;
	}

}
