/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMService;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMServiceImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.thread.BusinessMonitoringThread;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import easyesb.petalslink.com.data.admin._1.GetContent;
import easyesb.petalslink.com.data.admin._1.GetContentResponse;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Scope(value="COMPOSITE")
@Service(value={WSDMMonitoringEngine.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class WSDMMonitoringEngineImpl
extends ComponentImpl<ComponentType>
implements WSDMMonitoringEngine {
    private Map<QName, BusinessMonitoringThread> businessMonitoringThreads = new HashMap<QName, BusinessMonitoringThread>();
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(WSDMMonitoringEngineImpl.class.getName());
    private AdminEndpoint<?> adminEndpoint = null;
    private static EJaxbBasicNodeInformationsType oneFunctionalNodeInfo = null;

    @Override
    public WSDMService createMonitoringService(QName service) throws ESBException {
        return (WSDMService)((ComponentBehaviour)this.findBehaviour(ComponentBehaviour.class)).createService(service, WSDMServiceImpl.class);
    }

    @Override
    public boolean activateBusinessMonitoring(QName endpoint, List<QName> operations) throws AdminExceptionMsg {
        block13: {
            boolean ok = true;
            QName mepQName = new QName(endpoint.getNamespaceURI(), String.valueOf(endpoint.getLocalPart()) + "_WSDMMonitoring");
            WSDMProviderEndpoint wsdmpedp = (WSDMProviderEndpoint)((ServiceBehaviourImpl)((WSDMService)((ComponentBehaviour)this.findBehaviour(ComponentBehaviour.class)).getServices().get(0)).findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoint(mepQName);
            if (wsdmpedp != null) {
                try {
                    QName dataCollectorComponent;
                    List nodeAddresses;
                    NodeBehaviour nodeBehaviour = (NodeBehaviour)wsdmpedp.getNode().findBehaviour(NodeBehaviour.class);
                    AdminClientImplSOAP adminClient = null;
                    if (oneFunctionalNodeInfo == null && (nodeAddresses = ((DataCollectorEngineBehaviour)nodeBehaviour.getComponent(dataCollectorComponent = new QName("http://petals.ow2.org", "DataCollector")).findBehaviour(DataCollectorEngineBehaviour.class)).getEsbNodeAddresses()) != null && nodeAddresses.size() > 0) {
                        String esbAddress = (String)nodeAddresses.get(0);
                        adminClient = new AdminClientImplSOAP(esbAddress);
                        try {
                            oneFunctionalNodeInfo = this.retrieveNodeInfo(adminClient);
                        }
                        catch (ManagementException e) {
                            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (oneFunctionalNodeInfo == null) {
                        throw new AdminExceptionMsg("No functional node found to be connected with ... severe issue while activating business monitoring.");
                    }
                    ((RegistryEndpointBehaviour)this.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode(oneFunctionalNodeInfo);
                    BusinessMonitoringThread thread = this.businessMonitoringThreads.get(endpoint);
                    if (thread != null) break block13;
                    if (wsdmpedp.getFunctionalDescription() == null && adminClient != null) {
                        Description d = null;
                        try {
                            d = this.retrieveFunctionalDescription(wsdmpedp, adminClient);
                        }
                        catch (ManagementException e) {
                            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
                        }
                        wsdmpedp.setFunctionalDescription(d);
                    }
                    thread = new BusinessMonitoringThread(endpoint, (Endpoint)wsdmpedp, this.getNode().getQName(), operations, this);
                    this.businessMonitoringThreads.put(endpoint, thread);
                    thread.start();
                }
                catch (RegistryFault_Exception e) {
                    throw new AdminExceptionMsg(e.getMessage());
                }
                catch (ESBException e) {
                    throw new AdminExceptionMsg(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new AdminExceptionMsg(e.getMessage());
                }
                catch (XmlObjectReadException e) {
                    throw new AdminExceptionMsg(e.getMessage());
                }
            }
        }
        return true;
    }

    private EJaxbBasicNodeInformationsType retrieveNodeInfo(AdminClientImplSOAP adminClient) throws ManagementException {
        GetNodeInformations payload = new GetNodeInformations();
        GetNodeInformationsResponse nodeInfo = adminClient.getNodeInformations(payload);
        return nodeInfo.getNode().getBasicNodeInformations();
    }

    private Description retrieveFunctionalDescription(WSDMProviderEndpoint edp, AdminClientImplSOAP adminClient) throws ParserConfigurationException, XmlObjectReadException, ManagementException {
        Description res = null;
        String endpointName = edp.getName().substring(edp.getName().indexOf("}") + 1, edp.getName().indexOf("_WSDMMonitoring"));
        QName serviceQName = edp.getServiceProvider().getQName();
        EndpointAddress ea = new EndpointAddress(serviceQName.getNamespaceURI(), serviceQName.getLocalPart(), endpointName);
        URI uriOfEndpoint = ESBUtil.generateURI((EndpointAddress)ea);
        log.finest("uri of edp : " + uriOfEndpoint);
        EJaxbResourceIdentifier resourceIdentifier = new EJaxbResourceIdentifier();
        resourceIdentifier.setResourceType("endpoint");
        resourceIdentifier.setId(uriOfEndpoint.toString());
        GetContent getContent = new GetContent();
        getContent.setResourceIdentifier(resourceIdentifier);
        GetContentResponse response = adminClient.getContent(getContent);
        Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        doc.appendChild(doc.importNode((Element)response.getAny(), true));
        Definitions def = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, Definitions.class);
        res = (Description)Factory.getInstance().wrap((XmlObject)def);
        return res;
    }

    @Override
    public boolean unActivateBusinessMonitoring(QName endpoint, List<QName> operations) throws AdminExceptionMsg {
        if (this.businessMonitoringThreads.containsKey(endpoint)) {
            this.businessMonitoringThreads.get(endpoint).stopExecution();
            try {
                Thread.sleep(BusinessMonitoringThread.getSleep());
                this.businessMonitoringThreads.get(endpoint).join(BusinessMonitoringThread.getSleep());
                this.businessMonitoringThreads.put(endpoint, null);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.businessMonitoringThreads.remove(endpoint);
            return true;
        }
        return false;
    }

    @Override
    public Map<QName, BusinessMonitoringThread> getBusinessMonitoringThreads() {
        return this.businessMonitoringThreads;
    }

    @Override
    public AdminEndpoint<?> getAdminEndpoint() {
        return this.adminEndpoint;
    }

    @Override
    public void setAdminEndpoint(AdminEndpoint<?> adminEndpoint) {
        this.adminEndpoint = adminEndpoint;
    }
}

