package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.ReportListType;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.ReportType;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.wsdm10.api.element.LastRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.MaxRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfFailedRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfSuccessfulRequests;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsdm10.api.element.ServiceTime;
import com.ebmwebsourcing.wsdm10.api.type.DurationMetric;
import com.ebmwebsourcing.wsdm10.api.type.IntegerCounter;

import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;

public class MetricsBuilder {

    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    private ProviderEndpoint endpoint;
    
    private Map<String, ReportListType> existingMetrics = new ConcurrentHashMap<String, ReportListType>();
    
    public MetricsBuilder(ProviderEndpoint endpoint) {
        this.endpoint = endpoint;
    }
    
    private OperationMetrics createQosMetrics(final String operationName,
            final QName itfName)  {
        final OperationMetrics metrics = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(OperationMetrics.class);

        // serviceTime
        final ServiceTime serviceTime = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ServiceTime.class);

        // maxResponseTime
        final MaxResponseTime maxResponseTime = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseTime.class);

        // lastResponseTime
        final LastResponseTime lastResponseTime = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseTime.class);

        // numberOfSuccessfulRequests
        final NumberOfSuccessfulRequests numberOfSuccessfulRequests = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfSuccessfulRequests.class);

        // numberOfRequests
        final NumberOfRequests numberOfRequests = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfRequests.class);

        // numberOfFailedRequests
        final NumberOfFailedRequests numberOfFailedRequests = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfFailedRequests.class);

        // maxRequestSize
        final MaxRequestSize maxRequestSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxRequestSize.class);

        // maxResponseSize
        final MaxResponseSize maxResponseSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseSize.class);

        // lastRequestSize
        final LastRequestSize lastRequestSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastRequestSize.class);

        // lastResponseSize
        final LastResponseSize lastResponseSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseSize.class);

        // set values in metrics
        metrics.setOperationName(operationName);
        metrics.setPortType(itfName);
        metrics.setServiceTime(serviceTime);
        metrics.setMaxResponseTime(maxResponseTime);
        metrics.setLastResponseTime(lastResponseTime);
        metrics.setNumberOfSuccessfulRequests(numberOfSuccessfulRequests);
        metrics.setNumberOfRequests(numberOfRequests);
        metrics.setNumberOfFailedRequests(numberOfFailedRequests);
        metrics.setMaxRequestSize(maxRequestSize);
        metrics.setMaxResponseSize(maxResponseSize);
        metrics.setLastRequestSize(lastRequestSize);
        metrics.setLastResponseSize(lastResponseSize);
        return metrics;
    }


    private void updateMetric(final OperationMetrics metric,
            final long intLastRequestSize, final long intLastResponseSize,
            final Date startDate, final Date endDate,
            final boolean responseTypeSuccess, final boolean responseTypeFail, final boolean incrementNumberOfRequests)
                    throws ESBException {
        log.finest("UPDATE METRICS !!!!");
        try {
            // lastRequestSize
            final IntegerCounter lastRequestSize = metric.getLastRequestSize();
            lastRequestSize.setValue(intLastRequestSize);
            lastRequestSize.setLastUpdated(Calendar.getInstance().getTime());
            if (lastRequestSize.getResetAt() == null) {
                lastRequestSize.setResetAt(Calendar.getInstance().getTime());
            }
            metric.setLastRequestSize((LastRequestSize) lastRequestSize);

            // lastResponseSize
            final IntegerCounter lastResponseSize = metric.getLastResponseSize();
            lastResponseSize.setValue(intLastResponseSize);
            lastResponseSize.setLastUpdated(Calendar.getInstance().getTime());
            if (lastResponseSize.getResetAt() == null) {
                lastResponseSize.setResetAt(Calendar.getInstance().getTime());
            }
            metric.setLastResponseSize((LastResponseSize) lastResponseSize);

            // maxRequestSize
            final IntegerCounter maxRequestSize = metric.getMaxRequestSize();
            if (maxRequestSize.getValue() == null) {
                maxRequestSize.setValue(metric.getLastRequestSize().getValue()
                        .longValue());
                maxRequestSize.setLastUpdated(Calendar.getInstance().getTime());
                if (maxRequestSize.getResetAt() == null) {
                    maxRequestSize.setResetAt(Calendar.getInstance().getTime());
                }
            } else if ((maxRequestSize.getValue() != null)
                    && (maxRequestSize.getValue().intValue() < metric
                            .getLastRequestSize().getValue().intValue())) {
                maxRequestSize.setValue(metric.getLastRequestSize().getValue()
                        .longValue());
                maxRequestSize.setLastUpdated(Calendar.getInstance().getTime());
                if (maxRequestSize.getResetAt() == null) {
                    maxRequestSize.setResetAt(Calendar.getInstance().getTime());
                }
            }

            metric.setMaxRequestSize((MaxRequestSize)maxRequestSize);

            // maxResponseSize
            final IntegerCounter maxResponseSize = metric.getMaxResponseSize();
            if (maxResponseSize.getValue() == null) {
                maxResponseSize.setValue(metric.getLastResponseSize()
                        .getValue().longValue());
                maxResponseSize
                .setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseSize.getResetAt() == null) {
                    maxResponseSize
                    .setResetAt(Calendar.getInstance().getTime());
                }
            } else if ((maxResponseSize.getValue() != null)
                    && (maxResponseSize.getValue().intValue() < metric
                            .getLastResponseSize().getValue().intValue())) {
                maxResponseSize.setValue(metric.getLastResponseSize()
                        .getValue().longValue());
                maxResponseSize
                .setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseSize.getResetAt() == null) {
                    maxResponseSize
                    .setResetAt(Calendar.getInstance().getTime());
                }
            }

            metric.setMaxResponseSize((MaxResponseSize)maxResponseSize);

            // lastResponseTime
            final DurationMetric lastResponseTime = metric.getLastResponseTime();
            if ((startDate != null) && (endDate != null)) {
                final long time = endDate.getTime() - startDate.getTime();
                lastResponseTime.setValue(DatatypeFactory.newInstance()
                        .newDuration(time));
                lastResponseTime.setLastUpdated(Calendar.getInstance()
                        .getTime());
                if (lastResponseTime.getResetAt() == null) {
                    lastResponseTime.setResetAt(Calendar.getInstance()
                            .getTime());
                }
            }

            metric.setLastResponseTime((LastResponseTime)lastResponseTime);

            // maxResponseTime
            final DurationMetric maxResponseTime = metric.getMaxResponseTime();
            if (maxResponseTime.getValue() == null) {
                maxResponseTime.setValue(metric.getLastResponseTime()
                        .getValue());
                maxResponseTime
                .setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseTime.getResetAt() == null) {
                    maxResponseTime
                    .setResetAt(Calendar.getInstance().getTime());
                }
            } else if ((maxResponseTime.getValue() != null)
                    && (maxResponseTime.getValue().compare(
                            metric.getLastResponseTime().getValue()) < DatatypeConstants.LESSER)) {
                maxResponseTime.setValue(metric.getLastResponseTime()
                        .getValue());
                maxResponseTime
                .setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseTime.getResetAt() == null) {
                    maxResponseTime
                    .setResetAt(Calendar.getInstance().getTime());
                }
            }

            metric.setMaxResponseTime((MaxResponseTime)maxResponseTime);

            // serviceTime
            final DurationMetric serviceTime = metric.getServiceTime();
            if (serviceTime.getValue() == null) {
                serviceTime.setValue(lastResponseTime.getValue());
            } else {
                serviceTime.setValue(serviceTime.getValue().add(lastResponseTime.getValue()));
                serviceTime.setValue(serviceTime.getValue().multiply(new BigDecimal(0.5)));
            }
            if (serviceTime.getResetAt() == null) {
                serviceTime.setResetAt(Calendar.getInstance().getTime());
            }
            serviceTime.setLastUpdated(Calendar.getInstance().getTime());

            metric.setServiceTime((ServiceTime) serviceTime);

            // numberOfRequests
            final IntegerCounter numberOfRequests = metric.getNumberOfRequests();
            if (numberOfRequests.getValue() == null) {
                numberOfRequests.setValue((long) 0);
            }
            if(incrementNumberOfRequests){
                numberOfRequests.setValue(numberOfRequests.getValue() + 1);
            }
            if (numberOfRequests.getResetAt() == null) {
                numberOfRequests.setResetAt(Calendar.getInstance().getTime());
            }
            numberOfRequests.setLastUpdated(Calendar.getInstance().getTime());

            metric.setNumberOfRequests((NumberOfRequests) numberOfRequests);

            // numberOfSuccessfulRequests
            final IntegerCounter numberOfSuccessfulRequests = metric
                    .getNumberOfSuccessfulRequests();
            if (numberOfSuccessfulRequests.getValue() == null) {
                numberOfSuccessfulRequests.setValue((long) 0);

            }
            if (responseTypeSuccess == true && incrementNumberOfRequests) {
                numberOfSuccessfulRequests.setValue(numberOfSuccessfulRequests
                        .getValue() + 1);
            }
            if (numberOfSuccessfulRequests.getResetAt() == null) {
                numberOfSuccessfulRequests.setResetAt(Calendar.getInstance()
                        .getTime());
            }
            numberOfSuccessfulRequests.setLastUpdated(Calendar.getInstance()
                    .getTime());

            metric.setNumberOfSuccessfulRequests((NumberOfSuccessfulRequests) numberOfSuccessfulRequests);

            // numberOfFailedRequests
            final IntegerCounter numberOfFailedRequests = metric
                    .getNumberOfFailedRequests();
            if (numberOfFailedRequests.getValue() == null) {
                numberOfFailedRequests.setValue((long) 0);
            }
            if (responseTypeFail == true && incrementNumberOfRequests) {
                numberOfFailedRequests.setValue(numberOfFailedRequests
                        .getValue() + 1);
            }
            if (numberOfFailedRequests.getResetAt() == null) {
                numberOfFailedRequests.setResetAt(Calendar.getInstance()
                        .getTime());
            }
            numberOfFailedRequests.setLastUpdated(GregorianCalendar
                    .getInstance().getTime());

            metric.setNumberOfFailedRequests((NumberOfFailedRequests)numberOfFailedRequests);

        } catch (final DatatypeConfigurationException e) {
            throw new ESBException(e);
        }

    }


    
    public void addNewReportList(EJaxbReportListType addNewReportListRequest) {
        ReportListType reports = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().wrap(addNewReportListRequest, ReportListType.class);
        if (reports.getReports().length == 2){

            final ReportType reportProviderIn = reports.getReports()[0];
            final ReportType reportProviderOut = reports.getReports()[1];

            if(reports.getReports()[0].getTimeStamp() != null && reports.getReports()[0].getTimeStamp().equals(TimeStampType.t1)) {

                try {
                    this.log.finest("addNewReport - retrieve metrics ... "+ this.endpoint.getName());
                    OperationMetrics metric = ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap()
                            .get(QName.valueOf(reportProviderIn
                                    .getOperationName().trim()));
                    this.log.finest("addNewReport - is there metric : "+metric+" for operation "+QName.valueOf(reportProviderIn
                            .getOperationName()));
                    if (metric == null) {

                        // create new metric
                        QName itfName = null;
                        if (reportProviderIn.getInterfaceQName() != null) {
                            itfName = reportProviderIn.getInterfaceQName();
                        }
                        metric = this.createQosMetrics(reportProviderIn
                                .getOperationName(), itfName);

                        ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap().put(QName.valueOf(reportProviderIn
                                .getOperationName().trim()), metric);

                        this.log
                        .info("metric created for operation: "
                                + reportProviderIn.getOperationName());
                    }

                    int requestLength = new Long(reportProviderIn.getContentLength()).intValue();
                    int responseLength = new Long(reportProviderOut.getContentLength()).intValue();
//                    this.updateMetric(metric, requestLength, responseLength,
//                            reportProviderIn.getDateInGMT(), reportProviderOut
//                            .getDateInGMT(), reportProviderOut.isDoesThisResponseIsAnException(),
//                            reportProviderOut.isDoesThisResponseIsAnException(), false);

                    existingMetrics.put(reportProviderIn.getExchangeId(), reports);



                } catch (final Exception e) {
                    log.severe(e.getMessage());
                    e.printStackTrace();
                }
            }else if(reports.getReports()[0].getTimeStamp() != null && reports.getReports()[0].getTimeStamp().equals(TimeStampType.t3)){

                try{


                    ReportListType contained = this.existingMetrics.get(reports.getReports()[0].getExchangeId());
                    long start = System.currentTimeMillis();
                    long timeout = 60000;
                    while(contained == null  && (System.currentTimeMillis() - start < timeout)){
                        Thread.sleep(500);
                        contained = this.existingMetrics.get(reports.getReports()[0].getExchangeId());
                    }
                    if(contained != null){
                        OperationMetrics metricToUpdate = ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap()
                                .get(QName.valueOf(reportProviderIn
                                        .getOperationName().trim()));
                        
                        long lastRequestSize = contained.getReports()[0].getContentLength();
                        long lastResponseSize = reports.getReports()[0].getContentLength();
                        Date startDate = contained.getReports()[1].getDateInGMT();
                        Date endDate = reports.getReports()[0].getDateInGMT();
                        boolean isException = reports.getReports()[1].isDoesThisResponseIsAnException();
                        
                        this.updateMetric(metricToUpdate, lastRequestSize, lastResponseSize, startDate, endDate,
                                !isException, isException, true);

                        
                        Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                        SOAUtil.getInstance().getWriter(EasierBSMFramework.getInstance()).get().writeDocument(metricToUpdate, notifPayload);
                        QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability","tns");
                        String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";

                        NotificationProducerEndpointBehaviour producerBehaviour = (NotificationProducerEndpointBehaviour) this.endpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
                        if(producerBehaviour == null) {
                            throw new ESBException("Internal Error: This endpoint " + this.endpoint.getName() + " has no producer behaviour to send notification");

                        }
                        SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour = (SubscriptionManagerEndpointBehaviour) this.endpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
                        if(subscriptionManagerBehaviour == null) {
                            throw new ESBException("Internal Error: This endpoint " + this.endpoint.getName() + " has no producer behaviour to send notification");

                        }

                        final NotificationProducerThreadImpl notifier = new NotificationProducerThreadImpl(
                                producerBehaviour, subscriptionManagerBehaviour, notifPayload, topicUsed, dialect);

                        notifier.start();


                    }else{
                        this.log.severe("No T1/T2 reports found for this T3/T4 report ... "+reportProviderIn.getExchangeId()+"..."+reportProviderIn.getOperationName());
                    }
                } catch (final Exception e) {
                    log.severe(e.getMessage());
                    e.printStackTrace();
                }

            }
        } else {
            log.severe("Incorrect number of report");
        }
    }
    
}
