/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.petalslink.esstar.essynchronizer.impl.ResourceException;
import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class WSDMCreationEndpointManager {
    private static Logger LOG = Logger.getLogger(WSDMCreationEndpointManager.class.getName());
    private List<Endpoint> functionnalEndpoints = new ArrayList<Endpoint>();
    private final WSDMMonitoringEngineBehaviour adminBehaviour;

    public WSDMCreationEndpointManager(WSDMMonitoringEngineBehaviour wsdmAdminBehaviour) {
        this.adminBehaviour = wsdmAdminBehaviour;
    }

    public void analyzeResource(EJaxbResourceIdentifier rid) throws ResourceException {
        try {
            EndpointAddress endpoint = ESBUtil.analyzeURI((URI)URI.create(rid.getId()));
            Endpoint ep = null;
            if (endpoint != null) {
                ep = this.createEndpoint(endpoint);
            }
            if (ep != null && !this.contains(this.functionnalEndpoints, ep)) {
                this.addMonitoringEndpointFromThisFunctionalEndpoint(ep);
                this.functionnalEndpoints.add(ep);
            }
        }
        catch (Throwable e) {
            LOG.finest("This Resource '" + rid + "' cannot be analysed by " + this.getClass().getSimpleName());
        }
    }

    private Endpoint createEndpoint(EndpointAddress epr) throws ESBException {
        Endpoint ep = null;
        ep = new Endpoint();
        ep.setName(epr.getEndpointname());
        ep.setService(new QName(epr.getNamespace(), epr.getServicename()));
        return ep;
    }

    private boolean contains(List<Endpoint> functionnalEndpoints, Endpoint ep) {
        boolean res = false;
        for (Endpoint e : functionnalEndpoints) {
            if (!e.getName().equals(ep.getName()) || !e.getService().equals(ep.getService())) continue;
            res = true;
            break;
        }
        return res;
    }

    private void addMonitoringEndpointFromThisFunctionalEndpoint(Endpoint ep) throws ESBException {
        try {
            System.out.println("ddddddddddddddddddddddddddddddddddddddddddddddddddddddd ep serv = " + ep.getService());
            System.out.println("ddddddddddddddddddddddddddddddddddddddddddddddddddddddd ep = " + ep.getName());
            this.adminBehaviour.createMonitoringEndpoint(ep.getService(), String.valueOf(ep.getName()) + "_WSDMMonitoring", true);
        }
        catch (AdminExceptionMsg e) {
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
    }
}

