/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * MonitoringEngine-Core - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api;

import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.thread.BusinessMonitoringThread;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;

import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */

public interface WSDMMonitoringEngine extends Component<com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType> {

	public static final String DEFAULT_MONITORING_NAME = "wsdm-monitoring-engine";


	WSDMService createMonitoringService(final QName service) throws ESBException;



	boolean activateBusinessMonitoring(QName serviceName, String endpointName,
			List<QName> operations) throws AdminExceptionMsg;
	
	boolean unActivateBusinessMonitoring(QName serviceName, String endpointName, List<QName> operations) throws AdminExceptionMsg;

	Map<URI, BusinessMonitoringThread> getBusinessMonitoringThreads();


	
	
	AdminEndpoint<?> getAdminEndpoint();

	void setAdminEndpoint(AdminEndpoint<?> adminEndpoint);


}
