package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.thread;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.wsdm10.api.element.LastRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.MaxRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfFailedRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfSuccessfulRequests;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsdm10.api.element.ServiceTime;

public class BusinessMonitoringThread extends Thread {

    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());


    private static long sleep = 1000 * 30;

    private static long timeout = 2000;

    private Map<String, Document> monitoredOperations = new HashMap<String, Document>();

    private URI functionalEndpoint = null;


    private Endpoint wsdmEndpoint = null;

    private QName sourceNodeQName = null;

    private boolean finished = false;

    private List<QName> monitoredOperationsQName = new ArrayList<QName>();

    private WSDMMonitoringEngine parent;

    private DocumentBuilder documentBuilder;

    


    @Override
    protected void finalize() throws Throwable {
        super.finalize();

        DocumentBuilders.releaseDocumentBuilder(this.documentBuilder);

    }

    public BusinessMonitoringThread(URI functionalEndpoint, Endpoint wsdmEndpoint, QName sourceNodeQName, List<QName> operations, WSDMMonitoringEngine parent){
        this.log.finest("New BusinessMonitoringThread "+this.getId()+" for "+functionalEndpoint+" "+wsdmEndpoint.getName()+" "+sourceNodeQName+" "+operations);
        
        this.functionalEndpoint = functionalEndpoint;
        this.wsdmEndpoint = wsdmEndpoint;
        this.sourceNodeQName  = sourceNodeQName;
        this.monitoredOperationsQName = operations;
        this.parent = parent;
        this.init();
        this.documentBuilder = DocumentBuilders.takeDocumentBuilder();
        

    }

    @Override
    public void run() { 
        if(this.wsdmEndpoint != null){
            this.log.finest("init finished ... operations to be monitored : "+this.monitoredOperationsQName.toArray(new QName[this.monitoredOperationsQName.size()]));
            
            while(!finished && (this.parent != null)){
                execute();
                try {
                    Thread.sleep(sleep);
                } catch (InterruptedException e) {
                    this.stopExecution();
                    throw new RuntimeException("BusinessMonitoringThread failed to fall asleep ... "+this.sleep);
                }
            }
        }
    }

    /* Find operations QName to call*/
    private void init() {
        this.log.finest("Business monitoring init for thread "+this.getId());

        Description d = ((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription();

        for(Interface i : d.getInterfaces()){
            /* For each operation get Current response*/
            for(Operation o : i.getOperations()){
            	
                if(o.getInput().getElement() != null) {
                    Type type = null;
                    try{
                        type = o.getInput().getElement().findType();
                        XmlObjectXPathEvaluator xpathEvaluator = type.getXmlContext().createXPathEvaluator();
                        XmlObjectNode obj = xpathEvaluator.selectSingleXmlObjectNode(o.getInput().getElement(), "//*[@name='"+o.getInput().getElement().getName()+"']/*[local-name()='complexType']/*[local-name()='sequence']/*[local-name()='element']", XmlObjectNode.class);
                        if(obj == null){

                            this.monitoredOperationsQName.add(new QName(i.getQName().getNamespaceURI(), o.getName()));
                        }
                    }catch (Exception e) {
                        this.monitoredOperationsQName.add(new QName(i.getQName().getNamespaceURI(), o.getName()));
                    }
                }else{
                    this.monitoredOperationsQName.add(new QName(i.getQName().getNamespaceURI(), o.getName()));
                }
            }
        }
    }

  

    private void execute() {

        this.log.finest("new Business Monitoring loop ...");
        Exchange exchange;

        try {

            for(QName op : this.monitoredOperationsQName){
                this.log.finest("business monitoring of operation "+op);
                
                exchange =   ((ClientEndpoint)this.wsdmEndpoint).createExchange();
                MessageUtil.getInstance().createInMessageStructure(exchange);
                Header h = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Header.class);
                exchange.getMessageIn().setHeader(h);
                Description desc = ((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription();

                Interface itf = null;
                Operation o = null;
                for(Interface i : desc.getInterfaces()){
                    Operation[] operations = i.getOperations();
                    boolean found = false;
                    for(int j=0 ; j<operations.length ; j++){
                        if(operations[j].inferQName().equals(op)){
                            found = true;
                            o = operations[j];
                            break;
                        }
                    }
                    if(found){
                        itf = i;
                        break;
                    }
                }


                if(itf != null && ((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription().findServicesImplementingInterface(itf).size()>0){
                    
                	exchange.setServiceName(((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription().findServicesImplementingInterface(itf).get(0).getQName());
                    exchange.setInterfaceName(itf.getQName());
                    exchange.setOperation(op.toString());
                    
                    exchange.setDestinationReference(this.functionalEndpoint);
                    exchange.setPattern(PatternType.IN_OUT);
                    URI epr = ESBUtil.generateURI(new EndpointAddress(this.sourceNodeQName, null));
                    exchange.setSourceReference(epr);
                    Document input = this.documentBuilder.newDocument();

                    Node root = input.createElementNS(o.getInput().getMessageName().getNamespaceURI(), o.getInput().getMessageName().getLocalPart());
                    input.appendChild(root);
                    exchange.getMessageIn().getBody().setPayload(input);
                    /* Call getter on business web service */
                    this.log.finest("Business monitoring : going to send to op "+op+" with payload\n"+XMLPrettyPrinter.prettyPrint(input));
                    
                    ((ClientEndpoint)this.wsdmEndpoint).sendSync(exchange, 30000);

                }
                /* If ok, set current info with MessageOut */
                if(exchange.getMessageOut().hasBody() && exchange.getMessageOut().getBody().hasPayload()){
                	log.finest("Business monitoring : soap response\n"+ XMLPrettyPrinter.prettyPrint(exchange.getMessageOut().getBody().getPayload()));
                    ;
                    this.monitoredOperations.put(op.getLocalPart(), exchange.getMessageOut().getBody().getPayload());

                    OperationMetrics metrics = ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().get(op);
                    this.log.finest("Business monitoring : metrics "+metrics);
                    if(metrics == null){
                        this.log.warning("Business monitoring : new metrics for "+ op);
                        metrics = createQosMetrics(op.getLocalPart(), itf.getQName());//SOAUtil.getInstance().getXmlObjectFactory().create(OperationMetrics.class);
                    }
                    metrics.clearAnyXmlObjects();
                    metrics.addAnyXmlObject(exchange.getMessageOut().getBody());

                    try {
                        Document doc = documentBuilder.newDocument();
                        SOAUtil.getInstance().getWriter(EasierBSMFramework.getInstance()).get().writeDocument(metrics, doc);
                        this.log.finest("Business monitoring : Metrics as dom : \n"+XMLPrettyPrinter.prettyPrint(doc));
                        
                    } catch (XmlObjectWriteException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                        this.log.severe("Business Monitoring : "+e.getLocalizedMessage());
                    }

                    ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().put(op, metrics);
                    //                    DocumentBuilders.releaseDocumentBuilder(documentBuilder);

                }else {
                    this.log.warning("Business monitoring : soap fault\n"+XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
                    
                    /* If the web service throws an exception, set current info with fault */

                    if(exchange.getMessageError() == null){
                        /* Apparently timeout occured TODO DO NOTHING ?, FILL INFO WITH NON_RESPONDING_SERVICE info ?*/
                        /* TODO Standardization ?*/
                        MessageUtil.getInstance().createErrorMessageStructure(exchange);
                        MessageError value = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MessageError.class);
                        Body body = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Body.class);


                        Document doc = documentBuilder.newDocument();
                        Element root = doc.createElement("WSError");
                        root.setNodeValue("NON_RESPONDING_SERVICE");
                        doc.appendChild(root);
                        body.setPayload(doc);
                        value.setBody(body);
                        exchange.setMessageError(value);
                    }

                    this.monitoredOperations.put(op.getLocalPart(), exchange.getMessageError().printMessage());
                    OperationMetrics metrics = ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().get(op);
                    if(metrics == null){
                        metrics = createQosMetrics(op.getLocalPart(), itf.getQName());
                    }

                    metrics.clearAnyXmlObjects();
                    metrics.addAnyXmlObject(exchange.getMessageError());

                    try {
                        Document doc = documentBuilder.newDocument();
                        SOAUtil.getInstance().getWriter(EasierBSMFramework.getInstance()).get().writeDocument(metrics, doc);
                        this.log.finest("Business monitoring : Metrics FAULT as dom : \n"+XMLPrettyPrinter.prettyPrint(doc));
                    } catch (XmlObjectWriteException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                        this.log.severe("Business Monitoring : "+e.getLocalizedMessage());
                    }

                    ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().put(op, metrics);
                }
            }

        } catch (TransportException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (ExchangeException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } 
    }




    public void stopExecution(){
        this.finished = true;

    }

    public static long getSleep() {
        return sleep;
    }

    public static void setSleep(long sleep) {
        BusinessMonitoringThread.sleep = sleep;
    }

    //TODO Picked from RawReportInterception class ... to be unified
    private OperationMetrics createQosMetrics(final String operationName,
            final QName itfName)  {
        final OperationMetrics metrics = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(OperationMetrics.class);

        // serviceTime
        final ServiceTime serviceTime = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ServiceTime.class);

        // maxResponseTime
        final MaxResponseTime maxResponseTime = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseTime.class);

        // lastResponseTime
        final LastResponseTime lastResponseTime = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseTime.class);

        // numberOfSuccessfulRequests
        final NumberOfSuccessfulRequests numberOfSuccessfulRequests = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfSuccessfulRequests.class);

        // numberOfRequests
        final NumberOfRequests numberOfRequests = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfRequests.class);

        // numberOfFailedRequests
        final NumberOfFailedRequests numberOfFailedRequests = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfFailedRequests.class);

        // maxRequestSize
        final MaxRequestSize maxRequestSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxRequestSize.class);

        // maxResponseSize
        final MaxResponseSize maxResponseSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseSize.class);

        // lastRequestSize
        final LastRequestSize lastRequestSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastRequestSize.class);

        // lastResponseSize
        final LastResponseSize lastResponseSize = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseSize.class);

        // set values in metrics
        metrics.setOperationName(operationName);
        metrics.setPortType(itfName);
        metrics.setServiceTime(serviceTime);
        metrics.setMaxResponseTime(maxResponseTime);
        metrics.setLastResponseTime(lastResponseTime);
        metrics.setNumberOfSuccessfulRequests(numberOfSuccessfulRequests);
        metrics.setNumberOfRequests(numberOfRequests);
        metrics.setNumberOfFailedRequests(numberOfFailedRequests);
        metrics.setMaxRequestSize(maxRequestSize);
        metrics.setMaxResponseSize(maxResponseSize);
        metrics.setLastRequestSize(lastRequestSize);
        metrics.setLastResponseSize(lastResponseSize);
        return metrics;
    }






}
