/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.usdl;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.services.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.easiergov.usdl.USDLManagerImpl;
import com.petalslink.resources_api._1_0.ResourcesManager;
import com.petalslink.usdl_api._1.GetService;
import com.petalslink.usdl_api._1.GetServiceResponse;
import com.petalslink.usdl_api._1.GetTechnicalInterface;
import com.petalslink.usdl_api._1.GetTechnicalInterfaceResponse;
import com.petalslink.usdl_api._1.PublishService;
import com.petalslink.usdl_api._1.PublishServiceResponse;
import com.petalslink.usdl_api._1.RemoveService;
import com.petalslink.usdl_api._1.RemoveServiceResponse;
import com.petalslink.usdl_api._1.RemoveTechnicalInterface;
import com.petalslink.usdl_api._1.RemoveTechnicalInterfaceResponse;
import com.petalslink.usdl_api._1.ResourceIdentifier;
import com.petalslink.usdl_api._1.UpdateService;
import com.petalslink.usdl_api._1.UpdateServiceResponse;
import com.petalslink.usdl_api._1.UpdateTechnicalInterface;
import com.petalslink.usdl_api._1.UpdateTechnicalInterfaceResponse;
import com.petalslink.usdl_api._1_0.GetServiceFault;
import com.petalslink.usdl_api._1_0.GetTechnicalInterfaceFault;
import com.petalslink.usdl_api._1_0.PublishServiceFault;
import com.petalslink.usdl_api._1_0.RemoveServiceFault;
import com.petalslink.usdl_api._1_0.RemoveTechnicalInterfaceFault;
import com.petalslink.usdl_api._1_0.USDLManager;
import com.petalslink.usdl_api._1_0.UpdateServiceFault;
import com.petalslink.usdl_api._1_0.UpdateTechnicalInterfaceFault;
import com.petalslink.usdl_model._1.ServiceType;
import com.petalslink.usdl_model._1.TechnicalInterfaceType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class USDLImplTest {
    private USDLManager servicesAPI = null;
    private ResourcesManagerImpl resourcesManager = null;

    @Before
    public void setup() throws GovException {
        this.resourcesManager = new ResourcesManagerImpl((Configuration)new ConfigurationImpl());
        this.servicesAPI = new USDLManagerImpl((ResourcesManager)this.resourcesManager);
    }

    @After
    public void tearDown() {
        this.resourcesManager.clear();
    }

    public List<ResourceIdentifier> publishService(URL url) throws PublishServiceFault {
        PublishService request = new PublishService();
        request.setWsdlUrl(url.toString());
        PublishServiceResponse response = this.servicesAPI.publishService(request);
        return response.getResourceIdentifier();
    }

    public ServiceType getService(QName id) throws GetServiceFault {
        GetService request = new GetService();
        request.setIdService(id);
        GetServiceResponse response = this.servicesAPI.getService(request);
        Assert.assertNotNull((Object)response);
        return response.getService();
    }

    @Test
    public void testPublishService() throws PublishServiceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        List<ResourceIdentifier> id = this.publishService(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
        System.out.println("id = " + id);
        Assert.assertNotNull(id);
    }

    @Test
    public void testGetServiceOnExistingService() throws PublishServiceFault, GetServiceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        List<ResourceIdentifier> id = this.publishService(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
        ServiceType service = this.getService(id.get(0).getId());
        Assert.assertNotNull((Object)service);
        System.out.println("service.getName() = " + service.getName());
        Assert.assertEquals((Object)id.get(0).getId(), (Object)QName.valueOf(service.getId()));
        Assert.assertEquals((Object)"firemen", (Object)service.getName());
    }

    @Test
    public void testGetServiceOnNonExistingService() throws GetServiceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        QName id = new QName("http://wrong.services/", "unknownService");
        try {
            ServiceType service = this.getService(id);
            Assert.fail();
        }
        catch (GetServiceFault e) {
            Assert.assertEquals((Object)"Impossible to find service corresponding to this id: {http://wrong.services/}unknownService", (Object)e.getFaultInfo().getFault().getMessage());
        }
    }

    @Test
    public void testRemoveService() throws PublishServiceFault, RemoveServiceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        List<ResourceIdentifier> id = this.publishService(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
        RemoveService request = new RemoveService();
        request.setIdService(id.get(0).getId());
        RemoveServiceResponse response = this.servicesAPI.removeService(request);
        System.out.println("response1: " + response);
        Assert.assertNotNull((Object)response);
        ServiceType service = response.getService();
        System.out.println("service.getName() = " + service.getName());
        Assert.assertEquals((Object)id.get(0).getId(), (Object)QName.valueOf(service.getId()));
        Assert.assertEquals((Object)"firemen", (Object)service.getName());
    }

    @Test
    public void testUpdateService() throws PublishServiceFault, UpdateServiceFault, GetServiceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        List<ResourceIdentifier> id = this.publishService(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
        ServiceType service = this.getService(id.get(0).getId());
        System.out.println("service.getName() = " + service.getName());
        service.setName("doctors");
        System.out.println("service.getName() = " + service.getName());
        UpdateService request = new UpdateService();
        request.setService(service);
        UpdateServiceResponse response = this.servicesAPI.updateService(request);
        service = this.getService(response.getIdService());
        System.out.println("service.getName() = " + service.getName());
        Assert.assertEquals((Object)response.getIdService(), (Object)QName.valueOf(service.getId()));
        Assert.assertEquals((Object)"doctors", (Object)service.getName());
    }

    public TechnicalInterfaceType getTechnicalInterface(QName idTit) throws GetTechnicalInterfaceFault {
        GetTechnicalInterface request = new GetTechnicalInterface();
        request.setIdTechnicalInterface(idTit);
        GetTechnicalInterfaceResponse response = this.servicesAPI.getTechnicalInterface(request);
        Assert.assertNotNull((Object)response);
        return response.getTechnicalInterface();
    }

    @Test
    public void testGetTechnicalInterface() throws PublishServiceFault, GetTechnicalInterfaceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        List<ResourceIdentifier> id = this.publishService(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
        QName expectedIdTit = new QName("http://www.example.org/firemen/", "firemen");
        TechnicalInterfaceType tit = this.getTechnicalInterface(expectedIdTit);
        Assert.assertNotNull((Object)tit);
        Assert.assertEquals((Object)expectedIdTit.toString(), (Object)tit.getId());
    }

    @Test
    public void testUpdateTechnicalInterface() throws PublishServiceFault, GetTechnicalInterfaceFault, UpdateTechnicalInterfaceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        List<ResourceIdentifier> id = this.publishService(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
        QName expectedIdTit = new QName("http://www.example.org/firemen/", "firemen");
        TechnicalInterfaceType tit = this.getTechnicalInterface(expectedIdTit);
        System.out.println("The current name of the Technical Interface is: " + tit.getName());
        tit.setName("doctorsInterface");
        System.out.println("The name of the Technical Interface is updated to: " + tit.getName());
        UpdateTechnicalInterface request = new UpdateTechnicalInterface();
        request.setTechnicalInterface(tit);
        UpdateTechnicalInterfaceResponse response = this.servicesAPI.updateTechnicalInterface(request);
        tit = this.getTechnicalInterface(response.getIdTechnicalInterface());
        System.out.println("TechnicalInterface.getName() = " + tit.getName());
        Assert.assertEquals((Object)response.getIdTechnicalInterface(), (Object)QName.valueOf(tit.getId()));
        Assert.assertEquals((Object)"doctorsInterface", (Object)tit.getName());
    }

    @Test
    public void testRemoveTechnicalInterface() throws PublishServiceFault, RemoveTechnicalInterfaceFault, GetTechnicalInterfaceFault, GovException {
        this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
        List<ResourceIdentifier> id = this.publishService(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
        QName expectedIdTit = new QName("http://www.example.org/firemen/", "firemen");
        RemoveTechnicalInterface request = new RemoveTechnicalInterface();
        request.setIdTechnicalInterface(expectedIdTit);
        RemoveTechnicalInterfaceResponse response = this.servicesAPI.removeTechnicalInterface(request);
        Assert.assertNotNull((Object)response);
        GetTechnicalInterface requestOnItf = new GetTechnicalInterface();
        requestOnItf.setIdTechnicalInterface(expectedIdTit);
        GetTechnicalInterfaceResponse responseOnItf = this.servicesAPI.getTechnicalInterface(requestOnItf);
        Assert.assertNull((Object)responseOnItf.getTechnicalInterface());
        TechnicalInterfaceType tit = response.getTechnicalInterface();
        System.out.println("TechnicalInterface.getName() = " + tit.getName());
        Assert.assertEquals((Object)id.get(0).getId(), (Object)QName.valueOf(tit.getId()));
        Assert.assertEquals((Object)"firemen", (Object)tit.getName());
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

