/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.events;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ObjectFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.WstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicSetTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.petalslink.easiergov.events.EventProducerResourceType;
import com.petalslink.easiergov.events.TopicNameSpaceResourceType;
import com.petalslink.easiergov.resources.ResourceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.ResourceType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.w3c.dom.Document;

public class EventsProducerAndTopicNameSpaceAnalyzerServiceImpl
extends AbstractResourceAnalyzerService
implements ResourceAnalyzerService {
    private static Logger LOG = Logger.getLogger(EventsProducerAndTopicNameSpaceAnalyzerServiceImpl.class.getName());
    private WstopFactory factory = RefinedWstopFactory.getInstance((WstopModelFactory)new WstopModelFactoryImpl());

    public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN EVENT");
        try {
            TopicNamespaceType topicNamespace = this.factory.getWstopReader().readTopicNamespaceType(doc);
            ResourceImpl rTopicNS = new ResourceImpl(new QName(topicNamespace.getNamespace().toString(), topicNamespace.getName()), (ResourceType)TopicNameSpaceResourceType.getInstance(), (Object)topicNamespace);
            resources.add((Resource)rTopicNS);
        }
        catch (WstopException e) {
            LOG.finest("Resource cannot be analysed by " + ((Object)((Object)this)).getClass().getSimpleName() + ": \n" + XMLPrettyPrinter.prettyPrint((Document)doc) + "\nMetadata = " + metadata);
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN EVENT: Resource cannot be analysed by " + ((Object)((Object)this)).getClass().getSimpleName() + ": \n" + XMLPrettyPrinter.prettyPrint((Document)doc) + "\nMetadata = " + metadata);
        }
        return resources;
    }

    public synchronized List<Resource> postAnalyse(Resource r) throws GovException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT");
        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT r = " + r.getId());
        try {
            if (r.getResourceType().getTypeName().equals("endpoint")) {
                Interface itf;
                Definitions def = (Definitions)r.getContent();
                Description desc = (Description)Factory.getInstance().wrap((XmlObject)def);
                Endpoint ep = desc.findEndpoint(r.getId().getLocalPart());
                Binding b = ep.getBinding();
                if (b != null && (itf = ep.getBinding().getInterface()).getQName().getNamespaceURI().equals("http://www.petalslink.com/wsn/service/WsnProducer") && itf.getQName().getLocalPart().equals("NotificationProducer")) {
                    GetResourcePropertyResponse getResourcePropertyResponse = this.getResourcePropertyForTopicSet(ep);
                    System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT = " + getResourcePropertyResponse);
                    TopicSetType topicSet = null;
                    if (getResourcePropertyResponse != null) {
                        topicSet = this.getSupportedTopics(getResourcePropertyResponse);
                    }
                    System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT topicSet = " + topicSet);
                    if (topicSet != null) {
                        ResourceImpl revent = new ResourceImpl(new QName(ep.getService().getQName().getNamespaceURI(), ep.getName()), (ResourceType)EventProducerResourceType.getInstance(), (Object)topicSet);
                        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT revent = " + revent);
                        resources.add((Resource)revent);
                        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT event producer found");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new GovException((Throwable)e);
        }
        return resources;
    }

    public GetResourcePropertyResponse getResourcePropertyForTopicSet(Endpoint ep) throws Exception {
        String requestS = "<rp:GetResourceProperty xmlns:rp=\"http://docs.oasis-open.org/wsrf/rp-2\" xmlns:t=\"http://docs.oasis-open.org/wsn/t-1\">t:TopicSet</rp:GetResourceProperty>\r\n";
        ByteArrayInputStream is = new ByteArrayInputStream(requestS.getBytes());
        Document request = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
        ((InputStream)is).close();
        GetResourcePropertyResponse getResourcePropertyResponse = null;
        SOAPSender sender = new SOAPSender();
        Document soapResponse = sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)request), ep.getAddress(), "http://www.petalslink.com/wsn/service/WsnProducer/GetResourceProperty");
        Document response = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        response.appendChild(response.adoptNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody((Document)soapResponse))).cloneNode(true));
        getResourcePropertyResponse = (GetResourcePropertyResponse)SOAJAXBContext.getInstance().marshallAnyType(response, GetResourcePropertyResponse.class);
        return getResourcePropertyResponse;
    }

    public TopicSetType getSupportedTopics(GetResourcePropertyResponse getResourcePropertyResponse) {
        TopicSetTypeImpl topicSet = null;
        for (Object obj : getResourcePropertyResponse.getAny()) {
            JAXBElement jaxbElmt;
            if (!(obj instanceof JAXBElement) || !((jaxbElmt = (JAXBElement)obj).getValue() instanceof com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicSetType)) continue;
            com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicSetType topicSetJaxb = (com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicSetType)jaxbElmt.getValue();
            topicSet = new TopicSetTypeImpl(topicSetJaxb);
            break;
        }
        return topicSet;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

