
/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

package com.petalslink.easiergov.events;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType.Topic;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicNamespaceTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicSetTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicTypeImpl;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.services.EndpointResourceType;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.events_api._1.Fault;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;
import com.petalslink.events_api._1_0.EventsManager;
import com.petalslink.events_api._1_0.FindEventProducersByElementsFault;
import com.petalslink.events_api._1_0.FindEventProducersByTopicsFault;
import com.petalslink.events_api._1_0.FindTopicsByElementFault;
import com.petalslink.events_api._1_0.FindTopicsFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromURLFault;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.ResourcesManager;

import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicNamespaceType;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicType;
import easybox.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import easybox.org.w3._2005._08.addressing.EJaxbAttributedURIType;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import easybox.org.w3._2005._08.addressing.EJaxbMetadataType;

/**
 * This class was generated by Apache CXF 2.4.0-easy
 * 2011-08-03T12:57:17.744+02:00
 * Generated source version: 2.4.0-easy
 * 
 */

@javax.jws.WebService(
		serviceName = "EventsManagerService",
		portName = "EventsManagerPort",
		targetNamespace = "http://www.petalslink.com/events-api/1.0",
		wsdlLocation = "events-ws.wsdl",
		endpointInterface = "com.petalslink.events_api._1_0.EventsManager")

public class EventsManagerImpl implements EventsManager {

	private static Logger LOG = Logger.getLogger(EventsManagerImpl.class.getName());


	private easybox.org.w3._2005._08.addressing.ObjectFactory wsaddrFactory = new easybox.org.w3._2005._08.addressing.ObjectFactory();



	private ObjectFactory topicFactory = new ObjectFactory();

	private ResourcesManager resourceManager;
	
	public EventsManagerImpl(ResourcesManager resourceManager) throws GovException {
		DescriptionImpl.setXmlContext(SOAUtil.getInstance().getXmlContext(EasierGOVFramework.getInstance()));
		this.resourceManager = resourceManager;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.events_api._1_0.EventsManager#findTopicsByElement(javax.xml.namespace.QName  element )*
	 */
	public java.util.List<javax.xml.namespace.QName> findTopicsByElement(javax.xml.namespace.QName element) throws FindTopicsByElementFault    { 
		LOG.info("Executing operation findTopicsByElement");
		LOG.info(element.toString());
		try {
			java.util.List<javax.xml.namespace.QName> _return = new ArrayList<QName>();
			List<Resource> topicNSs = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType(TopicNameSpaceResourceType.getInstance());

			for(Resource rsc: topicNSs) {
				TopicNamespaceType topicNS = (TopicNamespaceType) rsc.getContent();
				if(topicNS != null) {
					for(Topic topic: topicNS.getTopics()) {
						for(QName elmtName: topic.getMessageTypes()) {
							if(element.equals(elmtName)) {
								_return.add(new QName(topicNS.getNamespace().toString(), topic.getName()));
							}
						}
					}
				}
			}
			return _return;
		} catch (java.lang.Exception ex) {
			ex.printStackTrace();
			throw new RuntimeException(ex);
		}
		//throw new FindTopicsByElementFault("findTopicsByElementFault...");
	}

	/* (non-Javadoc)
	 * @see com.petalslink.events_api._1_0.EventsManager#findEventProducersByTopics(com.petalslink.events_api._1.FindEventProducersByTopicsRequest  body )*
	 */
	public com.petalslink.events_api._1.FindEventProducersByTopicsResponse findEventProducersByTopics(com.petalslink.events_api._1.FindEventProducersByTopicsRequest body) throws FindEventProducersByTopicsFault    { 
		LOG.info("Executing operation findEventProducersByTopics");
		LOG.info(body.toString());
		try {
			com.petalslink.events_api._1.FindEventProducersByTopicsResponse _return = new com.petalslink.events_api._1.FindEventProducersByTopicsResponse();
			List<QName> topicsToFind = body.getTopic();
			LOG.info("topicsToFind = " + topicsToFind);
			List<Resource> eventProducers = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType(EventProducerResourceType.getInstance());
			
			String logEvents = "";
			for(Resource r: eventProducers) {
				logEvents = logEvents + r.getId() + ", ";
			}
			LOG.info("eventProducers = " + logEvents);

			if(topicsToFind.size() > 0) {
				for(Resource rsc: eventProducers) {
					TopicSetType topicSet = (TopicSetType) rsc.getContent();
					System.out.println("topicSet = " + topicSet);
					if(topicSet != null) {
						for(Element elmt: topicSet.getTopicsTrees()) {
							QName currentTopic = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
							System.out.println("currentTopic = " + currentTopic);
							for(QName topicToFind: topicsToFind) {
								System.out.println("topicToFind = " + topicToFind);
								if(currentTopic.getLocalPart().equals(topicToFind.getLocalPart()) && currentTopic.getNamespaceURI().equals(topicToFind.getNamespaceURI())) {
									System.out.println("eventProducers added");
									_return.getEndpointReference().add(this.convertResourceEventProducerToEPR(rsc, topicSet));
								}
							}
						}
					}
				}
			} else {
				for(Resource rsc: eventProducers) {
					// get all producers
					TopicSetType topicSet = (TopicSetType) rsc.getContent();
					_return.getEndpointReference().add(this.convertResourceEventProducerToEPR(rsc, topicSet));
				}
			}
			LOG.info("number of event producers returned = " + _return.getEndpointReference().size());
			return _return;
		} catch (GovException ex) {
			throw new FindEventProducersByTopicsFault(ex.getMessage(), ex);
		}
	}

	public EJaxbEndpointReferenceType convertResourceEventProducerToEPR(Resource rsc, TopicSetType topicSet) throws GovException {
		JAXBElement<EJaxbEndpointReferenceType> epr = wsaddrFactory.createEndpointReference(new EJaxbEndpointReferenceType());
		Resource epRsc = ((ResourcesManagerImpl)this.resourceManager).get(rsc.getId(), EndpointResourceType.getInstance());
		if(epRsc == null) {
			throw new GovException("Impossible to find endpoint corresponding to: " + rsc.getId() + ":\n" + this.resourceManager);
		}
		Definitions def = (Definitions) epRsc.getContent();

		Port ep = findEndpoint(def, epRsc.getId().getLocalPart());
		epr.getValue().setAddress(new EJaxbAttributedURIType());
		epr.getValue().getAddress().setValue(SoapBindingHelper.getAddress(ep).getLocation());
		epr.getValue().setMetadata(new EJaxbMetadataType());

		if(topicSet != null) {
			epr.getValue().getMetadata().getAny().add(topicFactory.createTopicSet(TopicSetTypeImpl.toJaxbModel(topicSet)));
		}

		String name = "<name>" + epRsc.getId() + "</name>";
		try {
			InputStream is = new ByteArrayInputStream(name.getBytes());
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
			epr.getValue().getMetadata().getAny().add(doc.getDocumentElement());
			is.close();
		} catch (SAXException e) {
			throw new GovException(e);
		} catch (IOException e) {
			throw new GovException(e);
		} catch (ParserConfigurationException e) {
			throw new GovException(e);
		}
		return epr.getValue();
	}

	public static Port findEndpoint(Definitions def, String name) {
		for(Service s: def.getServices()) {
			for(Port p: s.getPorts()) {
				if(p.getName().equals(name)) {
					return p;
				}
			}
		}
		for(Import impt: def.getImports()) {
			Port res = findEndpoint((Definitions) impt.getXmlObjectChildren()[0], name);
			if(res != null) {
				return res;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.events_api._1_0.EventsManager#findEventProducersByElements(com.petalslink.events_api._1.FindEventProducersByElements  parameters )*
	 */
	public com.petalslink.events_api._1.FindEventProducersByElementsResponse findEventProducersByElements(com.petalslink.events_api._1.FindEventProducersByElements parameters) throws FindEventProducersByElementsFault    { 
		LOG.info("Executing operation findEventProducersByElements");
		LOG.info(parameters.toString());
		try {
			com.petalslink.events_api._1.FindEventProducersByElementsResponse _return = new com.petalslink.events_api._1.FindEventProducersByElementsResponse();

			// get all topics from elmts
			com.petalslink.events_api._1.FindEventProducersByTopicsRequest request = new com.petalslink.events_api._1.FindEventProducersByTopicsRequest();

			for(QName elmt: parameters.getElement()) {
				request.getTopic().addAll(this.findTopicsByElement(elmt));
			}

			com.petalslink.events_api._1.FindEventProducersByTopicsResponse response = this.findEventProducersByTopics(request);
			_return.getEndpointReference().addAll(response.getEndpointReference());

			return _return;
		} catch (java.lang.Exception ex) {
			throw new FindEventProducersByElementsFault(ex.getMessage(), ex);
		}
		//throw new FindEventProducersByElementsFault("findEventProducersByElementsFault...");
	}

	@Override
	public PublishTopicNamespaceFromURLResponse publishTopicNamespaceFromURL(
			PublishTopicNamespaceFromURL parameters)
					throws PublishTopicNamespaceFromURLFault {
		PublishTopicNamespaceFromURLResponse res = new PublishTopicNamespaceFromURLResponse();
		try {
			Publish request = new Publish();
			request.setRessourceUrl(parameters.getTopicNamespaceUrl());
			PublishResponse response = this.resourceManager.publish(request);
			if(response != null) {
				for(ResourceIdentifier rid: response.getResourceIdentifier()) {
					com.petalslink.events_api._1.ResourceIdentifier rids = new com.petalslink.events_api._1.ResourceIdentifier();
					rids.setId(QName.valueOf(rid.getId()));
					rids.setResourceType(rid.getResourceType());
					res.getResourceIdentifier().add(rids);
				}
			}
		} catch (PublishFault e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.events_api._1.PublishTopicNamespaceFromURLFault f = new com.petalslink.events_api._1.PublishTopicNamespaceFromURLFault();
			f.setFault(fault);
			PublishTopicNamespaceFromURLFault publishEventFault = new PublishTopicNamespaceFromURLFault(e.getMessage(), f);
			throw publishEventFault;
		}
		return res;
	}

	@Override
	public PublishTopicNamespaceFromDOMResponse publishTopicNamespaceFromDOM(
			PublishTopicNamespaceFromDOM parameters)
					throws PublishTopicNamespaceFromDOMFault {
		PublishTopicNamespaceFromDOMResponse res = new PublishTopicNamespaceFromDOMResponse();
		try {
			EJaxbTopicNamespaceType tns = parameters.getTopicNamespace();
			Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement(topicFactory.createTopicNamespace(tns));
			PublishResponse response = ((ResourcesManagerImpl)this.resourceManager).publish(doc, null);
			if(response != null) {
				for(ResourceIdentifier rid: response.getResourceIdentifier()) {
					com.petalslink.events_api._1.ResourceIdentifier rids = new com.petalslink.events_api._1.ResourceIdentifier();
					rids.setId(QName.valueOf(rid.getId()));
					rids.setResourceType(rid.getResourceType());
					res.getResourceIdentifier().add(rids);
				}
			}
		} catch (PublishFault e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.events_api._1.PublishTopicNamespaceFromDOMFault f = new com.petalslink.events_api._1.PublishTopicNamespaceFromDOMFault();
			f.setFault(fault);
			PublishTopicNamespaceFromDOMFault publishEventFault = new PublishTopicNamespaceFromDOMFault(e.getMessage(), f);
			throw publishEventFault;
		} catch (SOAException e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.events_api._1.PublishTopicNamespaceFromDOMFault f = new com.petalslink.events_api._1.PublishTopicNamespaceFromDOMFault();
			f.setFault(fault);
			PublishTopicNamespaceFromDOMFault publishEventFault = new PublishTopicNamespaceFromDOMFault(e.getMessage(), f);
			throw publishEventFault;
		}
		return res;
	}

	@Override
	public List<EJaxbTopicType> findTopics(String request) throws FindTopicsFault {
		List<EJaxbTopicType> res = new ArrayList<EJaxbTopicType>();
		LOG.info("Executing operation findTopics");
		LOG.info(request);
		List<Resource> topicnss = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType(TopicNameSpaceResourceType.getInstance());
		if(request != null && request.trim().length() > 0) {
			List<String> functionalWords = SimilarityUtil.splitInWords(request);

			for(Resource rsc: topicnss) {
				TopicNamespaceTypeImpl tns = (TopicNamespaceTypeImpl) rsc.getContent();
				for(Topic topic: tns.getTopics()) {
					if(((ResourcesManagerImpl)this.resourceManager).detectSyntaxSimilarity(request, topic.getName())) {
						EJaxbTopicType tt = TopicTypeImpl.toJaxbModel(topic); 
						EJaxbTopicType t = this.topicFactory.createEJaxbTopicType();
						t.setName(new QName(tns.getNamespace().toString(), tt.getName()).toString());
						t.setMessagePattern(tt.getMessagePattern());
						res.add(t);
					}
				}
			}
		} else {
			for(Resource rsc: topicnss) {
				TopicNamespaceTypeImpl tns = (TopicNamespaceTypeImpl) rsc.getContent();
				for(Topic topic: tns.getTopics()) {
					EJaxbTopicType tt = TopicTypeImpl.toJaxbModel(topic); 
					EJaxbTopicType t = this.topicFactory.createEJaxbTopicType();
					t.setName(new QName(tns.getNamespace().toString(), tt.getName()).toString());
					t.setMessagePattern(tt.getMessagePattern());
					t.getMessageTypes().addAll(tt.getMessageTypes());
					res.add(t);
				}
			}
		}
		return res;
	}

}
