package com.petalslink.easiergov.events;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.WstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicSetTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.resources.ResourceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;

import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicSetType;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.ObjectFactory;


public class EventsProducerAndTopicNameSpaceAnalyzerServiceImpl extends AbstractResourceAnalyzerService implements ResourceAnalyzerService {


	private static Logger LOG = Logger.getLogger(EventsProducerAndTopicNameSpaceAnalyzerServiceImpl.class.getName());



	private WstopFactory factory = RefinedWstopFactory.getInstance(new WstopModelFactoryImpl());

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	public EventsProducerAndTopicNameSpaceAnalyzerServiceImpl() {
		super();
	}

	@Override
	public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
		List<Resource> resources = new ArrayList<Resource>();
		System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN EVENT");
		// detect topicNamespace
		try {

			TopicNamespaceType topicNamespace = factory.getWstopReader().readTopicNamespaceType(doc);
			Resource rTopicNS = new ResourceImpl(new QName(topicNamespace.getNamespace().toString(), topicNamespace.getName()), TopicNameSpaceResourceType.getInstance(), topicNamespace);
			resources.add(rTopicNS);
		} catch (WstopException e) {
			// do nothing
			LOG.finest("Resource cannot be analysed by " + this.getClass().getSimpleName() +  ": \n" + XMLPrettyPrinter.prettyPrint(doc) + "\nMetadata = " + metadata);
			System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN EVENT: " + "Resource cannot be analysed by " + this.getClass().getSimpleName() +  ": \n" + XMLPrettyPrinter.prettyPrint(doc) + "\nMetadata = " + metadata);
		}

		return resources;
	}

	@Override
	public synchronized List<Resource> postAnalyse(Resource r) throws GovException {
		// find event producer
		List<Resource> resources = new ArrayList<Resource>();
		System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT");
		System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT r = " + r.getId());
		try {
			if(r.getResourceType().getTypeName().equals("endpoint")) {
				Definitions def = (Definitions) r.getContent();
				Description desc = (Description) Factory.getInstance().wrap(def);

				Endpoint ep = desc.findEndpoint(r.getId().getLocalPart());
				org.petalslink.abslayer.service.api.Binding b = ep.getBinding();

				if(b != null) {
					Interface itf = ep.getBinding().getInterface();
					if(itf.getQName().getNamespaceURI().equals("http://www.petalslink.com/wsn/service/WsnProducer")
							&& itf.getQName().getLocalPart().equals("NotificationProducer")) {
						EJaxbGetResourcePropertyResponse getResourcePropertyResponse;
						getResourcePropertyResponse = getResourcePropertyForTopicSet(ep);
						System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT = " + getResourcePropertyResponse);
						com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType topicSet = null;
						if(getResourcePropertyResponse != null) {
							topicSet = getSupportedTopics(getResourcePropertyResponse);
						}
						System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT topicSet = " + topicSet);

						if(topicSet != null) {
							Resource revent = new ResourceImpl(new QName(ep.getService().getQName().getNamespaceURI(), ep.getName()), EventProducerResourceType.getInstance(), topicSet);
							System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT revent = " + revent);

							resources.add(revent);
							System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ POST ANALYSE IN EVENT event producer found");
						}
					}
				}
			}
		} catch (Exception e) {
			throw new GovException(e);
		}
		return resources;
	}


	public EJaxbGetResourcePropertyResponse getResourcePropertyForTopicSet(Endpoint ep) throws Exception {
		String requestS = "<rp:GetResourceProperty xmlns:rp=\"http://docs.oasis-open.org/wsrf/rp-2\" xmlns:t=\"http://docs.oasis-open.org/wsn/t-1\">t:TopicSet</rp:GetResourceProperty>\r\n";
		InputStream is = new ByteArrayInputStream(requestS.getBytes());
		Document request = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
		is.close();
		EJaxbGetResourcePropertyResponse getResourcePropertyResponse = null;

		SOAPSender sender = new SOAPSender();
		Document soapResponse = sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest(request), ep.getAddress(), "http://www.petalslink.com/wsn/service/WsnProducer/GetResourceProperty");

		System.out.println("soapResponse: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
		Document response = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

		response.appendChild(response.adoptNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse))).cloneNode(true));
		getResourcePropertyResponse = SOAJAXBContext.getInstance().marshallAnyType(response, EJaxbGetResourcePropertyResponse.class);

		return getResourcePropertyResponse;
	}

	public com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType getSupportedTopics(EJaxbGetResourcePropertyResponse getResourcePropertyResponse) {
		com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType topicSet = null;
		for(Object obj: getResourcePropertyResponse.getAny()) {
			if(obj instanceof JAXBElement) {
				JAXBElement<?> jaxbElmt = (JAXBElement<?>) obj;
				if(jaxbElmt.getValue() instanceof EJaxbTopicSetType) {
					EJaxbTopicSetType topicSetJaxb = (EJaxbTopicSetType)jaxbElmt.getValue();
					topicSet = new TopicSetTypeImpl(topicSetJaxb);
					break;
				}
			}
		}
		return topicSet;
	}

}
