/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.events;

import com.ebmwebsourcing.easiergov.ServerImplementation;
import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicNamespaceTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicSetTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicTypeImpl;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.events.EventProducerResourceType;
import com.petalslink.easiergov.events.TopicNameSpaceResourceType;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.easiergov.services.EndpointResourceType;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import com.petalslink.events_api._1.Fault;
import com.petalslink.events_api._1.FindEventProducersByElements;
import com.petalslink.events_api._1.FindEventProducersByElementsResponse;
import com.petalslink.events_api._1.FindEventProducersByTopicsRequest;
import com.petalslink.events_api._1.FindEventProducersByTopicsResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMFault;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;
import com.petalslink.events_api._1_0.EventsManager;
import com.petalslink.events_api._1_0.FindEventProducersByElementsFault;
import com.petalslink.events_api._1_0.FindEventProducersByTopicsFault;
import com.petalslink.events_api._1_0.FindTopicsByElementFault;
import com.petalslink.events_api._1_0.FindTopicsFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromURLFault;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.ResourcesManager;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicNamespaceType;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicType;
import easybox.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import easybox.org.w3._2005._08.addressing.EJaxbAttributedURIType;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import easybox.org.w3._2005._08.addressing.EJaxbMetadataType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@WebService(serviceName="EventsManagerService", portName="EventsManagerPort", targetNamespace="http://www.petalslink.com/events-api/1.0", wsdlLocation="events-ws.wsdl", endpointInterface="com.petalslink.events_api._1_0.EventsManager")
public class EventsManagerImpl
implements EventsManager,
ServerImplementation {
    private static Logger LOG = Logger.getLogger(EventsManagerImpl.class.getName());
    private easybox.org.w3._2005._08.addressing.ObjectFactory wsaddrFactory = new easybox.org.w3._2005._08.addressing.ObjectFactory();
    private ObjectFactory topicFactory = new ObjectFactory();
    private ResourcesManager resourceManager;

    public EventsManagerImpl(ResourcesManager resourceManager) throws GovException {
        DescriptionImpl.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasierGOVFramework.getInstance()));
        this.resourceManager = resourceManager;
    }

    public List<QName> findTopicsByElement(QName element) throws FindTopicsByElementFault {
        LOG.info("Executing operation findTopicsByElement");
        LOG.info(element.toString());
        try {
            ArrayList<QName> _return = new ArrayList<QName>();
            List topicNSs = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType((ResourceType)TopicNameSpaceResourceType.getInstance());
            for (Resource rsc : topicNSs) {
                TopicNamespaceType topicNS = (TopicNamespaceType)rsc.getContent();
                if (topicNS == null) continue;
                for (TopicNamespaceType.Topic topic : topicNS.getTopics()) {
                    for (QName elmtName : topic.getMessageTypes()) {
                        if (!element.equals(elmtName)) continue;
                        _return.add(new QName(topicNS.getNamespace().toString(), topic.getName()));
                    }
                }
            }
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public FindEventProducersByTopicsResponse findEventProducersByTopics(FindEventProducersByTopicsRequest body) throws FindEventProducersByTopicsFault {
        LOG.info("Executing operation findEventProducersByTopics");
        LOG.info(body.toString());
        try {
            FindEventProducersByTopicsResponse _return = new FindEventProducersByTopicsResponse();
            List topicsToFind = body.getTopic();
            LOG.info("topicsToFind = " + topicsToFind);
            List eventProducers = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType((ResourceType)EventProducerResourceType.getInstance());
            String logEvents = "";
            for (Resource r : eventProducers) {
                logEvents = logEvents + r.getId() + ", ";
            }
            LOG.info("eventProducers = " + logEvents);
            if (topicsToFind.size() > 0) {
                for (Resource rsc : eventProducers) {
                    TopicSetType topicSet = (TopicSetType)rsc.getContent();
                    LOG.finest("topicSet = " + topicSet);
                    if (topicSet == null) continue;
                    for (Element elmt : topicSet.getTopicsTrees()) {
                        QName currentTopic = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
                        LOG.finest("currentTopic = " + currentTopic);
                        for (QName topicToFind : topicsToFind) {
                            LOG.finest("topicToFind = " + topicToFind);
                            if (!currentTopic.getLocalPart().equals(topicToFind.getLocalPart()) || !currentTopic.getNamespaceURI().equals(topicToFind.getNamespaceURI())) continue;
                            LOG.finest("eventProducers added");
                            _return.getEndpointReference().add(this.convertResourceEventProducerToEPR(rsc, topicSet));
                        }
                    }
                }
            } else {
                for (Resource rsc : eventProducers) {
                    TopicSetType topicSet = (TopicSetType)rsc.getContent();
                    _return.getEndpointReference().add(this.convertResourceEventProducerToEPR(rsc, topicSet));
                }
            }
            LOG.info("number of event producers returned = " + _return.getEndpointReference().size() + " for topics: " + topicsToFind);
            return _return;
        }
        catch (GovException ex) {
            throw new FindEventProducersByTopicsFault(ex.getMessage(), (Throwable)ex);
        }
    }

    public EJaxbEndpointReferenceType convertResourceEventProducerToEPR(Resource rsc, TopicSetType topicSet) throws GovException {
        JAXBElement epr = this.wsaddrFactory.createEndpointReference(new EJaxbEndpointReferenceType());
        Resource epRsc = ((ResourcesManagerImpl)this.resourceManager).get(rsc.getId(), (ResourceType)EndpointResourceType.getInstance());
        if (epRsc == null) {
            throw new GovException("Impossible to find endpoint corresponding to: " + rsc.getId() + ":\n" + this.resourceManager);
        }
        Definitions def = (Definitions)epRsc.getContent();
        Port ep = EventsManagerImpl.findEndpoint(def, epRsc.getId().getLocalPart());
        ((EJaxbEndpointReferenceType)epr.getValue()).setAddress(new EJaxbAttributedURIType());
        ((EJaxbEndpointReferenceType)epr.getValue()).getAddress().setValue(SoapBindingHelper.getAddress((Port)ep).getLocation());
        ((EJaxbEndpointReferenceType)epr.getValue()).setMetadata(new EJaxbMetadataType());
        if (topicSet != null) {
            ((EJaxbEndpointReferenceType)epr.getValue()).getMetadata().getAny().add(this.topicFactory.createTopicSet(TopicSetTypeImpl.toJaxbModel((TopicSetType)topicSet)));
        }
        String name = "<name>" + epRsc.getId() + "</name>";
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(name.getBytes());
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
            ((EJaxbEndpointReferenceType)epr.getValue()).getMetadata().getAny().add(doc.getDocumentElement());
            ((InputStream)is).close();
        }
        catch (SAXException e) {
            throw new GovException((Throwable)e);
        }
        catch (IOException e) {
            throw new GovException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new GovException((Throwable)e);
        }
        return (EJaxbEndpointReferenceType)epr.getValue();
    }

    public static Port findEndpoint(Definitions def, String name) {
        for (Service service : def.getServices()) {
            for (Port p : service.getPorts()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
        }
        for (Service service : def.getImports()) {
            Port res = EventsManagerImpl.findEndpoint((Definitions)service.getXmlObjectChildren()[0], name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public FindEventProducersByElementsResponse findEventProducersByElements(FindEventProducersByElements parameters) throws FindEventProducersByElementsFault {
        LOG.info("Executing operation findEventProducersByElements");
        LOG.info(parameters.toString());
        try {
            FindEventProducersByElementsResponse _return = new FindEventProducersByElementsResponse();
            FindEventProducersByTopicsRequest request = new FindEventProducersByTopicsRequest();
            for (QName elmt : parameters.getElement()) {
                request.getTopic().addAll(this.findTopicsByElement(elmt));
            }
            FindEventProducersByTopicsResponse response = this.findEventProducersByTopics(request);
            _return.getEndpointReference().addAll(response.getEndpointReference());
            return _return;
        }
        catch (Exception ex) {
            throw new FindEventProducersByElementsFault(ex.getMessage(), (Throwable)ex);
        }
    }

    public PublishTopicNamespaceFromURLResponse publishTopicNamespaceFromURL(PublishTopicNamespaceFromURL parameters) throws PublishTopicNamespaceFromURLFault {
        LOG.info("publishTopicNamespaceFromURL: " + parameters.getTopicNamespaceUrl());
        PublishTopicNamespaceFromURLResponse res = new PublishTopicNamespaceFromURLResponse();
        try {
            Publish request = new Publish();
            request.setRessourceUrl(parameters.getTopicNamespaceUrl());
            PublishResponse response = this.resourceManager.publish(request);
            if (response != null) {
                for (ResourceIdentifier rid : response.getResourceIdentifier()) {
                    com.petalslink.events_api._1.ResourceIdentifier rids = new com.petalslink.events_api._1.ResourceIdentifier();
                    rids.setId(QName.valueOf(rid.getId()));
                    rids.setResourceType(rid.getResourceType());
                    res.getResourceIdentifier().add(rids);
                }
            }
        }
        catch (PublishFault e) {
            Fault fault = new Fault();
            fault.setMessage(e.getMessage());
            com.petalslink.events_api._1.PublishTopicNamespaceFromURLFault f = new com.petalslink.events_api._1.PublishTopicNamespaceFromURLFault();
            f.setFault(fault);
            PublishTopicNamespaceFromURLFault publishEventFault = new PublishTopicNamespaceFromURLFault(e.getMessage(), f);
            throw publishEventFault;
        }
        return res;
    }

    public PublishTopicNamespaceFromDOMResponse publishTopicNamespaceFromDOM(PublishTopicNamespaceFromDOM parameters) throws com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault {
        LOG.info("publishTopicNamespaceFromDOM ");
        PublishTopicNamespaceFromDOMResponse res = new PublishTopicNamespaceFromDOMResponse();
        try {
            EJaxbTopicNamespaceType tns = parameters.getTopicNamespace();
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)this.topicFactory.createTopicNamespace(tns));
            PublishResponse response = ((ResourcesManagerImpl)this.resourceManager).publish(doc, null);
            if (response != null) {
                for (ResourceIdentifier rid : response.getResourceIdentifier()) {
                    com.petalslink.events_api._1.ResourceIdentifier rids = new com.petalslink.events_api._1.ResourceIdentifier();
                    rids.setId(QName.valueOf(rid.getId()));
                    rids.setResourceType(rid.getResourceType());
                    res.getResourceIdentifier().add(rids);
                }
            }
        }
        catch (PublishFault e) {
            Fault fault = new Fault();
            fault.setMessage(e.getMessage());
            PublishTopicNamespaceFromDOMFault f = new PublishTopicNamespaceFromDOMFault();
            f.setFault(fault);
            com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault publishEventFault = new com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault(e.getMessage(), f);
            throw publishEventFault;
        }
        catch (SOAException e) {
            Fault fault = new Fault();
            fault.setMessage(e.getMessage());
            PublishTopicNamespaceFromDOMFault f = new PublishTopicNamespaceFromDOMFault();
            f.setFault(fault);
            com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault publishEventFault = new com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault(e.getMessage(), f);
            throw publishEventFault;
        }
        return res;
    }

    public List<EJaxbTopicType> findTopics(String request) throws FindTopicsFault {
        ArrayList<EJaxbTopicType> res = new ArrayList<EJaxbTopicType>();
        LOG.info("Executing operation findTopics");
        LOG.info(request);
        List topicnss = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType((ResourceType)TopicNameSpaceResourceType.getInstance());
        if (request != null && request.trim().length() > 0) {
            List functionalWords = SimilarityUtil.splitInWords((String)request);
            for (Resource rsc : topicnss) {
                TopicNamespaceTypeImpl tns = (TopicNamespaceTypeImpl)rsc.getContent();
                for (TopicNamespaceType.Topic topic : tns.getTopics()) {
                    if (!((ResourcesManagerImpl)this.resourceManager).detectSyntaxSimilarity(request, topic.getName())) continue;
                    EJaxbTopicType tt = TopicTypeImpl.toJaxbModel((TopicType)topic);
                    EJaxbTopicType t = this.topicFactory.createEJaxbTopicType();
                    t.setName(new QName(tns.getNamespace().toString(), tt.getName()).toString());
                    t.setMessagePattern(tt.getMessagePattern());
                    res.add(t);
                }
            }
        } else {
            for (Resource rsc : topicnss) {
                TopicNamespaceTypeImpl tns = (TopicNamespaceTypeImpl)rsc.getContent();
                for (TopicNamespaceType.Topic topic : tns.getTopics()) {
                    EJaxbTopicType tt = TopicTypeImpl.toJaxbModel((TopicType)topic);
                    EJaxbTopicType t = this.topicFactory.createEJaxbTopicType();
                    t.setName(new QName(tns.getNamespace().toString(), tt.getName()).toString());
                    t.setMessagePattern(tt.getMessagePattern());
                    t.getMessageTypes().addAll(tt.getMessageTypes());
                    res.add(t);
                }
            }
        }
        return res;
    }

    public void getInfo() {
        List eventProducers = ((ResourcesManagerImpl)this.resourceManager).getAllByResourceType((ResourceType)EventProducerResourceType.getInstance());
        if (eventProducers != null) {
            System.out.println("Numbers of event producers: " + eventProducers.size());
            if (eventProducers.size() > 0) {
                System.out.println("List of event producers:");
                for (Resource r : eventProducers) {
                    System.out.println("\t" + r.getId().getLocalPart());
                }
            }
        } else {
            System.out.println("Numbers of event producers: 0");
        }
    }
}

