package com.ebmwebsourcing.easiergov.client.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.petalslink.services_api._1.PublishWSDL;
import com.petalslink.services_api._1.PublishWSDLResponse;
import com.petalslink.services_api._1_0.FaultMessage;
import com.petalslink.services_api._1_0.ServicesManager;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTDefinitions;

public class ServicesManagerClientImpl implements ServicesManager {

    private String address = null;

    private ServicesManager clientProxy = null;

    public ServicesManagerClientImpl(String address) {
        this.address = address;
    }
    
    public String getAddress() {
        return address;
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized ServicesManager getClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, ServicesManager.class);
        return clientProxy;
    }

	@Override
	public EJaxbTDefinitions getService(QName idService) throws FaultMessage {
		return this.getClientProxy().getService(idService);
	}

	@Override
	public List<EJaxbTDefinitions> findServices(String query)
			throws FaultMessage {
		return this.getClientProxy().findServices(query);
	}

	@Override
	public List<EJaxbTDefinitions> findInterfaces(String query)
			throws FaultMessage {
		return this.getClientProxy().findInterfaces(query);
	}

	@Override
	public EJaxbTDefinitions getEndpoint(QName idEndpoint) throws FaultMessage {
		return this.getClientProxy().getEndpoint(idEndpoint);
	}

	@Override
	public PublishWSDLResponse publishWSDL(PublishWSDL parameters)
			throws FaultMessage {
		return this.getClientProxy().publishWSDL(parameters);
	}

	@Override
	public List<EJaxbTDefinitions> findEndpoints(String query)
			throws FaultMessage {
		return this.getClientProxy().findEndpoints(query);
	}

	@Override
	public EJaxbTDefinitions getInterface(QName idInterface)
			throws FaultMessage {
		return this.getClientProxy().getInterface(idInterface);
	}



}
