package com.ebmwebsourcing.easiergov.client.impl;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.petalslink.data_api._1.FindComplexTypes;
import com.petalslink.data_api._1.FindComplexTypesResponse;
import com.petalslink.data_api._1.FindElements;
import com.petalslink.data_api._1.FindElementsResponse;
import com.petalslink.data_api._1.FindSimpleTypes;
import com.petalslink.data_api._1.FindSimpleTypesResponse;
import com.petalslink.data_api._1.GetComplexType;
import com.petalslink.data_api._1.GetComplexTypeResponse;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import com.petalslink.data_api._1.GetSimpleType;
import com.petalslink.data_api._1.GetSimpleTypeResponse;
import com.petalslink.data_api._1.PublishSchema;
import com.petalslink.data_api._1.PublishSchemaResponse;
import com.petalslink.data_api._1_0.DataManager;

public class DataManagerClientImpl implements DataManager {

    private String address = null;

    private DataManager clientProxy = null;

    public DataManagerClientImpl(String address) {
        this.address = address;
    }
    
    public String getAddress() {
        return address;
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized DataManager getClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, DataManager.class);
        return clientProxy;
    }

	@Override
	public GetElementResponse getElement(GetElement parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		return this.clientProxy.getElement(parameters);
	}

	@Override
	public GetComplexTypeResponse getComplexType(GetComplexType parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		return this.clientProxy.getComplexType(parameters);
	}

	@Override
	public FindElementsResponse findElements(FindElements parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		return this.clientProxy.findElements(parameters);
	}

	@Override
	public FindComplexTypesResponse findComplexTypes(FindComplexTypes parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		return this.clientProxy.findComplexTypes(parameters);
	}

	@Override
	public PublishSchemaResponse publishSchema(PublishSchema parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		return this.clientProxy.publishSchema(parameters);
	}

	@Override
	public FindSimpleTypesResponse findSimpleTypes(FindSimpleTypes parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		return this.clientProxy.findSimpleTypes(parameters);
	}

	@Override
	public GetSimpleTypeResponse getSimpleType(GetSimpleType parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		return this.clientProxy.getSimpleType(parameters);
	}


}
