package com.ebmwebsourcing.easiergov.client.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.petalslink.events_api._1.FindEventProducersByElements;
import com.petalslink.events_api._1.FindEventProducersByElementsResponse;
import com.petalslink.events_api._1.FindEventProducersByTopicsRequest;
import com.petalslink.events_api._1.FindEventProducersByTopicsResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOM;
import com.petalslink.events_api._1.PublishTopicNamespaceFromDOMResponse;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURLResponse;
import com.petalslink.events_api._1_0.EventsManager;
import com.petalslink.events_api._1_0.FindEventProducersByElementsFault;
import com.petalslink.events_api._1_0.FindEventProducersByTopicsFault;
import com.petalslink.events_api._1_0.FindTopicsByElementFault;
import com.petalslink.events_api._1_0.FindTopicsFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromDOMFault;
import com.petalslink.events_api._1_0.PublishTopicNamespaceFromURLFault;

import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicType;

public class EventManagerClientImpl implements EventsManager {

    private String address = null;

    private EventsManager clientProxy = null;

    public EventManagerClientImpl(String address) {
        this.address = address;
    }
    
    public String getAddress() {
        return address;
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized EventsManager getClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, EventsManager.class);
        return clientProxy;
    }

	@Override
	public FindEventProducersByElementsResponse findEventProducersByElements(
			FindEventProducersByElements arg0)
			throws FindEventProducersByElementsFault {
		return this.getClientProxy().findEventProducersByElements(arg0);
	}

	@Override
	public FindEventProducersByTopicsResponse findEventProducersByTopics(
			FindEventProducersByTopicsRequest arg0)
			throws FindEventProducersByTopicsFault {
		return this.getClientProxy().findEventProducersByTopics(arg0);
	}

	@Override
	public List<EJaxbTopicType> findTopics(String arg0) throws FindTopicsFault {
		return this.getClientProxy().findTopics(arg0);
	}

	@Override
	public List<QName> findTopicsByElement(QName arg0)
			throws FindTopicsByElementFault {
		return this.getClientProxy().findTopicsByElement(arg0);
	}

	@Override
	public PublishTopicNamespaceFromDOMResponse publishTopicNamespaceFromDOM(
			PublishTopicNamespaceFromDOM arg0)
			throws PublishTopicNamespaceFromDOMFault {
		return this.getClientProxy().publishTopicNamespaceFromDOM(arg0);
	}

	@Override
	public PublishTopicNamespaceFromURLResponse publishTopicNamespaceFromURL(
			PublishTopicNamespaceFromURL arg0)
			throws PublishTopicNamespaceFromURLFault {
		return this.getClientProxy().publishTopicNamespaceFromURL(arg0);
	}




}
