package com.ebmwebsourcing.easiergov.client.impl.soap;

import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.petalslink.data_api._1.FindComplexTypes;
import com.petalslink.data_api._1.FindComplexTypesResponse;
import com.petalslink.data_api._1.FindElements;
import com.petalslink.data_api._1.FindElementsResponse;
import com.petalslink.data_api._1.FindSimpleTypes;
import com.petalslink.data_api._1.FindSimpleTypesResponse;
import com.petalslink.data_api._1.GetComplexType;
import com.petalslink.data_api._1.GetComplexTypeResponse;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import com.petalslink.data_api._1.GetSimpleType;
import com.petalslink.data_api._1.GetSimpleTypeResponse;
import com.petalslink.data_api._1.PublishSchemaFromDOM;
import com.petalslink.data_api._1.PublishSchemaFromDOMResponse;
import com.petalslink.data_api._1.PublishSchemaFromURL;
import com.petalslink.data_api._1.PublishSchemaFromURLResponse;
import com.petalslink.data_api._1_0.DataManager;
import com.petalslink.data_api._1_0.FaultMessage;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.UnconnectToEnvironmentFault;

public class DataManagerClientImplSOAP implements DataManager {

	private String address = null;

	private SOAPSender soapSender;

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(com.petalslink.data_api._1.ObjectFactory.class,
					easybox.org.w3._2001.xmlschema.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	public DataManagerClientImplSOAP(String address) {
		this.address = address;
		this.soapSender = new SOAPSender();
	}

	public String getAddress() {
		return address;
	}
	

	@Override
	public GetElementResponse getElement(GetElement parameters)
			throws FaultMessage {
		GetElementResponse res = new GetElementResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/getElement");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					throw new FaultMessage("Business Fault:\n" + XMLPrettyPrinter.prettyPrint(doc));
				} else {
					throw new FaultMessage("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetElementResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}

	@Override
	public GetComplexTypeResponse getComplexType(GetComplexType parameters)
			throws FaultMessage {
		GetComplexTypeResponse res = new GetComplexTypeResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/getComplexType");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new UnconnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new UnconnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetComplexTypeResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}

	@Override
	public FindElementsResponse findElements(FindElements parameters)
			throws FaultMessage {
		FindElementsResponse res = new FindElementsResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/findElements");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new UnconnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new UnconnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, FindElementsResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}

	@Override
	public FindComplexTypesResponse findComplexTypes(FindComplexTypes parameters)
			throws FaultMessage {
		FindComplexTypesResponse res = new FindComplexTypesResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/findComplexTypes");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new UnconnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new UnconnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, FindComplexTypesResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}

	@Override
	public PublishSchemaFromURLResponse publishSchemaFromURL(PublishSchemaFromURL parameters)
			throws FaultMessage {
		PublishSchemaFromURLResponse res = new PublishSchemaFromURLResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/publishSchemaFromURL");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new UnconnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new UnconnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, PublishSchemaFromURLResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}
	
	@Override
	public PublishSchemaFromDOMResponse publishSchemaFromDOM(PublishSchemaFromDOM parameters)
			throws FaultMessage {
		PublishSchemaFromDOMResponse res = new PublishSchemaFromDOMResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/publishSchemaFromDOM");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new UnconnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new UnconnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, PublishSchemaFromDOMResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}

	@Override
	public FindSimpleTypesResponse findSimpleTypes(FindSimpleTypes parameters)
			throws FaultMessage {
		FindSimpleTypesResponse res = new FindSimpleTypesResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/findSimpleTypes");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new UnconnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new UnconnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, FindSimpleTypesResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}

	@Override
	public GetSimpleTypeResponse getSimpleType(GetSimpleType parameters)
			throws FaultMessage {
		GetSimpleTypeResponse res = new GetSimpleTypeResponse();
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/data-api/1.0/getSimpleType");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new UnconnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new UnconnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetSimpleTypeResponse.class);
		} catch (Exception e) {
			throw new FaultMessage("Technical Fault", e);
		} 
		return res;
	}



}
