/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easiergov.client.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.petalslink.admin_api._1.GetServices;
import com.petalslink.admin_api._1.GetServicesResponse;
import com.petalslink.admin_api._1_0.AdminManager;
import com.petalslink.admin_api._1_0.GetInformationFault;
import com.petalslink.admin_api._1_0.GetServicesFault;

public class AdminManagerClientImpl implements AdminManager {

    private String address = null;

    private AdminManager clientProxy = null;

    public AdminManagerClientImpl(String address) {
        this.address = address;

       
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized AdminManager getClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, AdminManager.class);
        return clientProxy;
    }

    
    public String getAddress() {
        return address;
    }

    @Override
    public GetServicesResponse getServices(GetServices parameters) throws GetServicesFault {
        return this.getClientProxy().getServices(parameters);
    }

    @Override
    public QName getInformation() throws GetInformationFault {
        return this.getClientProxy().getInformation();
    }

	@Override
	public String ping() {
		return this.getClientProxy().ping();
	}

}
