/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easiergov.client.impl.soap;

import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.petalslink.admin_api._1.GetInformation;
import com.petalslink.admin_api._1.GetInformationResponse;
import com.petalslink.admin_api._1.GetServices;
import com.petalslink.admin_api._1.GetServicesResponse;
import com.petalslink.admin_api._1.Ping;
import com.petalslink.admin_api._1.PingResponse;
import com.petalslink.admin_api._1_0.AdminManager;
import com.petalslink.admin_api._1_0.GetInformationFault;
import com.petalslink.admin_api._1_0.GetServicesFault;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnectToEnvironmentFault;

public class AdminManagerClientImplSOAP implements AdminManager {

    private String address = null;

    private SOAPSender soapSender;
    
    static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(com.petalslink.admin_api._1.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

    public AdminManagerClientImplSOAP(String address) {
        this.address = address;
        this.soapSender = new SOAPSender();
    }
    


    
    public String getAddress() {
        return address;
    }

    @Override
    public GetServicesResponse getServices(GetServices payload) throws GetServicesFault {
    	GetServicesResponse res = null;
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/admin-api/1.0/getServices");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ConnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new ConnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetServicesResponse.class);
		} catch (Exception e) {
			throw new GetServicesFault("Technical Fault", e);
		} 

		return res;
    }

    @Override
    public QName getInformation() throws GetInformationFault {
    	GetInformationResponse res = null;
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(new GetInformation()));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/admin-api/1.0/getInformation");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new ConnectToEnvironmentFault("Business Fault", fault);
				} else {
					throw new ConnectToEnvironmentFault("Technical Fault:\n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetInformationResponse.class);
		} catch (Exception e) {
			throw new GetInformationFault("Technical Fault", e);
		} 

		return res.getName();
    }

	@Override
	public String ping() {
		String result = null;
		PingResponse res = null;
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(new Ping()));

			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://www.petalslink.com/admin-api/1.0/ping");

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, PingResponse.class);
			result = res.getOut();
		} catch (Exception e) {
			result = e.getMessage();
		} 

		return result;
	}

}
