package com.ebmwebsourcing.easiergov;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.admin.AdminManagerImpl;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.core.impl.AbstractContainer;
import com.petalslink.easiergov.core.impl.CoreManagerImpl;
import com.petalslink.easiergov.core.impl.ServerImpl;
import com.petalslink.easiergov.data.DataManagerImpl;
import com.petalslink.easiergov.data.SchemaResourceAnalyzerServiceImpl;
import com.petalslink.easiergov.events.EventsManagerImpl;
import com.petalslink.easiergov.events.EventsProducerAndTopicNameSpaceAnalyzerServiceImpl;
import com.petalslink.easiergov.services.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.easiergov.services.ServicesManagerImpl;
import com.petalslink.easiergov.usdl.USDLManagerImpl;

public class WSContainer extends AbstractContainer {

	
	private CoreManagerImpl coreManager = null;
	
    public WSContainer(Configuration conf) throws GovException {
        super(conf);
        this.coreManager = new CoreManagerImpl(conf);

        coreManager.getResourcesManager().addResourceAnalyzerService(new SchemaResourceAnalyzerServiceImpl());
        coreManager.getResourcesManager().addResourceAnalyzerService(new DefinitionsResourceAnalyzerServiceImpl());
        coreManager.getResourcesManager().addResourceAnalyzerService(new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());

        this.addServers(
                new ServerImpl("Admin API"       , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/adminManager", new AdminManagerImpl(this)),
                new ServerImpl("Connexion API"   , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/connexionManager", coreManager.getConnexionManager()),
                new ServerImpl("Resources API"   , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/resourcesManager", coreManager.getResourcesManager()),
                new ServerImpl("Service API"     , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/serviceManager", new ServicesManagerImpl(coreManager.getResourcesManager())),
                new ServerImpl("Data API"        , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/dataManager", new DataManagerImpl(coreManager.getResourcesManager())),
                new ServerImpl("Event API"       , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/eventManager", new EventsManagerImpl(coreManager.getResourcesManager())),
                new ServerImpl("USDL API"        , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/usdlManager", new USDLManagerImpl(coreManager.getResourcesManager()))
                );
    }

}
