/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.core.impl.config;

import com.petalslink.easiergov.core.config.Configuration;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationImpl
implements Configuration {
    private static Logger log = Logger.getLogger(ConfigurationImpl.class.getName());
    private Map<String, String> properties = new HashMap<String, String>();
    private static String CONFIG = "config.properties";

    public ConfigurationImpl() throws GovException {
        this.properties.put("name", "EasierGOV");
        this.properties.put("namespace", "http://com.petalslink.easiergov/");
        this.properties.put("host", "localhost");
        this.properties.put("port", "9600");
        this.properties.put("9601", "9601");
        this.properties.put("easiersbs.syntactic.acceptance.threshold", "0.1");
        this.properties.put("easiersbs.syntactic.levenshtein.limit", "2");
        this.properties.put("easiersbs.syntactic.similarity.type", "jaccard");
        this.loadConfigurationFile();
    }

    public ConfigurationImpl(Map<String, String> data) throws GovException {
        this.properties = data;
    }

    public ConfigurationImpl(String host, int port, int notif_port) throws GovException {
        this.properties.put("host", String.valueOf(host));
        this.properties.put("port", String.valueOf(port));
        this.properties.put("9601", String.valueOf(notif_port));
        this.properties.put("name", "EasierGOV");
        this.properties.put("namespace", "http://com.petalslink.easiergov/");
        this.properties.put("easiersbs.syntactic.acceptance.threshold", "0.1");
        this.properties.put("easiersbs.syntactic.levenshtein.limit", "2");
        this.properties.put("easiersbs.syntactic.similarity.type", "jaccard");
    }

    private void loadConfigurationFile() throws GovException {
        Properties props = new Properties();
        File f = new File(CONFIG);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading config from " + f.getAbsoluteFile());
        }
        FileInputStream is = null;
        if (f.exists()) {
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new GovException((Throwable)e);
            }
        }
        if (is != null) {
            try {
                props.load(is);
                for (Object k : props.keySet()) {
                    this.properties.put(k.toString().trim(), props.get(k).toString().trim());
                }
            }
            catch (IOException e) {
                throw new GovException((Throwable)e);
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new GovException((Throwable)e);
            }
        }
        log.warning("No configuration file found...");
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public static String getCONFIG() {
        return CONFIG;
    }

    public static void setCONFIG(String config) {
        CONFIG = config;
    }

    public Integer getPort() {
        return Integer.valueOf(this.getProperties().get("port"));
    }

    public String getHost() {
        return String.valueOf(this.getProperties().get("host"));
    }

    public void setHost(String host) {
        this.properties.put("host", String.valueOf(host));
    }

    public void setPort(int port) {
        this.properties.put("port", String.valueOf(port));
    }

    public Integer getNotificationPort() {
        return Integer.valueOf(this.getProperties().get("9601"));
    }

    public void setNotificationPort(int port) {
        this.properties.put("9601", String.valueOf(port));
    }

    public String getName() {
        return String.valueOf(this.getProperties().get("name"));
    }

    public void setName(String name) {
        this.properties.put("name", String.valueOf(name));
    }

    public String getNamespace() {
        return String.valueOf(this.getProperties().get("namespace"));
    }

    public void setNamespace(String namespace) {
        this.properties.put("namespace", String.valueOf(namespace));
    }

    public Float getEasiersbsSyntacticAcceptanceThreshold() {
        return Float.valueOf(this.getProperties().get("easiersbs.syntactic.acceptance.threshold"));
    }

    public void setEasiersbsSyntacticAcceptanceThreshold(Float f) {
        this.properties.put("easiersbs.syntactic.acceptance.threshold", String.valueOf(f));
    }

    public Integer getEasiersbsSyntacticLevenshteinLimit() {
        return Integer.valueOf(this.getProperties().get("easiersbs.syntactic.levenshtein.limit"));
    }

    public void setEasiersbsSyntacticLevenshteinLimit(Integer f) {
        this.properties.put("easiersbs.syntactic.levenshtein.limit", String.valueOf(f));
    }

    public SimilarityType getEasiersbsSyntacticSimilarityType() {
        String similarity = this.getProperties().get("easiersbs.syntactic.similarity.type");
        if (similarity != null) {
            if (similarity.toLowerCase().equals("jaccard")) {
                return SimilarityType.JACCARD;
            }
            if (similarity.toLowerCase().equals("dice")) {
                return SimilarityType.DICE;
            }
            if (similarity.toLowerCase().equals("cosine")) {
                return SimilarityType.COSINE;
            }
            if (similarity.toLowerCase().equals("jensen-shannon")) {
                return SimilarityType.JENSEN_SHANNON;
            }
        }
        return null;
    }

    public void setEasiersbsSyntacticSimilarityType(SimilarityType f) {
        if (f != null) {
            if (f == SimilarityType.JACCARD) {
                this.properties.put("easiersbs.syntactic.similarity.type", "jaccard");
            } else if (f == SimilarityType.DICE) {
                this.properties.put("easiersbs.syntactic.similarity.type", "dice");
            } else if (f == SimilarityType.COSINE) {
                this.properties.put("easiersbs.syntactic.similarity.type", "cosine");
            } else if (f == SimilarityType.JENSEN_SHANNON) {
                this.properties.put("easiersbs.syntactic.similarity.type", "jensen-shannon");
            }
        }
    }
}

