/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.core.impl;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.core.impl.ResourcesManager;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.esstar.essynchronizer.impl.AbstractResourcesManager;
import com.petalslink.esstar.essynchronizer.impl.ConnexionManagerImpl;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.ConnexionManager;
import java.util.logging.Logger;

public class CoreManagerImpl {
    private static Logger LOG = Logger.getLogger(CoreManagerImpl.class.getName());
    private Configuration configuration = null;
    private ConnexionManagerImpl connexionManager = null;
    private ResourcesManagerImpl resourcesManager = null;

    public CoreManagerImpl(Configuration conf) throws GovException {
        this.configuration = conf;
        this.resourcesManager = new ResourcesManagerImpl(conf);
    }

    public ResourcesManagerImpl getResourcesManager() {
        return this.resourcesManager;
    }

    public void clear() {
        this.resourcesManager.clear();
        if (this.connexionManager != null) {
            this.connexionManager.clear();
            this.connexionManager.shutdown();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ConnexionManager getConnexionManager() {
        if (this.connexionManager == null && this.configuration != null && this.configuration.getHost() != null && this.configuration.getNotificationPort() != null) {
            this.connexionManager = ConnexionManagerImpl.getInstance();
            this.connexionManager.init(this.configuration.getHost(), this.configuration.getNotificationPort(), (AbstractResourcesManager)new ResourcesManager(this.connexionManager, this.resourcesManager));
        }
        return this.connexionManager;
    }
}

