/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.core.impl;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.resolver.URIMemoryMultipleResolvers;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.core.container.Server;
import javax.xml.transform.URIResolver;

public class ServerImpl
implements Server {
    private com.ebmwebsourcing.easycommons.research.util.cxf.Server ep = null;
    private Object implementation = null;
    private String name = null;
    private Definitions def = null;
    private Port endpoint = null;
    private Service service = null;

    public ServerImpl(String name, String address, Object implementor) throws GovException {
        this.implementation = implementor;
        this.name = name;
        if (this.implementation == null) {
            throw new GovException("Implementation class of service cannot be null!!!");
        }
        this.ep = CXFHelper.getService((String)address, this.implementation.getClass(), (Object)this.implementation);
        try {
            if (this.ep.getWsdlLocation() == null) {
                throw new GovException("Impossible to find wsdl location on " + this.implementation.getClass());
            }
            SOAUtil.getInstance().getXmlContext((Framework)EasierGOVFramework.getInstance()).setURIResolver((URIResolver)new URIMemoryMultipleResolvers(new URIResolver[]{new DefaultURIResolver(), new ClasspathURIResolver()}));
            this.def = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierGOVFramework.getInstance()).get()).readDocument(Thread.currentThread().getContextClassLoader().getResource(this.ep.getWsdlLocation()), Definitions.class);
            this.service = this.def.getServiceByName(this.ep.getServiceQName().getLocalPart());
            this.endpoint = this.service.getPorts()[0];
            Address addr = SoapBindingHelper.getAddress((Port)this.endpoint);
            addr.setLocation(address);
            SoapBindingHelper.setAddress((Port)this.endpoint, (Address)addr);
        }
        catch (XmlObjectReadException e) {
            throw new GovException((Throwable)e);
        }
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.ep.getAddress();
    }

    public void start() throws GovException {
        this.ep.start();
        System.out.println("Start Server and expose service at this address: " + this.getAddress() + "?wsdl");
    }

    public void stop() throws GovException {
        this.ep.stop();
    }

    public Definitions getDefinitions() {
        return this.def;
    }

    public Port getEndpoint() {
        return this.endpoint;
    }

    public Service getService() {
        return this.service;
    }
}

