package com.petalslink.easiergov.core.impl;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.resolver.URIMemoryMultipleResolvers;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.core.container.Server;

/**
 * This class was generated by Apache CXF 2.2.9
 * Tue Feb 01 10:31:55 CET 2011
 * Generated source version: 2.2.9
 * 
 */

public class ServerImpl implements Server {

    private com.ebmwebsourcing.easycommons.research.util.cxf.Server ep = null;

    private Object implementation = null;

    private String name = null;

    private Definitions def = null;
    
    private Port endpoint = null;
    
    private Service service = null;

    public ServerImpl(String name, String address, Object implementor) throws GovException {
        this.implementation = implementor;
        this.name = name;
        
        if(this.implementation == null) {
            throw new GovException("Implementation class of service cannot be null!!!");
        }

        ep = CXFHelper.getService(address, this.implementation.getClass(), this.implementation);

        try {
            if(ep.getWsdlLocation() != null) {
            	SOAUtil.getInstance().getXmlContext(EasierGOVFramework.getInstance()).setURIResolver(new URIMemoryMultipleResolvers(new DefaultURIResolver(), new ClasspathURIResolver()));
                def = SOAUtil.getInstance().getReader(EasierGOVFramework.getInstance()).get().readDocument(Thread.currentThread().getContextClassLoader().getResource(ep.getWsdlLocation()), Definitions.class);
                service = def.getServiceByName(ep.getServiceQName().getLocalPart());
                endpoint = service.getPorts()[0];
                Address addr = SoapBindingHelper.getAddress(endpoint);
                addr.setLocation(address);
                SoapBindingHelper.setAddress(endpoint, addr);
            } else {
                throw new GovException("Impossible to find wsdl location on " + this.implementation.getClass());
            }
        } catch (XmlObjectReadException e) {
            throw new GovException(e);
        }
    }

    @Override
    public Object getImplementation() {
        return implementation;
    }

    @Override
    public String getName() {
        return this.name;
    }


    @Override
    public String getAddress() {
        return ep.getAddress();
    }

    @Override
    public void start() throws GovException {
        ep.start();
        System.out.println("Start Server and expose service at this address: " + this.getAddress() + "?wsdl");
    }

    @Override
    public void stop() throws GovException{
        ep.stop();
    }

    @Override
    public Definitions getDefinitions() {
        return def;
    }



    @Override
    public Port getEndpoint() {
        return this.endpoint;
    }



    @Override
    public Service getService() {
        return this.service;
    }
}
