/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.resources;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.easiergov.resources.api.StorageService;
import com.petalslink.easiersbs.matching.service.SBSFactoryImpl;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.util.SimilarityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class StorageServiceImpl
implements StorageService {
    private static Logger LOG = Logger.getLogger(StorageServiceImpl.class.getName());
    private Map<ResourceType, Map<QName, Resource>> memory = Collections.synchronizedMap(new HashMap());
    private SBSFactory factory = SBSFactoryImpl.getInstance();
    private SimilarityMeasure similarity;
    private Configuration configuration;

    public StorageServiceImpl(Configuration conf) throws GovException {
        this.configuration = conf;
        try {
            this.similarity = this.factory.newSimilarityMeasure(conf.getEasiersbsSyntacticSimilarityType(), conf.getEasiersbsSyntacticLevenshteinLimit().intValue());
        }
        catch (EasierSBSException e) {
            throw new GovException((Throwable)e);
        }
    }

    public QName store(Resource r) throws GovException {
        Map<QName, Object> registry = this.memory.get(r.getResourceType());
        if (registry == null) {
            registry = Collections.synchronizedMap(new HashMap());
            this.memory.put(r.getResourceType(), registry);
        }
        if (registry.get(r.getId()) != null) {
            LOG.warning("Impossible to store this ressource \"" + r.getId() + "\" - type: " + r.getResourceType() + "!!!\nA ressource with the same type and id already exist!!!");
        }
        registry.put(r.getId(), r);
        return r.getId();
    }

    public Resource get(QName id, ResourceType type) {
        Map<QName, Resource> registry;
        Resource r = null;
        if (type != null && (registry = this.memory.get(type)) != null) {
            r = registry.get(id);
        }
        return r;
    }

    public List<Resource> find(String query, ResourceType type) {
        ArrayList<Resource> rscs;
        block4: {
            List functionalWords;
            block3: {
                rscs = new ArrayList<Resource>();
                functionalWords = SimilarityUtil.splitInWords((String)query);
                if (type == null) break block3;
                Map<QName, Resource> registry = this.memory.get(type);
                if (registry == null) break block4;
                for (Resource rsc : registry.values()) {
                    List expectedWords = SimilarityUtil.splitInWords((String)rsc.getId().getLocalPart());
                    double finalRate = this.similarity.measureSimilarity(functionalWords, expectedWords);
                    if (!(finalRate >= (double)this.configuration.getEasiersbsSyntacticAcceptanceThreshold().floatValue())) continue;
                    rscs.add(rsc);
                }
                break block4;
            }
            for (Map<QName, Resource> registry : this.memory.values()) {
                if (registry == null) continue;
                for (Resource rsc : registry.values()) {
                    List expectedWords = SimilarityUtil.splitInWords((String)rsc.getId().getLocalPart());
                    double finalRate = this.similarity.measureSimilarity(functionalWords, expectedWords);
                    if (!(finalRate >= (double)this.configuration.getEasiersbsSyntacticAcceptanceThreshold().floatValue())) continue;
                    rscs.add(rsc);
                }
            }
        }
        return rscs;
    }

    public boolean detectSyntaxSimilarity(String request, String expected) {
        List expectedWords;
        List functionalWords = SimilarityUtil.splitInWords((String)request);
        double finalRate = this.similarity.measureSimilarity(functionalWords, expectedWords = SimilarityUtil.splitInWords((String)expected));
        return finalRate >= (double)this.configuration.getEasiersbsSyntacticAcceptanceThreshold().floatValue();
    }

    public Resource unstore(QName id, ResourceType type) {
        Map<QName, Resource> registry;
        Resource r = null;
        if (type != null && (registry = this.memory.get(type)) != null) {
            r = registry.remove(id);
        }
        return r;
    }

    public void clear() {
        this.memory.clear();
    }

    public List<Resource> getAllByResourceType(ResourceType type) {
        Map<QName, Resource> rsc = this.memory.get(type);
        if (rsc != null) {
            return new ArrayList<Resource>(rsc.values());
        }
        return new ArrayList<Resource>();
    }

    public int getNumberOfResources() {
        int res = 0;
        for (Map<QName, Resource> map : this.memory.values()) {
            res += map.values().size();
        }
        return res;
    }

    public String toString() {
        String res = "";
        for (Map.Entry<ResourceType, Map<QName, Resource>> entry : this.memory.entrySet()) {
            for (QName name : entry.getValue().keySet()) {
                res = res + "id: " + name + " - type: " + entry.getKey().getTypeName() + "\n";
            }
        }
        return res;
    }
}

