/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.resources;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.resources.ResourceAnalyzerManagerImpl;
import com.petalslink.easiergov.resources.StorageServiceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerManager;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.easiergov.resources.api.StorageService;
import com.petalslink.resources_api._1.Criteria;
import com.petalslink.resources_api._1.Fault;
import com.petalslink.resources_api._1.Find;
import com.petalslink.resources_api._1.FindResponse;
import com.petalslink.resources_api._1.Get;
import com.petalslink.resources_api._1.GetFault;
import com.petalslink.resources_api._1.GetResponse;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.Remove;
import com.petalslink.resources_api._1.RemoveFault;
import com.petalslink.resources_api._1.RemoveResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.FindFault;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.ResourcesManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

@WebService(serviceName="ResourcesManager", portName="ResourcesManagerPort", targetNamespace="http://www.petalslink.com/resources-api/1.0", wsdlLocation="resources-ws.wsdl", endpointInterface="com.petalslink.resources_api._1_0.ResourcesManager")
public class ResourcesManagerImpl
implements ResourcesManager,
ResourceAnalyzerManager {
    private static Logger LOG = Logger.getLogger(ResourcesManagerImpl.class.getName());
    private StorageService storage = null;
    private ResourceAnalyzerManager manager = null;
    private static ResourcesManagerImpl INSTANCE = null;

    public ResourcesManagerImpl(Configuration conf) throws GovException {
        this.storage = new StorageServiceImpl(conf);
        this.manager = new ResourceAnalyzerManagerImpl();
    }

    public GetResponse get(Get parameters) throws com.petalslink.resources_api._1_0.GetFault {
        GetResponse response = new GetResponse();
        try {
            String resourceTypeString = parameters.getResourceType();
            ResourceType resourceType = this.manager.findResourceType(resourceTypeString);
            if (resourceType == null) {
                throw new GovException("Impossible to find RessourceType corresponding to: " + resourceTypeString);
            }
            Resource r = this.storage.get(parameters.getId(), resourceType);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierGOVFramework.getInstance()).get()).writeDocument((XmlObject)r.getContent(), (OutputStream)baos);
            ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
            response.setAny((Object)doc.getDocumentElement());
            writtenStream.close();
        }
        catch (Exception e) {
            GetFault fault = new GetFault();
            Fault f = new Fault();
            f.setMessage(e.getMessage());
            f.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            fault.setFault(f);
            com.petalslink.resources_api._1_0.GetFault ex = new com.petalslink.resources_api._1_0.GetFault(e.getMessage(), fault);
            throw ex;
        }
        return response;
    }

    public PublishResponse publish(Publish parameters) throws PublishFault {
        PublishResponse response = null;
        Document doc = null;
        try {
            URL url = new URL(parameters.getRessourceUrl());
            InputStream is = url.openStream();
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
            is.close();
            response = this.publish(doc, new HashMap<String, Object>());
        }
        catch (Exception e) {
            com.petalslink.resources_api._1.PublishFault fault = new com.petalslink.resources_api._1.PublishFault();
            Fault f = new Fault();
            f.setMessage(e.getMessage());
            f.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            fault.setFault(f);
            PublishFault ex = new PublishFault(e.getMessage(), fault);
            throw ex;
        }
        return response;
    }

    public PublishResponse publish(Document doc, Map<String, Object> metadata) throws PublishFault {
        PublishResponse response = new PublishResponse();
        ArrayList<Resource> resourcesAlreadyStore = new ArrayList<Resource>();
        try {
            List resources = this.manager.analyse(doc, metadata);
            for (Resource r : resources) {
                ResourceIdentifier rid = new ResourceIdentifier();
                rid.setId(r.getId().toString());
                rid.setResourceType(r.getResourceType().getTypeName());
                this.storage.store(r);
                response.getResourceIdentifier().add(rid);
                resourcesAlreadyStore.add(r);
            }
        }
        catch (Exception e) {
            for (Resource r : resourcesAlreadyStore) {
                this.storage.unstore(r.getId(), r.getResourceType());
            }
            com.petalslink.resources_api._1.PublishFault fault = new com.petalslink.resources_api._1.PublishFault();
            Fault f = new Fault();
            f.setMessage(e.getMessage());
            f.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            fault.setFault(f);
            PublishFault ex = new PublishFault(e.getMessage(), fault);
            throw ex;
        }
        return response;
    }

    public RemoveResponse remove(Remove parameters) throws com.petalslink.resources_api._1_0.RemoveFault {
        RemoveResponse response = new RemoveResponse();
        try {
            String resourceTypeString = parameters.getResourceIdentifier().getResourceType();
            ResourceType resourceType = this.manager.findResourceType(resourceTypeString);
            if (resourceType == null) {
                throw new GovException("Impossible to find RessourceType corresponding to: " + resourceTypeString);
            }
            Resource r = this.storage.unstore(QName.valueOf(parameters.getResourceIdentifier().getId()), resourceType);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierGOVFramework.getInstance()).get()).writeDocument((XmlObject)r.getContent(), (OutputStream)baos);
            ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
            response.setAny((Object)doc.getDocumentElement());
            writtenStream.close();
        }
        catch (Exception e) {
            RemoveFault fault = new RemoveFault();
            Fault f = new Fault();
            f.setMessage(e.getMessage());
            f.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            fault.setFault(f);
            com.petalslink.resources_api._1_0.RemoveFault ex = new com.petalslink.resources_api._1_0.RemoveFault(e.getMessage(), fault);
            throw ex;
        }
        return response;
    }

    public List<ResourceType> getAllResourceType() {
        return this.manager.getAllResourceType();
    }

    public void addResourceAnalyzerService(AbstractResourceAnalyzerService ras) throws GovException {
        this.manager.addResourceAnalyzerService(ras);
    }

    public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
        return this.manager.analyse(doc, metadata);
    }

    public Resource get(QName id, ResourceType type) {
        return this.storage.get(id, type);
    }

    public Resource remove(QName id, ResourceType type) {
        return this.storage.unstore(id, type);
    }

    public void clear() {
        this.storage.clear();
        this.manager.clear();
    }

    public void store(Resource r) throws GovException {
        this.storage.store(r);
    }

    public ResourceType findResourceType(String name) {
        return this.manager.findResourceType(name);
    }

    public int getNumberOfResources() {
        return this.storage.getNumberOfResources();
    }

    public String toString() {
        return this.storage.toString();
    }

    public FindResponse find(Find parameters) throws FindFault {
        FindResponse resp = new FindResponse();
        ResourceType type = null;
        if (parameters.getCriteria() != null && !parameters.getCriteria().isEmpty()) {
            for (Criteria c : parameters.getCriteria()) {
                if (!c.getName().equals("resource-type")) continue;
                type = this.findResourceType(c.getValue());
            }
        }
        List rscs = this.storage.find(parameters.getQuery(), type);
        for (Resource r : rscs) {
            if (resp.getAny().contains(r.getContent())) continue;
            resp.getAny().add(r.getContent());
        }
        return resp;
    }

    public List<Resource> getAllByResourceType(ResourceType type) {
        return this.storage.getAllByResourceType(type);
    }

    public boolean detectSyntaxSimilarity(String request, String expected) {
        return ((StorageServiceImpl)this.storage).detectSyntaxSimilarity(request, expected);
    }
}

