package com.petalslink.easiergov.services;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.petalslink.easiergov.resources.ResourceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;
import com.petalslink.easiergov.services.resolver.EasyESBURIResolver;

public class DefinitionsResourceAnalyzerServiceImpl extends AbstractResourceAnalyzerService implements ResourceAnalyzerService {


	private static Logger LOG = Logger.getLogger(DefinitionsResourceAnalyzerServiceImpl.class.getName());

	private static EasyESBURIResolver resolver = new EasyESBURIResolver();

	public DefinitionsResourceAnalyzerServiceImpl() {
		super();
		this.types.add(ServiceResourceType.getInstance());
		this.types.add(InterfaceResourceType.getInstance());
		this.types.add(EndpointResourceType.getInstance());

		SOAUtil.getInstance().getXmlContext(EasierGOVFramework.getInstance()).setURIResolver(new URIMultipleResolvers(new DefaultURIResolver(), new ClasspathURIResolver(), resolver));
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
		List<Resource> resources = new ArrayList<Resource>();

		try {
			Definitions def = null;
			XmlObjectReader reader = SOAUtil.getInstance().getReader(EasierGOVFramework.getInstance()).get();

			System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN SERVICE");
			synchronized (resolver) {
				resolver.setAddress((String) metadata.get("address"));
				List<String> esbNodes = (List<String>) metadata.get("esbNodes");
				if(esbNodes != null) {
					for(String node: esbNodes) {
						resolver.addEsbNodeAddress(node);
					}
				}

				String id = (String) metadata.get("resourceId");
				resolver.setEndpoint(id);

				def = reader.readDocument(doc, Definitions.class);

				if(id != null) {
					EndpointAddress addr = ESBUtil.analyzeURI(URI.create(id));
					Description desc = (Description) Factory.getInstance().wrap(def);
					QName endpointQName = new QName(addr.getNamespace(), addr.getEndpointname());
					break2:for(org.petalslink.abslayer.service.api.Service s: desc.getServices()) {
						for(Endpoint p: s.getEndpoints()) {
							if(desc.getTargetNamespace().equals(endpointQName.getNamespaceURI())
									&& p.getName().equals(endpointQName.getLocalPart())) {
								resources.add(new ResourceImpl(new QName(desc.getTargetNamespace(), p.getName()), EndpointResourceType.getInstance(), def));
								resources.add(new ResourceImpl(s.getQName(), ServiceResourceType.getInstance(), def));
								resources.add(new ResourceImpl(p.getBinding().getInterfaceQName(), InterfaceResourceType.getInstance(), def));
								break break2;
							}
						}
					}
				} else {
					// publish all
					for(Service s: def.getServices()) {
						resources.add(new ResourceImpl(s.inferQName(), ServiceResourceType.getInstance(), def));
						for(Port p: s.getPorts()) {
							resources.add(new ResourceImpl(new QName(def.getTargetNamespace(), p.getName()), EndpointResourceType.getInstance(), def));

						}
					}
					for(PortType pt: def.getPortTypes()) {
						resources.add(new ResourceImpl(new QName(def.getTargetNamespace(), pt.getName()), InterfaceResourceType.getInstance(), def));
					}
				}
				resolver.setEndpoint(null);
			}
		} catch (Throwable e) {
			// do nothing
			LOG.finest("Resource cannot be analysed by " + this.getClass().getSimpleName() +  ": \n" + XMLPrettyPrinter.prettyPrint(doc) + "\nMetadata = " + metadata);
			System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN SERVICE: " + "Resource cannot be analysed by " + this.getClass().getSimpleName() +  ": \n" + XMLPrettyPrinter.prettyPrint(doc) + "\nMetadata = " + metadata);
		}


		return resources;
	}

	@Override
	public List<Resource> postAnalyse(Resource resource) throws GovException {
		return new ArrayList<Resource>();
	}


}
