package com.petalslink.easiergov.services.convertor;

import javax.xml.namespace.QName;

import com.petalslink.easiergov.services.ServicesException;
import com.petalslink.services_model._1.ServiceType;
import com.petalslink.services_model._1.TechnicalInterfaceType;
import com.petalslink.services_model._1.TechnicalOperationType;

import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Operation;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;

public class Wsdl11ToUSDL {


	static public ServiceType getServiceFromWSDL11Service(Service serv11) throws ServicesException {
		ServiceType res = new ServiceType();
		res.setId(serv11.inferQName().toString());
		res.setName(serv11.getName());

		Definitions wsdl11def = (Definitions)serv11.getXmlObjectRoot();
		for(Port ep: serv11.getPorts()) {
			Binding b = wsdl11def.getBindingByName(ep.getBinding().getLocalPart());
			if(b == null) {
				throw new ServicesException("Impossible to find binding " + ep.getBinding() + " in definitions " + wsdl11def.getName());
			}


			PortType itf = wsdl11def.getPortTypeByName(b.getType().getLocalPart());
			if(itf == null) {
				throw new ServicesException("Impossible to find portType " + b.getType() + " in definitions " + wsdl11def.getName());
			}
			TechnicalInterfaceType tit =  Wsdl11ToUSDL.getTechnicalInterfaceFromWSDL11PortType(QName.valueOf(res.getId()), itf);

			res.getTechnicalInterface().add(tit);
		}

		return res;

	}

	static public TechnicalInterfaceType getTechnicalInterfaceFromWSDL11PortType(
			QName idService, PortType itf)throws ServicesException {
		TechnicalInterfaceType res = new TechnicalInterfaceType();
		Definitions wsdl11def = (Definitions)itf.getXmlObjectRoot();

		res.setId(new QName(wsdl11def.getTargetNamespace(),itf.getName()).toString());
		res.setName(itf.getName());
		res.setIdService(idService.toString());

		for(Operation op: itf.getOperations()) {
			TechnicalOperationType top =  Wsdl11ToUSDL.getTechnicalOperationFromWSDL11Operation(res, op);
		}

		return res;
	}

	public static TechnicalOperationType getTechnicalOperationFromWSDL11Operation(
			TechnicalInterfaceType usdlItf, Operation op) {
		// TODO Auto-generated method stub
		return null;
	}

}
