/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.services;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.petalslink.easiergov.resources.ResourceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.easiergov.services.EndpointResourceType;
import com.petalslink.easiergov.services.InterfaceResourceType;
import com.petalslink.easiergov.services.ServiceResourceType;
import com.petalslink.easiergov.services.resolver.EasyESBURIResolver;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Service;
import org.w3c.dom.Document;

public class DefinitionsResourceAnalyzerServiceImpl
extends AbstractResourceAnalyzerService
implements ResourceAnalyzerService {
    private static Logger LOG = Logger.getLogger(DefinitionsResourceAnalyzerServiceImpl.class.getName());
    private static EasyESBURIResolver resolver = new EasyESBURIResolver();

    public DefinitionsResourceAnalyzerServiceImpl() {
        this.types.add(ServiceResourceType.getInstance());
        this.types.add(InterfaceResourceType.getInstance());
        this.types.add(EndpointResourceType.getInstance());
        SOAUtil.getInstance().getXmlContext((Framework)EasierGOVFramework.getInstance()).setURIResolver((URIResolver)new URIMultipleResolvers(new URIResolver[]{new DefaultURIResolver(), new ClasspathURIResolver(), resolver}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            Definitions def = null;
            XmlObjectReader reader = (XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierGOVFramework.getInstance()).get();
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN SERVICE");
            EasyESBURIResolver easyESBURIResolver = resolver;
            synchronized (easyESBURIResolver) {
                block14: {
                    resolver.setAddress((String)metadata.get("address"));
                    List esbNodes = (List)metadata.get("esbNodes");
                    if (esbNodes != null) {
                        for (String node : esbNodes) {
                            resolver.addEsbNodeAddress(node);
                        }
                    }
                    String id = (String)metadata.get("resourceId");
                    resolver.setEndpoint(id);
                    def = (Definitions)reader.readDocument(doc, Definitions.class);
                    if (id != null) {
                        EndpointAddress addr = ESBUtil.analyzeURI((URI)URI.create(id));
                        Description desc = (Description)Factory.getInstance().wrap((XmlObject)def);
                        QName endpointQName = new QName(addr.getNamespace(), addr.getEndpointname());
                        for (Service s : desc.getServices()) {
                            for (Endpoint p : s.getEndpoints()) {
                                if (!desc.getTargetNamespace().equals(endpointQName.getNamespaceURI()) || !p.getName().equals(endpointQName.getLocalPart())) continue;
                                resources.add((Resource)new ResourceImpl(new QName(desc.getTargetNamespace(), p.getName()), (ResourceType)EndpointResourceType.getInstance(), (Object)def));
                                resources.add((Resource)new ResourceImpl(s.getQName(), (ResourceType)ServiceResourceType.getInstance(), (Object)def));
                                resources.add((Resource)new ResourceImpl(p.getBinding().getInterfaceQName(), (ResourceType)InterfaceResourceType.getInstance(), (Object)def));
                                break block14;
                            }
                        }
                    } else {
                        for (com.ebmwebsourcing.easywsdl11.api.element.Service service : def.getServices()) {
                            resources.add((Resource)new ResourceImpl(service.inferQName(), (ResourceType)ServiceResourceType.getInstance(), (Object)def));
                            for (Port p : service.getPorts()) {
                                resources.add((Resource)new ResourceImpl(new QName(def.getTargetNamespace(), p.getName()), (ResourceType)EndpointResourceType.getInstance(), (Object)def));
                            }
                        }
                        for (com.ebmwebsourcing.easywsdl11.api.element.Service service : def.getPortTypes()) {
                            resources.add((Resource)new ResourceImpl(new QName(def.getTargetNamespace(), service.getName()), (ResourceType)InterfaceResourceType.getInstance(), (Object)def));
                        }
                    }
                }
                resolver.setEndpoint(null);
            }
        }
        catch (Throwable e) {
            LOG.finest("Resource cannot be analysed by " + ((Object)((Object)this)).getClass().getSimpleName() + ": \n" + XMLPrettyPrinter.prettyPrint((Document)doc) + "\nMetadata = " + metadata);
            System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++ ANALYSE IN SERVICE: Resource cannot be analysed by " + ((Object)((Object)this)).getClass().getSimpleName() + ": \n" + XMLPrettyPrinter.prettyPrint((Document)doc) + "\nMetadata = " + metadata);
        }
        return resources;
    }

    public List<Resource> postAnalyse(Resource resource) throws GovException {
        return new ArrayList<Resource>();
    }
}

