package com.petalslink.easiergov.services;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.petalslink.easiergov.resources.ResourceImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.services.convertor.USDLToWSDL11;
import com.petalslink.easiergov.services.convertor.Wsdl11ToUSDL;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.services_api._1.CreateTechnicalCondition;
import com.petalslink.services_api._1.CreateTechnicalConditionResponse;
import com.petalslink.services_api._1.CreateTechnicalFault;
import com.petalslink.services_api._1.CreateTechnicalFaultResponse;
import com.petalslink.services_api._1.CreateTechnicalInterface;
import com.petalslink.services_api._1.CreateTechnicalInterfaceResponse;
import com.petalslink.services_api._1.CreateTechnicalOperation;
import com.petalslink.services_api._1.CreateTechnicalOperationResponse;
import com.petalslink.services_api._1.CreateTechnicalParameter;
import com.petalslink.services_api._1.CreateTechnicalParameterResponse;
import com.petalslink.services_api._1.CreateTechnicalProfile;
import com.petalslink.services_api._1.CreateTechnicalProfileResponse;
import com.petalslink.services_api._1.CreateTechnicalProtocol;
import com.petalslink.services_api._1.CreateTechnicalProtocolResponse;
import com.petalslink.services_api._1.Fault;
import com.petalslink.services_api._1.FindServices;
import com.petalslink.services_api._1.FindServicesResponse;
import com.petalslink.services_api._1.FindTechnicalConditions;
import com.petalslink.services_api._1.FindTechnicalConditionsResponse;
import com.petalslink.services_api._1.FindTechnicalFaults;
import com.petalslink.services_api._1.FindTechnicalFaultsResponse;
import com.petalslink.services_api._1.FindTechnicalInterfaces;
import com.petalslink.services_api._1.FindTechnicalInterfacesResponse;
import com.petalslink.services_api._1.FindTechnicalOperations;
import com.petalslink.services_api._1.FindTechnicalOperationsResponse;
import com.petalslink.services_api._1.FindTechnicalParameters;
import com.petalslink.services_api._1.FindTechnicalParametersResponse;
import com.petalslink.services_api._1.FindTechnicalProfiles;
import com.petalslink.services_api._1.FindTechnicalProfilesResponse;
import com.petalslink.services_api._1.FindTechnicalProtocols;
import com.petalslink.services_api._1.FindTechnicalProtocolsResponse;
import com.petalslink.services_api._1.GetService;
import com.petalslink.services_api._1.GetServiceResponse;
import com.petalslink.services_api._1.GetTechnicalCondition;
import com.petalslink.services_api._1.GetTechnicalConditionResponse;
import com.petalslink.services_api._1.GetTechnicalFault;
import com.petalslink.services_api._1.GetTechnicalFaultResponse;
import com.petalslink.services_api._1.GetTechnicalInterface;
import com.petalslink.services_api._1.GetTechnicalInterfaceResponse;
import com.petalslink.services_api._1.GetTechnicalOperation;
import com.petalslink.services_api._1.GetTechnicalOperationResponse;
import com.petalslink.services_api._1.GetTechnicalParameter;
import com.petalslink.services_api._1.GetTechnicalParameterResponse;
import com.petalslink.services_api._1.GetTechnicalProfile;
import com.petalslink.services_api._1.GetTechnicalProfileResponse;
import com.petalslink.services_api._1.GetTechnicalProtocol;
import com.petalslink.services_api._1.GetTechnicalProtocolResponse;
import com.petalslink.services_api._1.PublishService;
import com.petalslink.services_api._1.PublishServiceResponse;
import com.petalslink.services_api._1.RemoveService;
import com.petalslink.services_api._1.RemoveServiceResponse;
import com.petalslink.services_api._1.RemoveTechnicalCondition;
import com.petalslink.services_api._1.RemoveTechnicalConditionResponse;
import com.petalslink.services_api._1.RemoveTechnicalFault;
import com.petalslink.services_api._1.RemoveTechnicalFaultResponse;
import com.petalslink.services_api._1.RemoveTechnicalInterface;
import com.petalslink.services_api._1.RemoveTechnicalInterfaceResponse;
import com.petalslink.services_api._1.RemoveTechnicalOperation;
import com.petalslink.services_api._1.RemoveTechnicalOperationResponse;
import com.petalslink.services_api._1.RemoveTechnicalParameter;
import com.petalslink.services_api._1.RemoveTechnicalParameterResponse;
import com.petalslink.services_api._1.RemoveTechnicalProfile;
import com.petalslink.services_api._1.RemoveTechnicalProfileResponse;
import com.petalslink.services_api._1.RemoveTechnicalProtocol;
import com.petalslink.services_api._1.RemoveTechnicalProtocolResponse;
import com.petalslink.services_api._1.UpdateService;
import com.petalslink.services_api._1.UpdateServiceResponse;
import com.petalslink.services_api._1.UpdateTechnicalCondition;
import com.petalslink.services_api._1.UpdateTechnicalConditionResponse;
import com.petalslink.services_api._1.UpdateTechnicalFault;
import com.petalslink.services_api._1.UpdateTechnicalFaultResponse;
import com.petalslink.services_api._1.UpdateTechnicalInterface;
import com.petalslink.services_api._1.UpdateTechnicalInterfaceResponse;
import com.petalslink.services_api._1.UpdateTechnicalOperation;
import com.petalslink.services_api._1.UpdateTechnicalOperationResponse;
import com.petalslink.services_api._1.UpdateTechnicalParameter;
import com.petalslink.services_api._1.UpdateTechnicalParameterResponse;
import com.petalslink.services_api._1.UpdateTechnicalProfile;
import com.petalslink.services_api._1.UpdateTechnicalProfileResponse;
import com.petalslink.services_api._1.UpdateTechnicalProtocol;
import com.petalslink.services_api._1.UpdateTechnicalProtocolResponse;
import com.petalslink.services_api._1_0.CreateTechnicalConditionFault;
import com.petalslink.services_api._1_0.CreateTechnicalFaultFault;
import com.petalslink.services_api._1_0.CreateTechnicalInterfaceFault;
import com.petalslink.services_api._1_0.CreateTechnicalOperationFault;
import com.petalslink.services_api._1_0.CreateTechnicalParameterFault;
import com.petalslink.services_api._1_0.CreateTechnicalProfileFault;
import com.petalslink.services_api._1_0.CreateTechnicalProtocolFault;
import com.petalslink.services_api._1_0.FindServicesFault;
import com.petalslink.services_api._1_0.FindTechnicalConditionsFault;
import com.petalslink.services_api._1_0.FindTechnicalFaultsFault;
import com.petalslink.services_api._1_0.FindTechnicalInterfacesFault;
import com.petalslink.services_api._1_0.FindTechnicalOperationsFault;
import com.petalslink.services_api._1_0.FindTechnicalParametersFault;
import com.petalslink.services_api._1_0.FindTechnicalProfilesFault;
import com.petalslink.services_api._1_0.FindTechnicalProtocolsFault;
import com.petalslink.services_api._1_0.GetServiceFault;
import com.petalslink.services_api._1_0.GetTechnicalConditionFault;
import com.petalslink.services_api._1_0.GetTechnicalFaultFault;
import com.petalslink.services_api._1_0.GetTechnicalInterfaceFault;
import com.petalslink.services_api._1_0.GetTechnicalOperationFault;
import com.petalslink.services_api._1_0.GetTechnicalParameterFault;
import com.petalslink.services_api._1_0.GetTechnicalProfileFault;
import com.petalslink.services_api._1_0.GetTechnicalProtocolFault;
import com.petalslink.services_api._1_0.PublishServiceFault;
import com.petalslink.services_api._1_0.RemoveServiceFault;
import com.petalslink.services_api._1_0.RemoveTechnicalConditionFault;
import com.petalslink.services_api._1_0.RemoveTechnicalFaultFault;
import com.petalslink.services_api._1_0.RemoveTechnicalInterfaceFault;
import com.petalslink.services_api._1_0.RemoveTechnicalOperationFault;
import com.petalslink.services_api._1_0.RemoveTechnicalParameterFault;
import com.petalslink.services_api._1_0.RemoveTechnicalProfileFault;
import com.petalslink.services_api._1_0.RemoveTechnicalProtocolFault;
import com.petalslink.services_api._1_0.ServicesManager;
import com.petalslink.services_api._1_0.UpdateServiceFault;
import com.petalslink.services_api._1_0.UpdateTechnicalConditionFault;
import com.petalslink.services_api._1_0.UpdateTechnicalFaultFault;
import com.petalslink.services_api._1_0.UpdateTechnicalInterfaceFault;
import com.petalslink.services_api._1_0.UpdateTechnicalOperationFault;
import com.petalslink.services_api._1_0.UpdateTechnicalParameterFault;
import com.petalslink.services_api._1_0.UpdateTechnicalProfileFault;
import com.petalslink.services_api._1_0.UpdateTechnicalProtocolFault;

@javax.jws.WebService(
        serviceName = "ServicesManager",
        portName = "ServicesManagerPort",
        targetNamespace = "http://www.petalslink.com/services-api/1.0",
        wsdlLocation = "services-ws.wsdl",
        endpointInterface = "com.petalslink.services_api._1_0.ServicesManager")
		public class ServicesManagerImpl implements ServicesManager {

	private static Logger LOG = Logger.getLogger(ServicesManagerImpl.class.getName());

	private static ServicesManager INSTANCE;

	private ServicesManagerImpl() {
	}

	public static ServicesManager getInstance() throws GovException {
		if(INSTANCE == null) {
			INSTANCE = new ServicesManagerImpl();
		}
		return INSTANCE;
	}

	@Override
	public FindServicesResponse findServices(FindServices parameters) throws FindServicesFault{
		return null;
	}

	@Override
	public RemoveServiceResponse removeService(RemoveService parameters) throws RemoveServiceFault {
		RemoveServiceResponse response = null;
		QName id = parameters.getIdService();
		try {
			Resource r = ResourcesManagerImpl.getInstance().remove(id, ServiceResourceType.getInstance());
			if(r != null) {
				XmlObject internalModel = (XmlObject) r.getContent();
				if(internalModel instanceof Definitions) {
					response = new RemoveServiceResponse();
					Service wsdlservice = ((Definitions)internalModel).getServiceByName(id.getLocalPart());	
					response.setService(Wsdl11ToUSDL.getServiceFromWSDL11Service(wsdlservice));
					((Definitions)internalModel).removeService(wsdlservice);

				} else {
					Fault fault = new Fault();
					fault.setMessage("Impossible to convert " + internalModel + " in USDL service");
					RemoveServiceFault removeServiceFault = new RemoveServiceFault();
					removeServiceFault.getFaultInfo().setFault(fault);
					throw removeServiceFault;
				}
			}
		} catch (ServicesException e) {
			Fault fault = new Fault();
			fault.setMessage(e.getLocalizedMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			RemoveServiceFault removeServiceFault = new RemoveServiceFault();
			removeServiceFault.getFaultInfo().setFault(fault);
			throw removeServiceFault;
		}
		return response;
	}

	@Override
	public CreateTechnicalProtocolResponse createTechnicalProtocol(
			CreateTechnicalProtocol parameters) throws CreateTechnicalProtocolFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public CreateTechnicalConditionResponse createTechnicalCondition(
			CreateTechnicalCondition parameters)throws CreateTechnicalConditionFault{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateServiceResponse updateService(UpdateService parameters) throws UpdateServiceFault {
		UpdateServiceResponse response = null;
		try {
			if(parameters.getService() != null) {
				QName id = QName.valueOf(parameters.getService().getId());
				Resource r = ResourcesManagerImpl.getInstance().get(id, ServiceResourceType.getInstance());
				if(r != null) {
					XmlObject internalModel = (XmlObject) r.getContent();
					if(internalModel instanceof Definitions) {
						response = new UpdateServiceResponse();
						Service wsdlservice = ((Definitions)internalModel).getServiceByName(id.getLocalPart());
						USDLToWSDL11.setServiceInWSDL11Service(parameters.getService(), wsdlservice);
						response.setIdService(wsdlservice.inferQName());

						if(!wsdlservice.inferQName().equals(id)) {
							ResourcesManagerImpl.getInstance().remove(id, ServiceResourceType.getInstance());
							Resource newR = new ResourceImpl(wsdlservice.inferQName(), ServiceResourceType.getInstance(), internalModel);
							ResourcesManagerImpl.getInstance().store(newR);
						}

					} else {
						String msg = "Impossible to update " + internalModel + " from USDL service";
						Fault fault = new Fault();
						fault.setMessage(msg);
						com.petalslink.services_api._1.UpdateServiceFault f = new com.petalslink.services_api._1.UpdateServiceFault();
						f.setFault(fault);
						UpdateServiceFault updateServiceFault = new UpdateServiceFault(msg, f);
						throw updateServiceFault;
					}
				} else {
					Fault fault = new Fault();
					fault.setMessage("Impossible to find service " + id + " from USDL service");
					UpdateServiceFault updateServiceFault = new UpdateServiceFault();
					updateServiceFault.getFaultInfo().setFault(fault);
					throw updateServiceFault;
				}
			}
		} catch (GovException e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.services_api._1.UpdateServiceFault f = new com.petalslink.services_api._1.UpdateServiceFault();
			f.setFault(fault);
			UpdateServiceFault updateServiceFault = new UpdateServiceFault(e.getMessage(), f);
			throw updateServiceFault;
		}
		return response;
	}


	@Override
	public CreateTechnicalOperationResponse createTechnicalOperation(
			CreateTechnicalOperation parameters)throws CreateTechnicalOperationFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public CreateTechnicalProfileResponse createTechnicalProfile(
			CreateTechnicalProfile parameters)throws CreateTechnicalProfileFault {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public CreateTechnicalFaultResponse createTechnicalFault(
			CreateTechnicalFault parameters)throws CreateTechnicalFaultFault {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public GetServiceResponse getService(GetService parameters) throws GetServiceFault {
		GetServiceResponse response = null;
		LOG.fine("Call getService method");
		try {
			QName id = parameters.getIdService();
			Resource r = ResourcesManagerImpl.getInstance().get(id, ServiceResourceType.getInstance());
			if(r != null) {
				XmlObject internalModel = (XmlObject) r.getContent();
				if(internalModel instanceof Definitions) {
					response = new GetServiceResponse();
					response.setService(Wsdl11ToUSDL.getServiceFromWSDL11Service(((Definitions)internalModel).getServiceByName(id.getLocalPart())));
				} else {
					String errorMsg = "Impossible to find service corresponding to this id: " + id;
					Fault fault = new Fault();
					fault.setMessage(errorMsg);
					GetServiceFault businessFault = new GetServiceFault();
					GetServiceFault getServiceFault = new GetServiceFault(errorMsg, businessFault);
					if (getServiceFault.getFaultInfo()!= null){
						getServiceFault.getFaultInfo().setFault(fault);
					}
					throw getServiceFault;
				}
			} else {
				String errorMsg = "Impossible to find service corresponding to this id: " + id;
				Fault fault = new Fault();
				fault.setMessage(errorMsg);
				com.petalslink.services_api._1.GetServiceFault businessFault = new com.petalslink.services_api._1.GetServiceFault();
				businessFault.setFault(fault);
				GetServiceFault getServiceFault = new GetServiceFault(errorMsg, businessFault);
				if (getServiceFault.getFaultInfo()!= null){
					getServiceFault.getFaultInfo().setFault(fault);
				}
				throw getServiceFault;
			}
		} catch (ServicesException e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			GetServiceFault getServiceFault = new GetServiceFault();
			getServiceFault.getFaultInfo().setFault(fault);
			throw getServiceFault;
		} 
		return response;
	}

	@Override
	public GetTechnicalInterfaceResponse getTechnicalInterface(GetTechnicalInterface parameters) throws GetTechnicalInterfaceFault {
		GetTechnicalInterfaceResponse response = null;
		LOG.fine("Call getTechnicalInterface method");
		QName id = parameters.getIdTechnicalInterface();
		try {
			Resource r = ResourcesManagerImpl.getInstance().get(id, InterfaceResourceType.getInstance());
			if(r != null) {
				XmlObject internalModel = (XmlObject) r.getContent();
				if (internalModel instanceof Definitions) {
					response = new GetTechnicalInterfaceResponse();
					Description desc = (Description) Factory.getInstance().wrap((Definitions)internalModel);
					PortType wsdlitf = ((Definitions)internalModel).getPortTypeByName(id.getLocalPart());
					if ( wsdlitf != null ){
						Interface itf = (Interface) Factory.getInstance().wrap(wsdlitf);			
						List<org.petalslink.abslayer.service.api.Service> servs = ((Description) desc).findServicesImplementingInterface(itf);

						response.setTechnicalInterface(Wsdl11ToUSDL.getTechnicalInterfaceFromWSDL11PortType(servs.get(0).getQName(), wsdlitf));
					} 
				} else {
					String errorMsg = "Impossible to find TechnicalInterface corresponding to this id: "+id;
					Fault fault = new Fault();
					fault.setMessage(errorMsg);
					GetTechnicalInterfaceFault businessFault = new GetTechnicalInterfaceFault();
					GetTechnicalInterfaceFault getTechnicalInterfaceFault = new GetTechnicalInterfaceFault(errorMsg, businessFault);
					getTechnicalInterfaceFault.getFaultInfo().setFault(fault);
					throw getTechnicalInterfaceFault;

				}
			}  else {
				String errorMsg = "Impossible to find TechnicalInterface corresponding to this id: "+id;
				Fault fault = new Fault();
				fault.setMessage(errorMsg);
				com.petalslink.services_api._1.GetTechnicalInterfaceFault f = new com.petalslink.services_api._1.GetTechnicalInterfaceFault();
				f.setFault(fault);
				GetTechnicalInterfaceFault getTechnicalServiceFault = new GetTechnicalInterfaceFault(errorMsg, f);
				throw getTechnicalServiceFault;
			}
		} catch (ServicesException e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.services_api._1.GetTechnicalInterfaceFault f = new com.petalslink.services_api._1.GetTechnicalInterfaceFault();
			f.setFault(fault);
			GetTechnicalInterfaceFault getTechnicalServiceFault = new GetTechnicalInterfaceFault(e.getMessage(), f);
			throw getTechnicalServiceFault;
		}
		return response;
	}

	@Override
	public CreateTechnicalInterfaceResponse createTechnicalInterface(
			CreateTechnicalInterface parameters) throws CreateTechnicalInterfaceFault  {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String subscribeOnService(String arg0) {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public GetTechnicalOperationResponse getTechnicalOperation(
			GetTechnicalOperation parameters) throws GetTechnicalOperationFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GetTechnicalProfileResponse getTechnicalProfile(
			GetTechnicalProfile parameters) throws GetTechnicalProfileFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GetTechnicalParameterResponse getTechnicalParameter(
			GetTechnicalParameter parameters) throws GetTechnicalParameterFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GetTechnicalFaultResponse getTechnicalFault(
			GetTechnicalFault parameters)throws GetTechnicalFaultFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GetTechnicalProtocolResponse getTechnicalProtocol(
			GetTechnicalProtocol parameters) throws GetTechnicalProtocolFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GetTechnicalConditionResponse getTechnicalCondition(
			GetTechnicalCondition parameters) throws GetTechnicalConditionFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String addEndPoint(String idTechnicalProtocol) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public FindTechnicalParametersResponse findTechnicalParameters(
			FindTechnicalParameters parameters)throws FindTechnicalParametersFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RemoveTechnicalProfileResponse removeTechnicalProfile(
			RemoveTechnicalProfile parameters)throws RemoveTechnicalProfileFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public FindTechnicalProtocolsResponse findTechnicalProtocols(
			FindTechnicalProtocols parameters)throws FindTechnicalProtocolsFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public FindTechnicalProfilesResponse findTechnicalProfiles(
			FindTechnicalProfiles parameters)throws FindTechnicalProfilesFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public FindTechnicalFaultsResponse findTechnicalFaults(
			FindTechnicalFaults parameters) throws FindTechnicalFaultsFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RemoveTechnicalInterfaceResponse removeTechnicalInterface(
			RemoveTechnicalInterface parameters)throws RemoveTechnicalInterfaceFault {
		RemoveTechnicalInterfaceResponse response=null;
		QName idTit = parameters.getIdTechnicalInterface();
		Resource r = ResourcesManagerImpl.getInstance().get(idTit, InterfaceResourceType.getInstance());
		try { 
			if (r != null) {
				XmlObject internalModel = (XmlObject) r.getContent();
				if (internalModel instanceof Definitions) {
					response = new RemoveTechnicalInterfaceResponse();
					PortType wsdlPortType = ((Definitions)internalModel).getPortTypeByName(idTit.getLocalPart());
					response.setTechnicalInterface(Wsdl11ToUSDL.getTechnicalInterfaceFromWSDL11PortType(idTit, wsdlPortType));
					((Definitions)internalModel).removePortType(wsdlPortType);
				} else {
					Fault fault = new Fault();
					fault.setMessage("Impossible to convert "+internalModel);
					RemoveTechnicalInterfaceFault removeTechnicalInterfaceFault = new RemoveTechnicalInterfaceFault();
					removeTechnicalInterfaceFault.getFaultInfo().setFault(fault);
					throw removeTechnicalInterfaceFault;
				}
			}
		}catch (ServicesException e){
			Fault fault = new Fault();
			fault.setMessage(e.getLocalizedMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			RemoveTechnicalInterfaceFault removeTechnicalInterfaceFault = new RemoveTechnicalInterfaceFault();
			removeTechnicalInterfaceFault.getFaultInfo().setFault(fault);
			throw removeTechnicalInterfaceFault;
		}
		return response;
	}

	@Override
	public RemoveTechnicalConditionResponse removeTechnicalCondition(
			RemoveTechnicalCondition parameters)throws RemoveTechnicalConditionFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public FindTechnicalConditionsResponse findTechnicalConditions(
			FindTechnicalConditions parameters)throws FindTechnicalConditionsFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RemoveTechnicalOperationResponse removeTechnicalOperation(
			RemoveTechnicalOperation parameters)throws RemoveTechnicalOperationFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public FindTechnicalInterfacesResponse findTechnicalInterfaces(
			FindTechnicalInterfaces parameters)throws FindTechnicalInterfacesFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RemoveTechnicalFaultResponse removeTechnicalFault(
			RemoveTechnicalFault parameters)throws RemoveTechnicalFaultFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RemoveTechnicalParameterResponse removeTechnicalParameter(
			RemoveTechnicalParameter parameters)throws RemoveTechnicalParameterFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RemoveTechnicalProtocolResponse removeTechnicalProtocol(
			RemoveTechnicalProtocol parameters)throws RemoveTechnicalProtocolFault {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public FindTechnicalOperationsResponse findTechnicalOperations(
			FindTechnicalOperations parameters)throws FindTechnicalOperationsFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateTechnicalInterfaceResponse updateTechnicalInterface(
			UpdateTechnicalInterface parameters)throws UpdateTechnicalInterfaceFault {

		UpdateTechnicalInterfaceResponse response = null;
		QName id = QName.valueOf(parameters.getTechnicalInterface().getId());
		Resource r = ResourcesManagerImpl.getInstance().get(id, InterfaceResourceType.getInstance());
		try {
			if(parameters.getTechnicalInterface() != null) {
				if(r != null) {
					XmlObject internalModel = (XmlObject) r.getContent();
					if(internalModel instanceof Definitions) {
						response = new UpdateTechnicalInterfaceResponse();
						PortType wsdltit = ((Definitions)internalModel).getPortTypeByName(id.getLocalPart());
						USDLToWSDL11.setTechnicalInterfaceInWSDL11PortType(parameters.getTechnicalInterface(),wsdltit );

						QName newQname = new QName(WsdlHelper.findParentDefinitions(wsdltit).getTargetNamespace(), wsdltit.getName());
						response.setIdTechnicalInterface(newQname);

						if(!newQname.equals(id)) {
							ResourcesManagerImpl.getInstance().remove(id, InterfaceResourceType.getInstance());
							Resource newR = new ResourceImpl(newQname, InterfaceResourceType.getInstance(), internalModel);

							ResourcesManagerImpl.getInstance().store(newR);
						}

					} else {
						String msg = "Impossible to update " + internalModel + " from USDL service";
						Fault fault = new Fault();
						fault.setMessage(msg);
						com.petalslink.services_api._1.UpdateTechnicalInterfaceFault f = new com.petalslink.services_api._1.UpdateTechnicalInterfaceFault();
						f.setFault(fault);
						UpdateTechnicalInterfaceFault updateServiceFault = new UpdateTechnicalInterfaceFault(msg, f);
						throw updateServiceFault;
					}
				} else {
					String msg = "Impossible to find service " + id + " from USDL service";
					Fault fault = new Fault();
					fault.setMessage(msg);
					com.petalslink.services_api._1.UpdateTechnicalInterfaceFault f = new com.petalslink.services_api._1.UpdateTechnicalInterfaceFault();
					f.setFault(fault);
					UpdateTechnicalInterfaceFault updateServiceFault = new UpdateTechnicalInterfaceFault(msg, f);
					throw updateServiceFault;
				}
			}
		} catch (GovException e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.services_api._1.UpdateTechnicalInterfaceFault f = new com.petalslink.services_api._1.UpdateTechnicalInterfaceFault();
			f.setFault(fault);
			UpdateTechnicalInterfaceFault updateServiceFault = new UpdateTechnicalInterfaceFault(e.getMessage(), f);
			throw updateServiceFault;
		}
		return response;

	}

	@Override
	public UpdateTechnicalParameterResponse updateTechnicalParameter(
			UpdateTechnicalParameter parameters)throws UpdateTechnicalParameterFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateTechnicalOperationResponse updateTechnicalOperation(
			UpdateTechnicalOperation parameters)throws UpdateTechnicalOperationFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateTechnicalProtocolResponse updateTechnicalProtocol(
			UpdateTechnicalProtocol parameters)throws UpdateTechnicalProtocolFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateTechnicalFaultResponse updateTechnicalFault(
			UpdateTechnicalFault parameters) throws UpdateTechnicalFaultFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateTechnicalConditionResponse updateTechnicalCondition(
			UpdateTechnicalCondition parameters)throws UpdateTechnicalConditionFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UpdateTechnicalProfileResponse updateTechnicalProfile(
			UpdateTechnicalProfile parameters)throws UpdateTechnicalProfileFault {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public CreateTechnicalParameterResponse createTechnicalParameter(
			CreateTechnicalParameter parameters)throws CreateTechnicalParameterFault {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public PublishServiceResponse publishService(PublishService parameters)
			throws PublishServiceFault {
		PublishServiceResponse res = new PublishServiceResponse();
		try {
			Publish request = new Publish();
			request.setRessourceUrl(parameters.getWsdlUrl());
			PublishResponse response = ResourcesManagerImpl.getInstance().publish(request);
			if(response != null) {
				for(ResourceIdentifier rid: response.getResourceIdentifier()) {
					com.petalslink.services_api._1.ResourceIdentifier rids = new com.petalslink.services_api._1.ResourceIdentifier();
					rids.setId(QName.valueOf(rid.getId()));
					rids.setResourceType(rid.getResourceType());
					res.getResourceIdentifier().add(rids);
				}
			}
		} catch (PublishFault e) {
			Fault fault = new Fault();
			fault.setMessage(e.getMessage());
			com.petalslink.services_api._1.PublishServiceFault f = new com.petalslink.services_api._1.PublishServiceFault();
			f.setFault(fault);
			PublishServiceFault publishServiceFault = new PublishServiceFault(e.getMessage(), f);
			throw publishServiceFault;
		}
		return res;
	}

}
