/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.services.resolver;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.esstar.management.AdminManagementClient;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContent;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContentResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EasyESBURIResolver
implements URIResolver {
    private static Logger log = Logger.getLogger(EasyESBURIResolver.class.getName());
    private String addressResourceEndpoint;
    private String endpoint;
    private List<String> esbNodeAddress = Collections.synchronizedList(new ArrayList());
    private AdminManagementClient client = null;
    private Map<String, List<LinkEndpointAndSource>> sourceCache = Collections.synchronizedMap(new HashMap());

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Source s = null;
        String importLocation = href;
        try {
            if (this.addressResourceEndpoint != null && (s = this.findImportLocationInCache(this.addressResourceEndpoint, importLocation)) == null && this.addressIsKnown(this.addressResourceEndpoint)) {
                GetAdditionalContent payload = new GetAdditionalContent();
                payload.setId(importLocation);
                EJaxbResourceIdentifier rid = new EJaxbResourceIdentifier();
                rid.setId(this.endpoint);
                rid.setResourceType("endpoint");
                payload.setResourceIdentifier(rid);
                this.client = new AdminManagementClient(this.addressResourceEndpoint);
                GetAdditionalContentResponse response = this.client.getAdditionalContent(payload);
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode((Element)response.getAny(), true));
                s = new DOMSource(doc);
                List<LinkEndpointAndSource> rs = this.sourceCache.get(this.addressResourceEndpoint);
                if (rs == null) {
                    rs = new ArrayList<LinkEndpointAndSource>();
                }
                rs.add(new LinkEndpointAndSource(importLocation, this.endpoint, s));
                this.sourceCache.put(this.addressResourceEndpoint, rs);
            }
            if (s == null) {
                throw new TransformerException("Impossible to get: " + importLocation + " on endpoint :" + this.endpoint + " on node : " + this.addressResourceEndpoint);
            }
        }
        catch (Throwable e) {
            log.warning("Impossible to get: " + importLocation + " on endpoint :" + this.endpoint + " on node : " + this.addressResourceEndpoint);
            e.printStackTrace();
            throw new TransformerException("Impossible to get: " + importLocation + " on endpoint :" + this.endpoint + " on node : " + this.addressResourceEndpoint);
        }
        return s;
    }

    private Source findImportLocationInCache(String addressNode, String importLocation) {
        Source s = null;
        List<LinkEndpointAndSource> links = this.sourceCache.get(addressNode);
        if (links != null) {
            for (LinkEndpointAndSource link : links) {
                if (!link.getImportLocation().equals(importLocation)) continue;
                s = link.getSource();
                break;
            }
        }
        return s;
    }

    private boolean addressIsKnown(String address) {
        boolean res = false;
        for (String nodes : this.esbNodeAddress) {
            if (!nodes.equals(address)) continue;
            res = true;
            break;
        }
        return res;
    }

    public String getAddress() {
        return this.addressResourceEndpoint;
    }

    public void setAddress(String address) {
        this.addressResourceEndpoint = address;
    }

    public void addEsbNodeAddress(String node) {
        this.esbNodeAddress.add(node);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    class LinkEndpointAndSource {
        private String endpoint;
        private String importLocation;
        private Source source;

        public LinkEndpointAndSource(String importLocation, String endpoint, Source source) {
            this.endpoint = endpoint;
            this.source = source;
            this.importLocation = importLocation;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public Source getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = source;
        }

        public String getImportLocation() {
            return this.importLocation;
        }

        public void setImportLocation(String importLocation) {
            this.importLocation = importLocation;
        }
    }
}

